package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

@Entity
@Table(name = "cust_login_log")
@org.hibernate.annotations.Table(appliesTo = "cust_login_log", comment = "客户登录日志")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class CustLoginLogDO extends BaseModel implements Serializable {

    @Column(name = "user_id", columnDefinition = "bigint(18) default null  comment '账号ID'")
    private Long userId;

    @Column(name = "user_name", columnDefinition = "varchar(40) default null  comment '登录账号'")
    private String userName;

    @Column(name = "login_time", columnDefinition = "datetime default null  comment '登录时间'")
    private LocalDateTime loginTime;

    @Column(name = "login_ip", columnDefinition = "varchar(40) default null  comment '登录IP'")
    private String loginIp;


}
