package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * SAL_RECEIPTD(销售收款单明细).
 * <p>
 * 销售收款单明细
 *
 * @auther JinXK
 * @date 2021/6/11 18:10
 */
@Entity
@Table(name = "sal_receiptd", indexes = {
        @Index(name = "idx_contract_id", columnList = "contract_id")
})
@org.hibernate.annotations.Table(appliesTo = "sal_receiptd", comment = "销售收款单明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class SalReceiptDDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 3936544591225694993L;

    @Column(name = "mas_id", columnDefinition = "bigint(18) default 0 comment '主表ID'", nullable = false)
    private Long masId;

    @Column(name = "so_id", columnDefinition = "bigint(18) default 0 comment '订单ID'")
    private Long soId;

    @Column(name = "so_no", columnDefinition = "longtext default null  comment '订单编号'")
    private String soNo;

    @Column(name = "so_d_id", columnDefinition = "bigint(18) default 0 comment '销售订单明细ID'")
    private Long soDId;

    @Column(name = "so_line_no", columnDefinition = "decimal(20, 4) default null  comment '行号'")
    private BigDecimal soLineNo;

    @Column(name = "item_id", columnDefinition = "bigint(18) default 0 comment '商品ID'")
    private Long itemId;

    @Column(name = "item_code", columnDefinition = "varchar(40) default null  comment '商品编号'")
    private String itemCode;

    @Column(name = "item_name", columnDefinition = "varchar(255) default null  comment '商品名称'")
    private String itemName;

    @Column(name = "item_name2", columnDefinition = "varchar(100) default null  comment '商品名称2'")
    private String itemName2;

    @Column(name = "item_spec", columnDefinition = "longtext default null  comment '商品规格'")
    private String itemSpec;

    @Column(name = "item_brand", columnDefinition = "longtext default null  comment '品牌'")
    private String itemBrand;

    @Column(name = "so_qty", columnDefinition = "decimal(20, 4) default null  comment '数量'")
    private BigDecimal soQty;

    @Column(name = "so_uom", columnDefinition = "varchar(10) default null  comment '单位'")
    private String soUom;

    @Column(name = "so_tax_rate_no", columnDefinition = "longtext default null  comment '税率编号'")
    private String soTaxRateNo;

    @Column(name = "so_tax_rate", columnDefinition = "decimal(20, 4) default null  comment '税率'")
    private BigDecimal soTaxRate;

    @Column(name = "so_tax_amt", columnDefinition = "decimal(20, 4) default null  comment '税额'")
    private BigDecimal soTaxAmt;

    @Column(name = "so_amt", columnDefinition = "decimal(20, 4) default null  comment '含税金额'")
    private BigDecimal soAmt;

    @Column(name = "receipt_netamt", columnDefinition = "decimal(20, 4) default null  comment '本次收款不含税金额'")
    private BigDecimal receiptNetamt;

    @Column(name = "receipt_amt", columnDefinition = "decimal(20, 4) default null  comment '本次收款金额'")
    private BigDecimal receiptAmt;

    @Column(name = "receipt_tax", columnDefinition = "decimal(20, 4) default null  comment '本次收款税额'")
    private BigDecimal receiptTax;

    @Column(name = "offed_amt", columnDefinition = "decimal(20, 4) default null  comment '已红冲金额'")
    private BigDecimal offedAmt;

    @Column(name = "offing_amt", columnDefinition = "decimal(20, 4) default null  comment '红冲中金额'")
    private BigDecimal offingAmt;

    @Column(name = "relate_doc_id", columnDefinition = "bigint(18) default 0 comment '相关单据ID'")
    private Long relateDocId;

    @Column(name = "relate_doc_no", columnDefinition = "longtext default null  comment '相关单据编号 原始单号'")
    private String relateDocNo;

    @Column(name = "soa_id", columnDefinition = "bigint(18) default null comment '对账单ID'")
    private Long soaId;

    @Column(name = "soa_detail_id", columnDefinition = "bigint(18) default null comment '对账单明细ID'")
    private Long soaDetailId;

    @Column(name = "soa_no", columnDefinition = "varchar(40) default null  comment '对账单编号'")
    private String soaNo;

    @Column(name = "dod_id", columnDefinition = "bigint(18) default null comment '发货单明细ID'")
    private Long dodId;

    @Column(name = "do_doc_no", columnDefinition = "varchar(40) default null  comment '发货单编号'")
    private String doDocNo;

    @Column(name = "contract_id", columnDefinition = "bigint(20) default null comment '合同ID'")
    private Long contractId;

    @Column(name = "contract_code", columnDefinition = "longtext default null  comment '合同编号'")
    private String contractCode;

    @Column(name = "contract_name", columnDefinition = "longtext default null  comment '合同名称'")
    private String contractName;

}
