package com.elitesland.yst.production.sale.event.listener;

import com.alibaba.fastjson.JSON;
import com.elitesland.yst.production.sale.api.dto.BipCartDTO;
import com.elitesland.yst.production.sale.api.dto.CustDTO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipMessageSaveVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.shop.BipMessageConvert;
import com.elitesland.yst.production.sale.entity.BipItemSkuDO;
import com.elitesland.yst.production.sale.entity.BipMessageDO;
import com.elitesland.yst.production.sale.event.ItemPriceReduceEvent;
import com.elitesland.yst.production.sale.repo.CrmCustRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipCartRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipMessageRepo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.concurrent.CompletableFuture;

/**
 * 商品降价提醒监听器
 * @author Kaiser（wang shao）
 * @date 2021/10/10
 */
@Component
@Slf4j
public class ItemPriceReduceListener implements ApplicationListener<ItemPriceReduceEvent> {

    @Autowired
    private BipCartRepoProc bipCartRepoProc;

    @Autowired
    private BipMessageRepo bipMessageRepo;

    @Autowired
    private BipItemSkuRepoProc bipItemSkuRepoProc;

    @Autowired
    private BipCustUserBindRepoProc bipCustUserBindRepoProc;

    @Autowired
    private CrmCustRepoProc crmCustRepoProc;


    @Override
    public void onApplicationEvent(ItemPriceReduceEvent event) {
        log.info("监听到降价事件：{}, {}, {}, {}", event.getItemCode(), event.getPriceType(), event.getPrice(), event.getCustLevel());

        CompletableFuture.runAsync(() -> noticeForShoppingCar(event))
                .exceptionally(e -> {
                    log.error("商品降价通知购物车的用户消息失败【" + event.getItemCode() + "】", e);
                    return null;
                });
    }

    private void noticeForShoppingCar(ItemPriceReduceEvent event) {

        List<BipItemSkuDO> skuDOS = bipItemSkuRepoProc.findSkuByCode(event.getItemCode());

        log.info("商品降价SKU："+JSON.toJSONString(skuDOS));

        if (skuDOS==null||skuDOS.size()==0){
            return;
        }

        BipItemSkuDO skuDO = skuDOS.get(0);

        List<BipCartDTO> carts = bipCartRepoProc.searchCartByCode(skuDO.getId(), event.getPriceType());

        log.info("商品降价消息 event:"+ JSON.toJSONString(event));
        log.info("商品降价消息 carts:"+ JSON.toJSONString(carts));
        log.info("商品降价消息 sku:"+ JSON.toJSONString(skuDO));

        // 创建消息
        for (BipCartDTO cart : carts) {

            Long custId = bipCustUserBindRepoProc.getCustIdByUserId(cart.getUserId());
            CustDTO custDTO = crmCustRepoProc.getCustSimpleInfo(custId);

            if (UdcEnum.PRI_SALE_PRICE_TYPE_GROUP.getValueCode().equals(event.getPriceType())){
                if (!event.getCustLevel().equals(custDTO.getCustLevel())){
                    continue;
                }
            }

            String itemName = skuDO.getItemName();

            BipMessageSaveVO param = new BipMessageSaveVO();

            param.setTitle("【商品降价】");
            param.setStatus(UdcEnum.MESSAGE_STATUS_NOTREAD.getValueCode());
            param.setToCustId(cart.getUserId());
            param.setContext("您添加到购物车的商品"+itemName+"降价了！");

            BipMessageDO bipMessageDO = BipMessageConvert.INSTANCE.voToDo(param);

            bipMessageRepo.save(bipMessageDO);
        }

    }

}
