package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.api.vo.param.sal.SalInvApplyPageParam;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalInvApplyRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalInvSerialVO;
import com.elitesland.yst.production.sale.entity.QSalInvApplyDO;
import com.elitesland.yst.production.sale.entity.QSalInvApplydDO;
import com.elitesland.yst.production.sale.entity.QSalInvSerialDO;
import com.elitesland.yst.production.sale.entity.SalInvSerialDO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
//import com.elitesland.yst.pur.vo.param.PurGrParamVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.val;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;


/**
 * @auther JinXK
 * @date 2021/6/3 11:28
 */
@Repository
public class SalInvApplyRepoProc {
    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    /**
     * 查询字段F
     */
    public JPAQuery<SalInvApplyRespVO> select(SalInvApplyPageParam param) {
        val salInvApply = QSalInvApplyDO.salInvApplyDO;
        val salInvApplyd = QSalInvApplydDO.salInvApplydDO;

        Predicate predicate = salInvApply.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(SalInvApplyRespVO.class,
                salInvApply.id,
                salInvApply.docNo,
                salInvApply.docType,
                salInvApply.docStatus,
                salInvApply.applyEmpId,
                salInvApply.applyName,
                salInvApply.applyPhone,
                salInvApply.applyDate,
                salInvApply.custId,
                salInvApply.custCode,
                salInvApply.custName,
                salInvApply.contractId,
                salInvApply.contractCode,
                salInvApply.contractName,
                salInvApply.invAmt,
                salInvApply.taxAmt,
                salInvApply.planReceiptDate,
                salInvApply.taxRateNo,
                salInvApply.taxRate,
                salInvApply.invTitle,
                salInvApply.taxerNo,
                salInvApply.invType,
                salInvApply.invTel,
                salInvApply.invAddress,
                salInvApply.invPicName,
                salInvApply.invPicPhone,
                salInvApply.invBankName,
                salInvApply.invBankAcc,
                salInvApply.invRecvAddress,
                salInvApply.ouId,
                salInvApply.ouCode,
                salInvApply.ouName,
                salInvApply.soaOrSo,
                salInvApply.buId,
                salInvApply.buName,
                salInvApply.remark,
                salInvApply.saleRegion,
                salInvApply.pushMethod,
                salInvApply.phone,
                salInvApply.email,
                salInvApply.openType,
                salInvApply.offFlag,
                salInvApply.invFlow,
                salInvApply.apprComment,
                salInvApply.relateDocId,
                salInvApply.relateDocNo,
                salInvApply.offInvNo,
                salInvApply.offInvCode,
                salInvApply.invDate,
                salInvApply.offFlowNo
//                salInvApply.soSource,
//                salInvApply.createUserId,
//                salInvApply.createTime,
//                salInvApply.modifyUserId,
//                salInvApply.modifyTime,
//                salInvApply.invBankBranch,
//                salInvApply.applyDesc,
//                salInvApply.apprTime,
//                salInvApply.apprUserId,
//                salInvApply.tenantId

        )).from(salInvApply);
        jpaQuery.leftJoin(salInvApplyd).on(salInvApply.id.eq(salInvApplyd.masId));
        if (param != null) {
            jpaQuery.where(where(param));
        }
        jpaQuery.where(predicate, salInvApply.deleteFlag.eq(0).or(salInvApply.deleteFlag.isNull()));
        jpaQuery.where(predicate, DataAuthJpaUtil.dataAuthJpaPredicate(salInvApply.getMetadata()));
        jpaQuery.groupBy(salInvApply.id);
        return jpaQuery;
    }

    /**
     * 查询允许红冲发票
     */
    public JPAQuery<SalInvSerialVO> getByFlow(Long id) {
        val invSerial = QSalInvSerialDO.salInvSerialDO;

        Predicate predicate = invSerial.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(SalInvSerialVO.class,
                invSerial.id,
                invSerial.masId,
                invSerial.invSerialNo,
                invSerial.invNo,
                invSerial.invCode,
                invSerial.invCheckCode,
                invSerial.invStatus,
                invSerial.invDate,
                invSerial.ePdfUrl,
                invSerial.ouCode,
                invSerial.paperPdfUrl,
                invSerial.state,
                invSerial.isRed

        )).from(invSerial);
        jpaQuery.where(predicate, invSerial.masId.eq(id));
        jpaQuery.where(predicate, invSerial.invNo.notIn(this.subQuery()));
        return jpaQuery;
    }

    /**
     * 条件查询
     *
     * @param param 查询条件
     */
    public Predicate where(SalInvApplyPageParam param) {
        val salInvApply = QSalInvApplyDO.salInvApplyDO;
        val salInvApplyd = QSalInvApplydDO.salInvApplydDO;
        Predicate predicate = salInvApply.isNotNull().or(salInvApply.isNull());

        if (!StringUtils.isEmpty(param.getId())) {
            predicate = ExpressionUtils.and(predicate, salInvApply.id.eq(param.getId()));
        }
        if (!StringUtils.isEmpty(param.getDocType())) {
            predicate = ExpressionUtils.and(predicate, salInvApply.docType.eq(param.getDocType()));
        }
        if (!StringUtils.isEmpty(param.getDocStatus())) {
            predicate = ExpressionUtils.and(predicate, salInvApply.docStatus.eq(param.getDocStatus()));
        }
        if (!StringUtils.isEmpty(param.getSaleRegion())) {
            predicate = ExpressionUtils.and(predicate, salInvApply.saleRegion.eq(param.getSaleRegion()));
        }
        if (!StringUtils.isEmpty(param.getOuCode())) {
            predicate = ExpressionUtils.and(predicate, salInvApply.ouCode.eq(param.getOuCode()));
        }
        if (!StringUtils.isEmpty(param.getOpenType())) {
            predicate = ExpressionUtils.and(predicate, salInvApply.openType.eq(param.getOpenType()));
        }
        if (!StringUtils.isEmpty(param.getContractCode())) {
            predicate = ExpressionUtils.and(predicate, salInvApply.contractCode.like("%"+param.getContractCode()+"%"));
        }
        if (!StringUtils.isEmpty(param.getCustCode())) {
            predicate = ExpressionUtils.and(predicate, salInvApply.custCode.like("%"+param.getCustCode()+"%"));
        }
        if (!StringUtils.isEmpty(param.getDocNo())) {
            predicate = ExpressionUtils.and(predicate, salInvApply.docNo.like("%"+param.getDocNo()+"%"));
        }
        if (!StringUtils.isEmpty(param.getSoNo())) {
            predicate = ExpressionUtils.and(predicate, salInvApplyd.soNo.like("%"+param.getSoNo()+"%"));
        }
        if (!StringUtils.isEmpty(param.getContractName())) {
            predicate = ExpressionUtils.and(predicate, salInvApply.contractName.like("%"+param.getContractName()+"%"));
        }
        if (!StringUtils.isEmpty(param.getCustName())) {
            predicate = ExpressionUtils.and(predicate, salInvApply.custName.like("%"+param.getCustName()+"%"));
        }
        if (!StringUtils.isEmpty(param.getPlanReceiptDateStart())) {
            predicate = ExpressionUtils.and(predicate, salInvApply.planReceiptDate.after(param.getPlanReceiptDateStart()).or(salInvApply.planReceiptDate.eq(param.getPlanReceiptDateStart())));        }
        if (!StringUtils.isEmpty(param.getPlanReceiptDateEnd())) {
            predicate = ExpressionUtils.and(predicate, salInvApply.planReceiptDate.before(param.getPlanReceiptDateEnd()));
        }
        if (!StringUtils.isEmpty(param.getApplyDateStart())) {
            predicate = ExpressionUtils.and(predicate, salInvApply.applyDate.after(param.getApplyDateStart()).or(salInvApply.applyDate.eq(param.getApplyDateStart())));        }
        if (!StringUtils.isEmpty(param.getApplyDateEnd())) {
            predicate = ExpressionUtils.and(predicate, salInvApply.applyDate.before(param.getApplyDateEnd()));
        }
        return predicate;
    }
    /**
     * 子查询
     */
    public JPQLQuery<String> subQuery() {
        val invApply = QSalInvApplyDO.salInvApplyDO;
        Predicate predicate = invApply.offInvNo.isNotNull();
        return JPAExpressions.select(invApply.offInvNo).from(invApply).where(predicate);
    }
}
