package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.entity.SalReceiptDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @auther JinXK
 * @date 2021/6/12 11:25
 */
public interface SalReceiptRepo extends JpaRepository<SalReceiptDO, Long>, QuerydslPredicateExecutor<SalReceiptDO> {
    int countByDocNoLike(String docNo);

    List<SalReceiptDO> findAllByIdIn(List<Long> ids);

    SalReceiptDO findByDocNo(String docNo);

    /**
     * 批准退款单时更新
     * @param openAmt 押金余额
     * @param returningAmt 退款中金额
     * @param relateDocNo 关联单号(原单号)
     * @param auditDataVersion 旧锁版本
     * @param newAuditDataVersion 新锁版本
     * @return id
     */
    @Transactional(rollbackFor = Exception.class)
    @Modifying//增删改必须有这个注解
    @Query(value = "update SalReceiptDO a set a.openAmt = ?1 ,a.returningAmt = ?2 , a.auditDataVersion = ?5 " +
            "where a.docNo = ?3 and a.auditDataVersion= ?4")
    int updateByDocNoAndVersion(BigDecimal openAmt, BigDecimal returningAmt,
                                String relateDocNo, Integer auditDataVersion,Integer newAuditDataVersion);


    /**
     * 退款审批时批准更新
     * @param returningAmt 退款中金额
     * @param id 退款单号id
     * @param auditDataVersion 旧锁版本
     * @param newAuditDataVersion 新锁版本
     * @return id
     */
    @Transactional(rollbackFor = Exception.class)
    @Modifying//增删改必须有这个注解
    @Query(value = "update SalReceiptDO a set a.returningAmt = ?1 ,a.openAmt = ?5, a.auditDataVersion = ?4 " +
            "where a.id = ?2 and a.auditDataVersion= ?3")
    int updateReturningAmtByIdAndVersion( BigDecimal returningAmt ,
                                Long id, Integer auditDataVersion,Integer newAuditDataVersion,BigDecimal openAmt);


    @Transactional(rollbackFor = Exception.class)
    @Modifying//增删改必须有这个注解
    @Query(value = "update SalReceiptDO a set a.returningAmt = ?1 , a.auditDataVersion = ?4 " +
            "where a.id = ?2 and a.auditDataVersion= ?3")
    int updateOpenAmtByIdAndVersion( BigDecimal returningAmt ,
                                Long id, Integer auditDataVersion,Integer newAuditDataVersion);


    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解

    @Query(value = "update sal_receipt set doc_status = ?2 , appr_comment = ?3 , appr_time = ?4 , appr_user_id = ?5 , appr_user_Name = ?6 " +
            "where id = ?1", nativeQuery = true)
    void approveSalPayDeposit(Long id, String docStatus , String apprComment , LocalDateTime apprTime, Long apprUserId,String apprUserName);

    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update sal_receipt set delete_flag = ?2 where id = ?1", nativeQuery = true)
    void deleteSalPayDeposit(Long id, String deleteFlage);
}
