package com.elitesland.yst.production.sale.repo;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsStoreDtlQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsStoreDtlRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsTeamRespVO;
import com.elitesland.yst.production.sale.entity.QSaleStatisticsStoreDO;
import com.elitesland.yst.production.sale.entity.QSaleStatisticsStoreDtlDO;
import com.elitesland.yst.production.sale.entity.SaleStatisticsStoreDtlDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;


/**
 * @author : WWW
 * @date : 2023-5-22
 * @desc : 销售业绩统计-门店-明细RepoProc
 */

@Component
public class SaleStatisticsStoreDtlRepoProc extends BaseRepoProc<SaleStatisticsStoreDtlDO> {

    private static final QSaleStatisticsStoreDtlDO QTY = QSaleStatisticsStoreDtlDO.saleStatisticsStoreDtlDO;
    private static final QSaleStatisticsStoreDO QDO = QSaleStatisticsStoreDO.saleStatisticsStoreDO;

    private final String SHIP_TOTAL_QTY = "shipTotalQty";
    private final String AGENT_EMP = "agentEmp";

    protected SaleStatisticsStoreDtlRepoProc() {

        super(QTY);

    }


    public PagingVO<SaleStatisticsStoreDtlRespVO> page(SaleStatisticsStoreDtlQueryVO saleStatisticsStoreDtlPageParam) {

        JPAQuery<SaleStatisticsStoreDtlRespVO> query = select(SaleStatisticsStoreDtlRespVO.class)
                .where(bulidPredicate(saleStatisticsStoreDtlPageParam));

        saleStatisticsStoreDtlPageParam.setPaging(query);
        saleStatisticsStoreDtlPageParam.fillOrders(query, QTY);

        return PagingVO.<SaleStatisticsStoreDtlRespVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(QTY)
                .set(QTY.deleteFlag, 1)
                .where(QTY.id.in(ids))
                .execute();
        return res;

    }


    public SaleStatisticsStoreDtlRespVO get(Long id) {

        SaleStatisticsStoreDtlRespVO saleStatisticsStoreDtlVO = select(SaleStatisticsStoreDtlRespVO.class)
                .where(QTY.id.eq(id))
                .fetchOne();

        return saleStatisticsStoreDtlVO;

    }


    public List<SaleStatisticsStoreDtlRespVO> getLevelList(SaleStatisticsStoreDtlQueryVO queryVO) {

        List<SaleStatisticsStoreDtlRespVO> res = select(SaleStatisticsStoreDtlRespVO.class)
                .where(bulidLevelList(queryVO))
                .fetch();

        return res;

    }

    public List<SaleStatisticsStoreDtlRespVO> getQueryDtl(SaleStatisticsStoreDtlQueryVO queryVO) {

        Predicate predicate = bulidLevelList(queryVO);
        List<Predicate> predicates = dtlWhere(queryVO);
        JPAQuery<SaleStatisticsStoreDtlRespVO> jpaQuery = jpaQueryFactory.select(
                        Projections.bean(SaleStatisticsStoreDtlRespVO.class,
                                QDO.id))
                .from(QTY).leftJoin(QDO)
                .on(QTY.masId.eq(QDO.id))
                .where(ExpressionUtils.allOf(predicates))
                .where(ExpressionUtils.allOf(predicate));
        jpaQuery.groupBy(QDO.id);
        return jpaQuery.fetch();

    }

    public List<SaleStatisticsTeamRespVO> getListByCodes(SaleStatisticsStoreDtlQueryVO queryVO) {

        List<Predicate> predicates = dtlWhere(queryVO);
        JPAQuery<SaleStatisticsTeamRespVO> jpaQuery = jpaQueryFactory.select(
                        Projections.bean(SaleStatisticsTeamRespVO.class,
                                QTY.code.as(AGENT_EMP),
                                QDO.shipQty.sum().as(SHIP_TOTAL_QTY)))
                .from(QTY).leftJoin(QDO)
                .on(QTY.masId.eq(QDO.id))
                .where(ExpressionUtils.allOf(predicates));
        jpaQuery.groupBy(QTY.code);
        return jpaQuery.fetch();

    }

//    private List<Predicate> where(LocalDateTime minTime, LocalDateTime maxTime) {
//        List<Predicate> predicates = new ArrayList<>();
//
//
//        if (Objects.nonNull(minTime)) {
//            predicates.add(QDO.docTime.goe(minTime));
//        }
//        if (Objects.nonNull(maxTime)) {
//            predicates.add(QDO.docTime.loe(maxTime));
//        }
//        return predicates;
//    }

    private List<Predicate> dtlWhere(SaleStatisticsStoreDtlQueryVO queryVO) {
        List<Predicate> predicates = new ArrayList<>();

        if (!StringUtils.isEmpty(queryVO.getLevel())) {
            predicates.add(QTY.level.eq(queryVO.getLevel()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getMasIds())) {
            predicates.add(QTY.masId.in(queryVO.getMasIds()));
        }
        if (queryVO.getMasId() != null ) {
            predicates.add(QTY.masId.eq(queryVO.getMasId()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getLevels())) {
            predicates.add(QTY.level.in(queryVO.getLevels()));
        }
        if (!StringUtils.isEmpty(queryVO.getName())) {
            predicates.add(QTY.name.in(queryVO.getName()));
        }
        if (!StringUtils.isEmpty(queryVO.getType())) {
            predicates.add(QTY.type.in(queryVO.getName()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getTypes())) {
            predicates.add(QTY.type.in(queryVO.getTypes()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getCodes())) {
            predicates.add(QTY.code.in(queryVO.getCodes()));
        }
        if (queryVO.getUserId() != null ) {
            predicates.add(QTY.userId.eq(queryVO.getUserId()));
        }
        if(queryVO.getDocTimeStart() != null){
            predicates.add(QDO.docTime.goe(queryVO.getDocTimeStart()));
        }
        if(queryVO.getDocTimeEnd() != null){
            predicates.add(QDO.docTime.loe(queryVO.getDocTimeEnd()));
        }
        if (Objects.nonNull(queryVO.getDocMonth())) {
            BooleanExpression booleanTemplate = Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m')", QDO.docTime)
                    .eq(queryVO.getDocMonth());
            predicates.add(booleanTemplate);
        }

        return predicates;
    }

    public List<SaleStatisticsStoreDtlRespVO> getMasIds(List<Long> masIds) {

        List<SaleStatisticsStoreDtlRespVO> res = select(SaleStatisticsStoreDtlRespVO.class)
                .where(QTY.masId.in(masIds))
                .fetch();

        return res;

    }

    public List<SaleStatisticsStoreDtlRespVO> selectByParam(SaleStatisticsStoreDtlQueryVO queryVO) {
        List<Predicate> predicates = dtlWhere(queryVO);
        List<SaleStatisticsStoreDtlRespVO> res = select(SaleStatisticsStoreDtlRespVO.class)
                .where(ExpressionUtils.allOf(predicates))
                .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        QTY.masId,
                        QTY.level,
                        QTY.code,
                        QTY.name,
                        QTY.type,
                        QTY.userId,
                        QTY.id,
                        QTY.createTime,
                        QTY.remark
                )).from(QTY);

    }


    private Predicate bulidPredicate(SaleStatisticsStoreDtlQueryVO saleStatisticsStoreDtlPageParam) {

        Predicate predicate = BaseRepoProc.PredicateBuilder.builder()
                .andEq(null != saleStatisticsStoreDtlPageParam.getMasId(), QTY.masId, saleStatisticsStoreDtlPageParam.getMasId())
                .andEq(StringUtils.isNotBlank(saleStatisticsStoreDtlPageParam.getLevel()), QTY.level, saleStatisticsStoreDtlPageParam.getLevel())
                .andEq(StringUtils.isNotBlank(saleStatisticsStoreDtlPageParam.getCode()), QTY.code, saleStatisticsStoreDtlPageParam.getCode())
                .andEq(StringUtils.isNotBlank(saleStatisticsStoreDtlPageParam.getName()), QTY.name, saleStatisticsStoreDtlPageParam.getName())
                .andEq(StringUtils.isNotBlank(saleStatisticsStoreDtlPageParam.getType()), QTY.type, saleStatisticsStoreDtlPageParam.getType())
                .build();

        return predicate;

    }

    private Predicate bulidLevelList(SaleStatisticsStoreDtlQueryVO queryVO) {

        Predicate predicate = QTY.isNotNull().or(QTY.isNull());
        if (StringUtils.isNotBlank(queryVO.getCode())) {
            predicate = ExpressionUtils.and(predicate, (QTY.code.like("%" + queryVO.getCode() + "%").or(QTY.name.like("%" + queryVO.getCode() + "%"))));
        }
        if (StringUtils.isNotBlank(queryVO.getLevel())) {
            predicate = ExpressionUtils.and(predicate, (QTY.level.eq(queryVO.getLevel())));
        }
        return predicate;

    }

}
