package com.elitesland.yst.production.sale.rmi.ystsupport;



import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemBusinessRpcPagingDTO;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemBusinessRpcPagingParam;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.item.service.ItmItemRpcService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 支撑域 - 商品相关服务
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/5/27 2:42 下午
 */
@Component
@Slf4j
public class RmiItemService {

    @Autowired
    private ItmItemRpcService itmItemRpcService;


    public PagingVO<ItmItemBusinessRpcPagingDTO> findItemBusinessRpcDtoByParam(ItmItemBusinessRpcPagingParam itmItemBusinessRpcPagingParam){
        try {
            return itmItemRpcService.findItemBusinessRpcDtoByParam(itmItemBusinessRpcPagingParam);
        }catch (Exception e) {
            log.error("调用支撑域商品经营目录查询服务异常:{}", e.getMessage());
            throw new BusinessException("调用支撑域商品经营目录查询服务异常"+e,e);
        }
    }

    public List<ItmItemRpcDTO> findItemListByParam(ItmItemRpcDtoParam param) {
        log.info("调用支撑域商品相关服务入参:{}", JSON.toJSONString(param));
        try {
            return itmItemRpcService.findItemRpcDtoByParam(param);
        }catch (Exception e){
            log.error("调用支撑域商品相关服务异常", e);
            throw new BusinessException("调用支撑域商品相关服务异常"+e,e);
        }
    }


}
