package com.elitesland.yst.production.sale.rmi.ystsystem;

import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysAreaRpcService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/04/18
 * @Version 1.0
 * @Content:
 */
@Component
@Slf4j
public class RmiSysAreaRpcService {
    @Autowired
    private SysAreaRpcService sysAreaRpcService;

    /**
     * 根据编号查询行政区域
     *
     * @param areaCodes 行政区域编码
     * @return 行政区域列表
     */
    public List<SysAreaRespDTO> findAreaByCodes(Set<String> areaCodes) {
        log.info("调用system域:根据编号查询行政区域,时间：{},入参：{}", LocalDateTime.now(), areaCodes);
        try {
            if (CollectionUtils.isEmpty(areaCodes)){
                return Collections.emptyList();
            }
            ApiResult<List<SysAreaRespDTO>> apiResult = sysAreaRpcService.listByAreaCodes(areaCodes);
            log.info("调用system域:根据编号查询行政区域,时间：{},出参：{}", LocalDateTime.now(), apiResult);
            if (apiResult.isSuccess()) {
                return apiResult.getData();
            } else {
                throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
            }
        } catch (Exception e) {
            log.error("调用system域:根据编号查询行政区域,error：{}", e.getMessage());
            throw new BusinessException("调用system域:" + e.getMessage());
        }
    }

}
