package com.elitesland.yst.production.sale.search.bean;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * BeanSearcher基类， 只有单表查询可以生效
 * @author chen
 */
@Data
public class BasicsBean implements Serializable {

    private static final long serialVersionUID = 3283710666295031813L;

    /**记录唯一ID**/
    private Long id;

    /**所属租户ID**/
    private Long tenantId;

    /**所属组织ID**/
    private Long belongOrgId;

    /**租户组织ID**/
    private Long tenantOrgId;

    /**备注**/
    private String remark;

    /**记录创建者ID**/
    private Long createUserId;

    /**记录创建者**/
    private String creator;

    /**记录创建时间**/
    private LocalDateTime createTime;

    /**记录最后更新者ID**/
    private Long modifyUserId;

    /**记录最后更新者**/
    private String updater;
    /**记录最后更新时间**/
    private LocalDateTime modifyTime;

    private Integer deleteFlag = 0;

    /**锁版本**/
    private Integer auditDataVersion;


    /**数据归属组织id**/
    private Long secBuId;


    /**数据归属雇员id**/
    private Long secUserId;

    /**数据归属公司id**/
    private Long secOuId;
}
