package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.common.utils.MapUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.core.support.udc.support.SysUdcProxyService;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.ExectRecordTempService;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.ExectRecordTempQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.FileInfoQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.TaskInfoQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.ExectRecordTempDtlRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.ExectRecordTempRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.FileInfoRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoRespVO;
import com.elitesland.yst.production.sale.api.vo.save.ExectRecordTempDtlSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.ExectRecordTempSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.FileInfoSaveVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.ExectRecordTempConvert;
import com.elitesland.yst.production.sale.convert.ExectRecordTempDtlConvert;
import com.elitesland.yst.production.sale.convert.FileinfoConvert;
import com.elitesland.yst.production.sale.entity.ExectRecordTempDO;
import com.elitesland.yst.production.sale.entity.ExectRecordTempDtlDO;
import com.elitesland.yst.production.sale.entity.FileInfoDO;
import com.elitesland.yst.production.sale.repo.*;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import lombok.AllArgsConstructor;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Service
@RequiredArgsConstructor
public class ExectRecordTempServiceImpl implements ExectRecordTempService {

    private final ExectRecordTempRepo exectRecordTempRepo;
    private final ExectRecordTempRepoProc exectRecordTempRepoProc;

    private final ExectRecordTempDtlRepo exectRecordTempDtlRepo;
    private final ExectRecordTempDtlRepoProc exectRecordTempDtlRepoProc;
    private final RmiSysNextNumberService rmiSysNextNumberService;

    private final SysUdcProxyService sysUdcProxyService;

    private final TaskInfoRepoProc taskInfoRepoProc;
    private final FileInfoRepoProc fileInfoRepoProc;
    private final FileInfoRepo fileInfoRepo;

    private final UdcProvider udcProvider;

    @Value("${file.upload.url}")
    private String fileServerUrl;


    @Override
    @Transactional
    public Long save(ExectRecordTempSaveVO saveVO) {
        log.info("执行记录模板入参:" + JSON.toJSONString(saveVO));
        String orderNo= null;

        //1.必填字段非空校验
        this.check(saveVO);
        //2.没有id新增，有id新增修改，增加时发号器发号，修改时使用原单号
        if(saveVO.getId() != null && saveVO.getId() !=0){
            //修改时明细全删全插
            exectRecordTempDtlRepo.deleteByMasId(saveVO.getId());
            //附件表全删全查
            fileInfoRepoProc.sourceDel(Arrays.asList(saveVO.getId()));
        }else{
            //发号器发号
            orderNo = rmiSysNextNumberService.generateCode("yst-sale","MB", new ArrayList<>());
            log.info("执行记录模板发号："+JSON.toJSONString(orderNo));
        }
        //3.模板状态“1”停用，“0“启用,新增单据默认停用
        saveVO.setState(StringUtils.isEmpty(saveVO.getState()) ? "1" : saveVO.getState());
        saveVO.setTempCode(StringUtils.isEmpty(orderNo) ? saveVO.getTempCode() : orderNo);
        ExectRecordTempDO exectRecordTempDO = ExectRecordTempConvert.INSTANCE.voToDO(saveVO);
        Long id = exectRecordTempRepo.save(exectRecordTempDO).getId();

        //4.保存明细数据
        List<ExectRecordTempDtlSaveVO> tempDtlSaveVOS = saveVO.getTempDtlSaveVOS();
        if(!CollectionUtils.isEmpty(tempDtlSaveVOS)){
            List<ExectRecordTempDtlDO> collect = tempDtlSaveVOS.stream().map(t -> {
                ExectRecordTempDtlDO exectRecordTempDtlDO = ExectRecordTempDtlConvert.INSTANCE.voToDO(t);
                exectRecordTempDtlDO.setMasId(id);
                return exectRecordTempDtlDO;
            }).collect(Collectors.toList());
            exectRecordTempDtlRepo.saveAll(collect);
        }
        //5.保存附件数据
        List<FileInfoSaveVO> fileInfoSaveVOS = saveVO.getFileInfoSaveVOS();
        if(!CollectionUtils.isEmpty(fileInfoSaveVOS)){
            List<FileInfoDO> collect = fileInfoSaveVOS.stream().map(t -> {
                FileInfoDO fileInfoDO = FileinfoConvert.INSTANCE.voToDO(t);
                fileInfoDO.setSourceId(id);
                return fileInfoDO;
            }).collect(Collectors.toList());
            fileInfoRepo.saveAll(collect);
        }
        return id;
    }

    @Override
    @SysCodeProc
    public PagingVO<ExectRecordTempRespVO> query(ExectRecordTempQueryVO param) {
        log.info("执行记录模板分页入参"+  JSON.toJSONString(param));
        PagingVO<ExectRecordTempRespVO> page = exectRecordTempRepoProc.page(param);
        page.stream().forEach(t -> t.setState("0".equals(t.getState()) ? "启用" : "停用"));
        this.udcConversion(page.getRecords());
        return page;
    }

    @Override
    @SysCodeProc
    public ExectRecordTempRespVO queryDtl(ExectRecordTempQueryVO param) {
        log.info("执行记录模板明细入参"+  JSON.toJSONString(param));
        if(param.getId() == null || param.getId() == 0){
            throw new BusinessException(ApiCode.FAIL, "id为空，请检查！");
        }
        //查询执行记录表，明细表
        ExectRecordTempRespVO exectRecordTempRespVO = exectRecordTempRepoProc.get(param.getId());
        List<ExectRecordTempDtlRespVO> exectRecordTempDtlRespVOS = exectRecordTempDtlRepoProc.get(param.getId());
        sysUdcProxyService.translate(exectRecordTempDtlRespVOS);
        exectRecordTempRespVO.setTempDtlRespVOS(exectRecordTempDtlRespVOS);
        //查询附件表
        FileInfoQueryVO fileInfoQueryVO = new FileInfoQueryVO();
        fileInfoQueryVO.setSourceId(param.getId());
        List<FileInfoRespVO> list = fileInfoRepoProc.getList(fileInfoQueryVO);
        //更新文件url
        // list.forEach(s -> {
        //     if (StringUtils.isNotBlank(s.getFilePath())){
        //         s.setUrl(fileServerUrl + s.getFilePath());
        //     }
        // });
        exectRecordTempRespVO.setFileInfoRespVOS(list);

        exectRecordTempRespVO.setState("0".equals(exectRecordTempRespVO.getState()) ? "启用" : "停用");
        this.udcConversion(Arrays.asList(exectRecordTempRespVO));
        return exectRecordTempRespVO;
    }
    /**
     * 【启用/停用】按钮逻辑：
     * 点击【启用】按钮时，校验：此任务类型+适用公司，没有启用状态的模版时，可进行启用，保证一个公司的一种任务类型只有唯一一个启用的模版；
     *
     * @param id
     */
    @Override
    @Transactional
    @SysCodeProc
    public void open(Long id) {
        log.info("模板停用接口入参："+JSON.toJSONString(id));
        if(id == null || id == 0){
            throw new BusinessException(ApiCode.FAIL, "id为空，请检查！");
        }

        //状态检验
        ExectRecordTempRespVO exectRecordTempRespVO = exectRecordTempRepoProc.get(id);
        if("0".equals(exectRecordTempRespVO.getState())){
            throw new BusinessException(ApiCode.FAIL, "启用状态模板不需要再次启用");
        }

        //查询启用状态的相同类型的模板
        List<ExectRecordTempRespVO> tempList = new ArrayList<>();
        ExectRecordTempQueryVO exectRecordTempQueryVO = new ExectRecordTempQueryVO();
        List<String> taskList = Arrays.asList(exectRecordTempRespVO.getTaskType().split(";"));
        List<String> ouCodeList = Arrays.asList(exectRecordTempRespVO.getOuCode().split(";"));
        exectRecordTempQueryVO.setTaskTypeList(taskList);
        tempList = exectRecordTempRepoProc.getList(exectRecordTempQueryVO);
        //udc翻译
        this.udcConversion(tempList);
        //唯一校验（一个公司的一种任务类型只有唯一一个启用的模版）
        /*tempList.stream().distinct().forEach(t -> {
            List<String> tempTaskList = Arrays.asList(t.getTaskType().split(";"));
            List<String> tempOuCodeList = Arrays.asList(t.getOuCode().split(";"));
            Collection<String> taskCollect = CollectionUtil.intersection(tempTaskList, taskList);
            Collection<String> ouCodeCollect = CollectionUtil.intersection(tempOuCodeList, ouCodeList);

            if(taskCollect.size()>0 && ouCodeCollect.size()>0){
                throw new BusinessException(ApiCode.FAIL,"公司【"+t.getOuName()+"】已存在任务类型为【"+t.getTaskTypeName()+"】的"+"启用状态的模版");
            }
        });*/

        //启用模板
        this.updateStatus(id,"0");
    }

    private void updateStatus(Long id, String s) {
        exectRecordTempRepoProc.updateStatus(id,s);
    }
    /**
     * 【\停用】按钮逻辑：
     * 将‘启用’状态的模版‘停用’，此时需要校验：将要停用的模版是否还有关联的待执行和进行中的任务，
     * 如果有则提示：需要将关联的进行中的任务取消掉或者完成后，才可以停用此模版！
     * @param id
     */
    @Override
    @Transactional
    @SysCodeProc
    public void stop(Long id) {
        log.info("模板停用接口入参："+JSON.toJSONString(id));
        if(id == null || id == 0){
            throw new BusinessException(ApiCode.FAIL, "id为空，请检查！");
        }

        //状态检验
        ExectRecordTempRespVO exectRecordTempRespVO = exectRecordTempRepoProc.get(id);
        if("1".equals(exectRecordTempRespVO.getState())){
            throw new BusinessException(ApiCode.FAIL, "停用状态模板不需要再次停用");
        }

        //先查询是否存在关联的待执行和进行中的任务 todo
        TaskInfoQueryVO taskInfoQueryVO = new TaskInfoQueryVO();
        taskInfoQueryVO.setExecutTemplateCode(exectRecordTempRespVO.getTempCode());
        List<TaskInfoRespVO> taskInfoRespVOS = taskInfoRepoProc.selectByQueryVO(taskInfoQueryVO);
        List<TaskInfoRespVO> collect = taskInfoRespVOS.stream().filter(t -> UdcEnum.SALESMAN_TASK_STATUS_WEE.getValueCode().equals(t.getState()) || UdcEnum.SALESMAN_TASK_STATUS_IPS.getValueCode().equals(t.getState())).collect(Collectors.toList());

        if(collect.size()>0){
            throw new BusinessException(ApiCode.FAIL, "需要将关联的进行中的任务取消掉或者完成后，才可以停用此模版！");
        }
        //修改状态
        this.updateStatus(id,"1");

    }

    @Override
    public List<ExectRecordTempRespVO> queryByCodes(List<String> codes) {
        log.info("执行记录明细入参"+  JSON.toJSONString(codes));
        if (org.springframework.util.CollectionUtils.isEmpty(codes)){
            return null;
        }
        List<ExectRecordTempRespVO> exectRecordTempRespVOS = exectRecordTempRepoProc.queryByCodes(codes);
        return exectRecordTempRespVOS;
    }


    public List<ExectRecordTempRespVO> queryByCodeAndTask(String taskType,String ouCode) {
        log.info("根据公司编码+任务类型查询模板入参"+  JSON.toJSONString(taskType)+JSON.toJSONString(ouCode));
        if(Optional.ofNullable(taskType).isEmpty() || Optional.ofNullable(ouCode).isEmpty()){
            return null;
        }

        List<ExectRecordTempDO> exectRecordTempDOS = exectRecordTempRepo.queryByCodeAndTask(taskType, ouCode);
        List<ExectRecordTempRespVO> collect = exectRecordTempDOS.stream().map(t -> {
            ExectRecordTempRespVO exectRecordTempRespVO = ExectRecordTempConvert.INSTANCE.doToResp(t);
            exectRecordTempRespVO.setState("0".equals(exectRecordTempRespVO.getState()) ? "启用" : "停用");
            return exectRecordTempRespVO;
        }).collect(Collectors.toList());

        return collect;
    }

    @Override
    public ExectRecordTempRespVO queryByCode(String code) {
        log.info("queryByCode:"+  JSON.toJSONString(code));
        if(StringUtils.isEmpty(code)){
            throw new BusinessException(ApiCode.FAIL, "编码为空，请检查！");
        }
        ExectRecordTempRespVO exectRecordTempRespVO = exectRecordTempRepoProc.queryByCode(code);
        if(Objects.isNull(exectRecordTempRespVO)){
            return null;
        }
        List<ExectRecordTempDtlRespVO> exectRecordTempDtlRespVOS = exectRecordTempDtlRepoProc.get(exectRecordTempRespVO.getId());
        sysUdcProxyService.translate(exectRecordTempDtlRespVOS);
        exectRecordTempRespVO.setTempDtlRespVOS(exectRecordTempDtlRespVOS);
        exectRecordTempRespVO.setState("0".equals(exectRecordTempRespVO.getState()) ? "启用" : "停用");
        return exectRecordTempRespVO;
    }

    /**
     * 必填校验
     * @param saveVO
     */
    private void check(ExectRecordTempSaveVO saveVO) {
        if (saveVO.getTempName() ==null ){
            throw new BusinessException(ApiCode.FAIL, "模板名称为空，请检查！");
        }
        if (saveVO.getOuCode() ==null ){
            throw new BusinessException(ApiCode.FAIL, "公司编码为空，请检查！");
        }
        if (StringUtils.isEmpty(saveVO.getOuId())){
            throw new BusinessException(ApiCode.FAIL, "公司id为空，请检查！");
        }
        if (saveVO.getOuName() ==null){
            throw new BusinessException(ApiCode.FAIL, "公司名称为空，请检查！");
        }
        if (saveVO.getState() ==null){
            throw new BusinessException(ApiCode.FAIL, "状态为空，请检查！");
        }
        if (saveVO.getTaskType() ==null){
            throw new BusinessException(ApiCode.FAIL, "任务类型为空，请检查！");
        }

    }

    /**
     * 拼接udc翻译
     * @param voList
     */
    public void udcConversion (List<ExectRecordTempRespVO> voList){
        Map<String, String> codeMap = udcProvider.getValueMapByUdcCode(UdcEnum.SALESMAN_TASK_TYPE_DST.getModel(), UdcEnum.SALESMAN_TASK_TYPE_DST.getCode());
        voList.stream().forEach(t -> {
            List<String> strings = Arrays.asList(t.getTaskType().split(";"));
            if(CollectionUtils.isNotEmpty(strings) && strings.size()>1){
                strings.stream().forEach(m -> {
                    if (MapUtil.isNotEmpty(codeMap) && codeMap.containsKey(m)) {
                        t.setTaskTypeName(StringUtils.isEmpty(t.getTaskTypeName()) ? codeMap.get(m) : t.getTaskTypeName() + ";" + codeMap.get(m));
                    }
                });
            }
            if(CollectionUtils.isNotEmpty(strings) && strings.size()==1){
                strings.stream().forEach(m -> {
                    if (MapUtil.isNotEmpty(codeMap) && codeMap.containsKey(m)) {
                        t.setTaskTypeName(codeMap.get(m));
                    }
                });
            }

        });

    }

}
