package com.elitesland.yst.production.sale.service;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.ExectRecordService;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.ExecutRecordQueryParam;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.ExecutRecordExportVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

/**
 * @author zhiyu.he
 * @date 2023/11/24 15:07
 */
@Component
@RequiredArgsConstructor
public class ExecutionRecordExportImpl implements DataExport<ExecutRecordExportVO, ExecutRecordQueryParam> {

    private final ExectRecordService exectRecordService;
     @Override
    public String getTmplCode() {
        return "execute_record_export";
    }

    @Override
    public PagingVO<ExecutRecordExportVO> executeExport(ExecutRecordQueryParam queryParam) {
        return exectRecordService.pageExport(queryParam);
    }
}
