package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.IterUtil;
import com.elitesland.yst.production.sale.api.service.LogisticsTemplateDService;
import com.elitesland.yst.production.sale.api.vo.param.logistics.*;
import com.elitesland.yst.production.sale.api.vo.resp.logistics.LogisticsTemplateDVO;
import com.elitesland.yst.production.sale.entity.LogisticsTemplateDDO;
import com.elitesland.yst.production.sale.entity.QLogisticsTemplateDDO;
import com.elitesland.yst.production.sale.repo.LogisticsTemplateDRepo;
import com.elitesland.yst.production.sale.repo.LogisticsTemplateDRepoProc;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.google.common.collect.Lists;
import com.querydsl.core.types.dsl.BooleanExpression;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;


@Service
@Slf4j
@RequiredArgsConstructor
public class LogisticsTemplateDServiceImpl implements LogisticsTemplateDService {

    private final LogisticsTemplateDRepoProc logisticsTemplateDRepoProc;

    private final LogisticsTemplateDRepo logisticsTemplateDDRepo;


    @Override
    @SysCodeProc
    public PagingVO<LogisticsTemplateDVO> findPagingDetailResult(LogisticsTemplateDetailParam param) {
        PagingVO<LogisticsTemplateDVO> list = logisticsTemplateDRepoProc.findPagingDetailResult(param);
       // List<LogisticsTemplateDVO> resList = list.getRecords();
//        if(null != list.getRecords() && !list.getRecords().isEmpty()){
//            list.getRecords().stream().forEach(l ->{
//                l.setArea(l.getProvinceName() + "-" + l.getCityName());
//            });
//        }
        return list;
    }

    @Override
    public ApiResult<Object> saveDetail(List<LogisticsTemplateDetailSaveParam> params) {
        if(!params.isEmpty()){
            params.stream().forEach(param ->{
                LogisticsTemplateDDO logisticsTemplateDDO = new LogisticsTemplateDDO();
                if(null == param.getId() || param.getId() < 0){
                    int max = getMaxLineNo(param.getTemplateId());
                    //新增
                    BeanUtils.copyProperties(param,logisticsTemplateDDO);
                    //行号
                    logisticsTemplateDDO.setLinNo(max + 1);
                }else {
                    Optional<LogisticsTemplateDDO> optional = logisticsTemplateDDRepo.findById(param.getId());
                    if(optional.isPresent()){
                        logisticsTemplateDDO = optional.get();
                        logisticsTemplateDDO.setTemplateId(param.getTemplateId());
                        //logisticsTemplateDDO.setArea(param.getArea());
                        logisticsTemplateDDO.setAddFreight(param.getAddFreight());
                        logisticsTemplateDDO.setPieceNumber(param.getPieceNumber());
                        logisticsTemplateDDO.setContinuypieceNumber(param.getContinuypieceNumber());
                        logisticsTemplateDDO.setMode(param.getMode());
                    }
                }
                logisticsTemplateDDRepo.save(logisticsTemplateDDO);
            });
        }
        return ApiResult.ok();
    }

    @Override
    public ApiResult<Object> delDetail(List<Long> ids) {
        if(null != ids && !ids.isEmpty()){
            ids.stream().forEach(id ->{
                logisticsTemplateDDRepo.deleteById(id);
            });
        }
        return ApiResult.ok();
    }


    @Override
    @SysCodeProc
    public List<LogisticsTemplateDVO> getByArea(LogisticsTemplateDFindParam param) {
        if(StringUtils.isBlank(param.getCityCode())){
            throw new BusinessException("地址信息不正确");
        }
        QLogisticsTemplateDDO qLogisticsTemplateDDO = QLogisticsTemplateDDO.logisticsTemplateDDO;
        BooleanExpression expression = qLogisticsTemplateDDO.templateId.eq(param.getTemplateId());
        if(StringUtils.isNotBlank(param.getArea())){
            expression = expression.and(qLogisticsTemplateDDO.area.like("%" + param.getArea() + "%"));
        }
        if(StringUtils.isNotBlank(param.getCityCode())){
            expression = expression.and(qLogisticsTemplateDDO.cityCode.eq(param.getCityCode()));
        }
        if(StringUtils.isNotBlank(param.getProvinceCode())){
            expression = expression.and(qLogisticsTemplateDDO.provinceCode.eq(param.getProvinceCode()));
        }
        Iterable<LogisticsTemplateDDO> iterables = logisticsTemplateDDRepo.findAll(expression);
        List<LogisticsTemplateDVO> resList = new ArrayList<>();
        if(!IterUtil.isEmpty(iterables)){
            List<LogisticsTemplateDDO> list = Lists.newArrayList(iterables);
            list.stream().forEach(l ->{
                LogisticsTemplateDVO logisticsTemplateDVO = new LogisticsTemplateDVO();
                BeanUtils.copyProperties(l,logisticsTemplateDVO);
                resList.add(logisticsTemplateDVO);
            });
        }
        return resList;
    }

    /**
     * 查询最大行号
     * @param templateId
     * @return
     */
    public Integer getMaxLineNo(Long templateId){
        QLogisticsTemplateDDO qLogisticsTemplateDDO = QLogisticsTemplateDDO.logisticsTemplateDDO;
        BooleanExpression expression = qLogisticsTemplateDDO.templateId.eq(templateId);
        Iterable<LogisticsTemplateDDO> iterables = logisticsTemplateDDRepo.findAll(expression);
        if(!IterUtil.isEmpty(iterables)){
            List<LogisticsTemplateDDO> list = Lists.newArrayList(iterables);
            int max = list.stream().mapToInt(l -> l.getLinNo()).max().getAsInt();
            return max;
        }
        return 1;
    }


}
