package com.elitesland.yst.production.sale.service;

import cn.hutool.core.lang.Assert;
import com.elitesland.yst.production.sale.api.service.SalQuotationDService;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalQuotationDRespVO;
import com.elitesland.yst.production.sale.convert.SalContractDConvert;
import com.elitesland.yst.production.sale.convert.SalQuotationDConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.entity.QSalQuotationDDO;
import com.elitesland.yst.production.sale.entity.SalQuotationDDO;
import com.elitesland.yst.production.sale.repo.SalQuotationDRepo;
import com.elitesland.yst.production.sale.repo.SalQuotationRepo;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.boot.exception.BusinessException;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/16 09:08
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class SalQuotationDServiceImpl extends BaseServiceImpl implements SalQuotationDService {

    private final QSalQuotationDDO qSalQuotationDDO = QSalQuotationDDO.salQuotationDDO;

    private final SalQuotationDRepo salQuotationdRepo;
    @Override
    @SysCodeProc
    public List<SalQuotationDRespVO> findSalQuotationdByMasId(Long id) {
        JPAQuery<SalQuotationDRespVO> salQuotationdRespVo = this.findByMasId(id);
        List<SalQuotationDRespVO> quotationDRespVOS = salQuotationdRespVo.fetch();
        quotationDRespVOS.forEach(quo ->{
            quo.setTaxRate(quo.getTaxRate().multiply(BigDecimal.valueOf(100)));
        });
        return quotationDRespVOS;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<SalQuotationDRespVO> createSalQuotationD(List<SalQuotationDRespVO> salQuotationdRespVoS,Long masId) {
        if (CollectionUtils.isEmpty(salQuotationdRespVoS)){
            return new ArrayList<>();
        }
        try {
            checkForSave(salQuotationdRespVoS);
        } catch (Exception e) {
            log.info( e.getMessage());
            throw new BusinessException("保存失败,请检查必填项");
        }
        salQuotationdRepo.deleteByMasId(masId);
        salQuotationdRespVoS.forEach(sal ->{
            sal.setTaxRate(sal.getTaxRate().divide(BigDecimal.valueOf(100),4, RoundingMode.HALF_UP));
        });
        salQuotationdRepo.saveAll(salQuotationdRespVoS.stream().map(SalQuotationDConvert.INSTANCE::RespVOToDo).collect(Collectors.toList()));
        return salQuotationdRespVoS;
    }
    private void checkForSave(List<SalQuotationDRespVO> salQuotationdRespVoS){
        salQuotationdRespVoS.forEach(sal -> {
//            Assert.isFalse(StringUtils.isEmpty(sal.getItemName()), "保存数据商品名称为空");
            Assert.isFalse(StringUtils.isEmpty(sal.getItemCode()), "保存数据商品编码为空");
//            Assert.isFalse(StringUtils.isEmpty(sal.getItemSpec()), "保存数据商品规格为空");
//            Assert.isFalse(StringUtils.isEmpty(sal.getItemBrand()), "保存数据商品品牌为空");
            Assert.isFalse(StringUtils.isEmpty(sal.getQty()), "保存数据商品数量为空");
        });
    }

    public JPAQuery<SalQuotationDRespVO> findByMasId(Long masId) {

        return jpaQueryFactory.select(Projections.bean(SalQuotationDRespVO.class,
                qSalQuotationDDO.id,
                qSalQuotationDDO.itemId,
                qSalQuotationDDO.itemCode,
                qSalQuotationDDO.itemName,
                qSalQuotationDDO.itemSpec,
                qSalQuotationDDO.itemBrand,
                qSalQuotationDDO.remark,
                qSalQuotationDDO.demandTimespan,
                qSalQuotationDDO.qty,
                qSalQuotationDDO.uom,
                qSalQuotationDDO.netPrice,
                qSalQuotationDDO.netAmt,
                qSalQuotationDDO.price,
                qSalQuotationDDO.amt,
                qSalQuotationDDO.taxAmt,
                qSalQuotationDDO.taxRate,
                qSalQuotationDDO.taxRateDesc,
                qSalQuotationDDO.discRatio,
                qSalQuotationDDO.taxRateNo,
                qSalQuotationDDO.discAmt,
                qSalQuotationDDO.priceOrig,
                qSalQuotationDDO.lineType,
                qSalQuotationDDO.lineNo
        )).from(qSalQuotationDDO)
                .where(qSalQuotationDDO.masId.eq(masId));
    }
}
