package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.collection.IterUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.shop.BipCouponCustService;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponCustCurrentParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponCustItemParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponQueryParam;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCouponCustVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCouponIndexVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.*;
import com.elitesland.yst.production.sale.repo.shop.*;
import com.elitesland.yst.production.support.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.google.common.collect.Lists;
import com.querydsl.core.types.dsl.BooleanExpression;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;

import static java.util.Comparator.comparing;
import static java.util.stream.Collectors.collectingAndThen;
import static java.util.stream.Collectors.toCollection;

/**
 * <p>
 * 优惠卷业务实现
 * </p>
 *
 * @author Shadow
 * @since 2021-08-11 09:17:11
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class BipCouponCustServiceImpl implements BipCouponCustService {

    private final BipCouponCustRepo bipCouponCustRepo;

    private final BipCouponRepo bipCouponRepo;

    private final BipCouponCustRepoProc bipCouponCustRepoProc;

    private final OrgEmpRpcService orgEmpRpcService;

    private final BipCouponItemRepo bipCouponItemRepo;

    private final BipCouponIndexImgRepo bipCouponIndexImgRepo;

    private final BipCustUserBindRepoProc bipCustUserBindRepoProc;

    private final BipCustUserBindRepo bipCustUserBindRepo;

    @Autowired
    private BipOrderService bipOrderService;

    @Override
    public void deleteCouponCust(Long id) {
        Optional<BipCouponCustDo> optional = bipCouponCustRepo.findById(id);
        if(optional.isPresent()){
            BipCouponCustDo bipCouponCustDo = optional.get();
            bipCouponCustDo.setDeleteFlag(1);
            bipCouponCustDo.setUseStatus(UdcEnum.SAL_COUPON_USE_STATUS_DEL.getValueCode());
            bipCouponCustRepo.save(bipCouponCustDo);
        }
    }



    /**
     * 加购物车时候查询可用优惠券
     * @param param
     * @return
     */
    @Override
    @SysCodeProc
    public List<BipCouponCustVO> currentUserCouponCust(BipCouponCustCurrentParam param) {
        //修改过期优惠券状态
        excuteOverDue(param.getOuId());
        List<BipCouponCustVO> list = new ArrayList<>();
        //查询当前用户所有可用优惠券
        List<BipCouponCustDo> availableList = getAvailableCouponCust(param.getUserId(),param);
        if(availableList==null||availableList.isEmpty()){
            return null;
        }
        availableList.stream().forEach(available ->{
            BipCouponDO bipCouponDO = getByCouponId(available.getCouponId());
            if(bipCouponDO.getState().equals(UdcEnum.SAL_COUPON_STATE_ACTIVE.getValueCode())){
                List<BipCouponItemDO> items = getItemByCouponId(available.getCouponId());
                if(null != items && !items.isEmpty()){
                    List<BipCouponCustItemParam> params = param.getList();
                    if(null != params && !params.isEmpty()){
                        params.stream().forEach(p ->{
                            if(null != p.getSkuId()){
                                List<Long> skuIdList = items.stream().filter(x -> null != x.getSkuId()).map(BipCouponItemDO::getSkuId).collect(Collectors.toList());
                                if(!skuIdList.isEmpty() && skuIdList.contains(p.getSkuId())){
                                    //取出优惠券信息
                                    BipCouponCustVO bipCouponCustVO = new BipCouponCustVO();
                                    BeanUtils.copyProperties(available,bipCouponCustVO);
                                    bipCouponCustVO.setValidEtime(bipCouponDO.getValidEtime());
                                    bipCouponCustVO.setValidStime(bipCouponDO.getValidStime());
                                    bipCouponCustVO.setState(bipCouponDO.getState());
                                    bipCouponCustVO.setLimitAmt(bipCouponDO.getLimitAmt());
                                    bipCouponCustVO.setFreeAmt(bipCouponDO.getFreeAmt());
                                    bipCouponCustVO.setMatchType(bipCouponDO.getMatchType());
                                    bipCouponCustVO.setCouponName(bipCouponDO.getCouponName());
                                    bipCouponCustVO.setDetailInfo(bipCouponDO.getDetailInfo());
                                    bipCouponCustVO.setType(bipCouponDO.getType());
                                    list.add(bipCouponCustVO);
                                    //满减   如果商品总价小于满减最低金额
                                    if(bipCouponDO.getType().equals(UdcEnum.SAL_COUPON_TYPE_FULL.getValueCode()) && p.getTotalAmount().compareTo(available.getLimitAmt()) == -1){
                                        //去除优惠券信息
                                        list.remove(bipCouponCustVO);
                                    }
                                }
                            }
                        });
                    }
//                //品类：CATEGORY    商品:COMMODITY
//                if(bipCouponDO.getMatchType().equals(UdcEnum.SAL_COUPON_USE_TYPE_CATEGORY.getValueCode())){
//                    List<Long> categoryIdList = items.stream().filter(x -> null != x.getCategoryId()).map(BipCouponItemDO::getCategoryId).collect(Collectors.toList());
//                    if(!categoryIdList.isEmpty() && categoryIdList.contains(param.getCategoryId())){
//                        BipCouponCustVO bipCouponCustVO = new BipCouponCustVO();
//                        BeanUtils.copyProperties(available,bipCouponCustVO);
//                        list.add(bipCouponCustVO);
//                        //满减  优惠券规则满减金额大于商品购买金额
//                        if(bipCouponDO.getType().equals(UdcEnum.SAL_COUPON_TYPE_FULL.getValueCode()) && available.getLimitAmt().compareTo(param.getTotalAmount()) == 1){
//                            //去除优惠券信息
//                            list.remove(bipCouponCustVO);
//                        }
//                    }
//                }
//                //按商品
//                if(bipCouponDO.getMatchType().equals(UdcEnum.SAL_COUPON_USE_TYPE_COMMODITY.getValueCode())){
//                    List<Long> commodityList = items.stream().filter(x -> null != x.getItemId()).map(BipCouponItemDO::getItemId).collect(Collectors.toList());
//                    if(!commodityList.isEmpty() && commodityList.contains(param.getItemId())){
//                        //取出优惠券信息
//                        BipCouponCustVO bipCouponCustVO = new BipCouponCustVO();
//                        BeanUtils.copyProperties(available,bipCouponCustVO);
//                        list.add(bipCouponCustVO);
//                        //满减  优惠券规则满减金额大于商品购买金额
//                        if(bipCouponDO.getType().equals(UdcEnum.SAL_COUPON_TYPE_FULL.getValueCode()) && available.getLimitAmt().compareTo(param.getTotalAmount()) == 1){
//                            //去除优惠券信息
//                            list.remove(bipCouponCustVO);
//                        }
//                    }
//                }
                }
            }
        });
        if(null != list && !list.isEmpty()){
            return list.stream().collect(
                    collectingAndThen(
                            toCollection(() -> new TreeSet<>(comparing(n->n.getCouponId()))),ArrayList::new)
            );
        }
        return list;
    }

    public List<BipCouponItemDO> getItemByCouponId(Long couponId){
        QBipCouponItemDO qBipCouponItemDO = QBipCouponItemDO.bipCouponItemDO;
        BooleanExpression expression = qBipCouponItemDO.couponId.eq(couponId);
        Iterable<BipCouponItemDO> iterables = bipCouponItemRepo.findAll(expression);
        if(!IterUtil.isEmpty(iterables)){
            return Lists.newArrayList(iterables);
        }
        return null;
    }

    public BipCouponDO getByCouponId(Long couponId){
        Optional<BipCouponDO> optional = bipCouponRepo.findById(couponId);
        return optional.get();
    }

    public List<BipCouponCustDo> getAvailableCouponCust(Long userId,BipCouponCustCurrentParam param){
        List<BipCouponCustDo> resList = new ArrayList<>();
        //通过userId查询客户信息
        QBipCustUserBindDO qBipCustUserBindDO = QBipCustUserBindDO.bipCustUserBindDO;
        BooleanExpression e = qBipCustUserBindDO.deleteFlag.eq(0).and(qBipCustUserBindDO.userId.eq(userId));
        Optional<BipCustUserBindDO> optional = bipCustUserBindRepo.findOne(e);
        BipCustUserBindDO bipCustUserBindDO = new BipCustUserBindDO();
        if(optional.isPresent()){
            bipCustUserBindDO = optional.get();
            if(null == bipCustUserBindDO.getCustId()){
                return null;
            }
        }else {
            return null;
        }
        QBipCouponCustDo qBipCouponCustDo = QBipCouponCustDo.bipCouponCustDo;
        BooleanExpression expression = qBipCouponCustDo.userId.eq(userId).and(qBipCouponCustDo.useStatus.eq(UdcEnum.SAL_COUPON_USE_STATUS_NOTUSED.getValueCode())).and(qBipCouponCustDo.deleteFlag.eq(0)).and(qBipCouponCustDo.custId.eq(bipCustUserBindDO.getCustId()));
        Iterable<BipCouponCustDo> iterables = bipCouponCustRepo.findAll(expression);
        if(!IterUtil.isEmpty(iterables)){
            List<BipCouponCustDo> list = Lists.newArrayList(iterables);
            list.stream().forEach(cust ->{
//                Long couponId = cust.getCouponId();
//                QBipCouponItemDO qBipCouponItemDO = QBipCouponItemDO.bipCouponItemDO;
//
//                BooleanExpression b = qBipCouponItemDO.couponId.eq(couponId).and(qBipCouponItemDO.skuId.eq(param.getSkuId())).and(qBipCouponItemDO.deleteFlag.eq(0));
//                Iterable<BipCouponItemDO> items = bipCouponItemRepo.findAll(b);
//                if(!IterUtil.isEmpty(items)){
                    //List<BipCouponItemDO> l = Lists.newArrayList(items);
                    resList.add(cust);
            //    }
            });

//            List<BipCouponCustDo> resList = new ArrayList<>();
//            list.stream().forEach(l ->{
//                List<BipCouponItemDO> items = getCouponItemByCouponId(l.getCouponId());
//                //品类
//                if(l.getMatchType().equals(UdcEnum.SAL_COUPON_USE_TYPE_CATEGORY.getValueCode()) && null != param.getCategoryId()){
//                    if(null != items){
//                        List<Long> categorgIds = items.stream().map(BipCouponItemDO :: getCategoryId).collect(Collectors.toList());
//                        if(categorgIds.contains(param.getCategoryId())){
//                            resList.add(l);
//                        }
//                    }
//                }
//                //品类
//                if(l.getMatchType().equals(UdcEnum.SAL_COUPON_USE_TYPE_COMMODITY.getValueCode()) && null != param.getItemId()){
//                    if(null != items){
//                        List<Long> itemIds = items.stream().map(BipCouponItemDO :: getItemId).collect(Collectors.toList());
//                        if(itemIds.contains(param.getItemId())){
//                            resList.add(l);
//                        }
//                    }
//                }
//            });
//            if(null == param.getCategoryId() || null == param.getItemId()){
//                return list;
//            }
            return resList;
        }
        return null;
    }


    public List<BipCouponItemDO> getCouponItemByCouponId(Long couponId){
        QBipCouponItemDO qBipCouponItemDO = QBipCouponItemDO.bipCouponItemDO;
        BooleanExpression expression = qBipCouponItemDO.couponId.eq(couponId);
        Iterable<BipCouponItemDO> iterables = bipCouponItemRepo.findAll(expression);
        if(!IterUtil.isEmpty(iterables)){
            return Lists.newArrayList(iterables);
        }
        return null;
    }


    @Override
    public void paySuccessUpdateCouponStatus(Long id,String status) {
        Optional<BipCouponCustDo> optional = bipCouponCustRepo.findById(id);
        if(optional.isPresent()){
            BipCouponCustDo bipCouponCustDo = optional.get();
            bipCouponCustDo.setUseStatus(status);
            bipCouponCustRepo.save(bipCouponCustDo);
        }
    }

    @Override
    public void modifyCouponCustUseStatus(Long id, String status) {
        Optional<BipCouponCustDo> optional = bipCouponCustRepo.findById(id);
        if(optional.isPresent()){
            BipCouponCustDo bipCouponCustDo = optional.get();
            bipCouponCustDo.setUseStatus(status);
            bipCouponCustRepo.save(bipCouponCustDo);
        }
    }

    @Override
    public void modifyOrderCouponCustUseStatus(Long couponId, String status) {
        CurrentUserDTO user = UserService.currentUser();
        if(null != user && null != user.getUserId()){
            QBipCouponCustDo qBipCouponCustDo = QBipCouponCustDo.bipCouponCustDo;
            BooleanExpression expression = qBipCouponCustDo.couponId.eq(couponId).and(qBipCouponCustDo.userId.eq(user.getUserId()));
            Iterable<BipCouponCustDo> iterables = bipCouponCustRepo.findAll(expression);
            if(!IterUtil.isEmpty(iterables)){
                List<BipCouponCustDo> list = Lists.newArrayList(iterables);
                list.stream().forEach(l ->{
                    l.setUseStatus(status);
                    bipCouponCustRepo.save(l);
                });
            }
        }
    }

    @Override
    @SysCodeProc
    public BipCouponIndexVO indexPageShow() {
        //根据userId更改优惠券过期状态
        OrgUserEmpInfoRpcDTO empInfo = getCurrentOuIdInfo();
        excuteOverDueByUserId(empInfo.getUserId());
        List<BipCouponCustVO> resList = new ArrayList<>();
        BipCouponIndexVO bipCouponIndexVO = new BipCouponIndexVO();
        QBipCustUserBindDO qBipCustUserBindDO = QBipCustUserBindDO.bipCustUserBindDO;
        BooleanExpression e = qBipCustUserBindDO.deleteFlag.eq(0).and(qBipCustUserBindDO.userId.eq(empInfo.getUserId()));
        Optional<BipCustUserBindDO> optional = bipCustUserBindRepo.findOne(e);
        BipCustUserBindDO bipCustUserBindDO = new BipCustUserBindDO();
        if(optional.isPresent()){
            bipCustUserBindDO = optional.get();
            if(null == bipCustUserBindDO.getCustId()){
                return null;
            }
        }else {
            return null;
        }
        QBipCouponCustDo qBipCouponCustDo = QBipCouponCustDo.bipCouponCustDo;
        BooleanExpression expression = qBipCouponCustDo.userId.eq(empInfo.getUserId()).and(qBipCouponCustDo.useStatus.eq(UdcEnum.SAL_COUPON_USE_STATUS_NOTUSED.getValueCode())).and(qBipCouponCustDo.deleteFlag.eq(0)).and(qBipCouponCustDo.custId.eq(bipCustUserBindDO.getCustId()));
        Iterable<BipCouponCustDo> iterables = bipCouponCustRepo.findAll(expression);
        if(!IterUtil.isEmpty(iterables)){
            List<BipCouponCustDo> list = Lists.newArrayList(iterables);
            List<BipCouponCustDo> notUseList = getNotUseCoupon(list);
            LocalDateTime now = LocalDateTime.now();
            if(!notUseList.isEmpty()){
                notUseList.stream().forEach(notList ->{
                    BipCouponDO bipCouponDO = getByCouponId(notList.getCouponId());
                    if(null != bipCouponDO.getNotifyDays() && null != bipCouponDO.getValidEtime()){
                        Integer notifyDays = bipCouponDO.getNotifyDays();
                        LocalDateTime validETime = bipCouponDO.getValidEtime();
                        LocalDateTime remindTime = validETime.minusDays(notifyDays);
                        if(now.isAfter(remindTime) && now.isBefore(validETime)){
                            BipCouponCustVO bipCouponCustVO = new BipCouponCustVO();
                            BeanUtils.copyProperties(notList,bipCouponCustVO);
                            bipCouponCustVO.setValidEtime(bipCouponDO.getValidEtime());
                            bipCouponCustVO.setValidStime(bipCouponDO.getValidStime());
                            bipCouponCustVO.setState(bipCouponDO.getState());
                            bipCouponCustVO.setLimitAmt(bipCouponDO.getLimitAmt());
                            bipCouponCustVO.setFreeAmt(bipCouponDO.getFreeAmt());
                            bipCouponCustVO.setMatchType(bipCouponDO.getMatchType());
                            bipCouponCustVO.setCouponName(bipCouponDO.getCouponName());
                            bipCouponCustVO.setDetailInfo(bipCouponDO.getDetailInfo());
                            bipCouponCustVO.setType(bipCouponDO.getType());
                            resList.add(bipCouponCustVO);
                        }
                    }
                });
            }
        }
        if(!resList.isEmpty()){
            bipCouponIndexVO.setCouponList(resList);
            //查询优惠券背景图 通过ouId查询公司上传的优惠券背景图
 //           BipCouponIndexImgDO d = getIndexImgByOuId(empInfo.getOuId());
//            BipCouponIndexImgVO bipCouponIndexImgVO = new BipCouponIndexImgVO();
//            BeanUtils.copyProperties(d,bipCouponIndexImgVO);
//            bipCouponIndexVO.setBipCouponIndexImgVO(bipCouponIndexImgVO);
        }

        return bipCouponIndexVO;
    }



    public BipCouponIndexImgDO getIndexImgByOuId(Long ouId){
        QBipCouponIndexImgDO qBipCouponIndexImgDO = QBipCouponIndexImgDO.bipCouponIndexImgDO;
        BooleanExpression expression = qBipCouponIndexImgDO.ouId.eq(ouId).and(qBipCouponIndexImgDO.deleteFlag.eq(0));
        Optional<BipCouponIndexImgDO> optional = bipCouponIndexImgRepo.findOne(expression);
        if(optional.isPresent()){
            return optional.get();
        }
        return null;
    }


    public List<BipCouponCustDo> getNotUseCoupon(List<BipCouponCustDo> list){
        List<BipCouponCustDo> resList = new ArrayList<>();
        list.stream().forEach(l ->{
            Long couponId = l.getCouponId();
            Optional<BipCouponDO> optional = bipCouponRepo.findById(couponId);
            if(optional.isPresent()){
                BipCouponDO bipCouponDO = optional.get();
                //提前几天通知
                Integer notifyDays = bipCouponDO.getNotifyDays();
                if(null != notifyDays){
                    LocalDateTime notifyDateTime = bipCouponDO.getValidEtime();
                    Duration duration = Duration.between(LocalDateTime.now(),notifyDateTime);
                    long days = duration.toDays();
                    if(days >= 0 && days <= notifyDays){
                        resList.add(l);
                    }
                }
            }
        });
        return resList;
    }



    @Override
    @SysCodeProc
    public PagingVO<BipCouponCustVO> pageSearch(BipCouponQueryParam param) {
        OrgUserEmpInfoRpcDTO empInfo = getCurrentEmpInfo();

        if(null == empInfo.getOuId()){
            return new PagingVO<>();
        }
        //修改过期优惠券状态
        excuteOverDue(empInfo.getOuId());
        PagingVO<BipCouponCustVO> pagingVO = bipCouponCustRepoProc.pageSearch(param);
        List<BipCouponCustVO> list = pagingVO.getRecords();
        list.stream().forEach(l ->{
            BipCouponDO couponDO = getCouponStateByCouponId(l.getCouponId());
            if(null != couponDO){
                l.setDetailInfo(StringUtils.isNotBlank(couponDO.getDetailInfo()) ? couponDO.getDetailInfo():null);
                l.setLimitAmt(couponDO.getLimitAmt() != null ? couponDO.getLimitAmt():null);
                l.setFreeAmt(couponDO.getFreeAmt() != null ? couponDO.getFreeAmt():null);
                l.setMatchType(StringUtils.isNotBlank(couponDO.getMatchType()) ? couponDO.getMatchType():null);
                l.setType(StringUtils.isNotBlank(couponDO.getType()) ? couponDO.getType():null);
                l.setValidEtime(couponDO.getValidEtime() != null ? couponDO.getValidEtime():null);
                l.setValidStime(couponDO.getValidStime() != null ? couponDO.getValidStime():null);
                l.setState(couponDO.getState() != null ? couponDO.getState():null);
            }
        });
        pagingVO.setRecords(list);
        return pagingVO;
    }

    public BipCouponDO getCouponStateByCouponId(Long id){
        Optional<BipCouponDO> optional = bipCouponRepo.findById(id);
        if(optional.isPresent()){
            return optional.get();
        }
        return null;
    }

    @Override
    @SysCodeProc
    public List<BipCouponCustVO> searchCouponCust(String useStatus,Long userId) {
    //    OrgUserEmpInfoRpcDTO empInfo = getCurrentEmpInfo();
        //处理过期优惠券
        excuteOverDueByUserId(userId);
        //查询当前用户绑定的客户ID
        QBipCustUserBindDO qBipCustUserBindDO = QBipCustUserBindDO.bipCustUserBindDO;
        BooleanExpression e = qBipCustUserBindDO.deleteFlag.eq(0).and(qBipCustUserBindDO.userId.eq(userId));
        Optional<BipCustUserBindDO> option = bipCustUserBindRepo.findOne(e);
        if(!option.isEmpty()){
            BipCustUserBindDO bipCustUserBindDO = option.get();
            if(null != bipCustUserBindDO.getCustId()){
                QBipCouponCustDo qBipCouponCustDo = QBipCouponCustDo.bipCouponCustDo;
                BooleanExpression expression = qBipCouponCustDo.useStatus.eq(useStatus).and(qBipCouponCustDo.userId.eq(userId)).and(qBipCouponCustDo.custId.eq(bipCustUserBindDO.getCustId())).and(qBipCouponCustDo.deleteFlag.eq(0));
                Iterable<BipCouponCustDo> iterables = bipCouponCustRepo.findAll(expression);
                if(!IterUtil.isEmpty(iterables)){
                    List<BipCouponCustVO> resList = new ArrayList<>();
                    List<BipCouponCustDo> list = Lists.newArrayList(iterables);
                    list.stream().forEach(l ->{
                        Optional<BipCouponDO> optional = bipCouponRepo.findById(l.getCouponId());
                        //查询优惠券已激活状态
                        if(optional.isPresent() && optional.get().getState().equals(UdcEnum.SAL_COUPON_STATE_ACTIVE.getValueCode())){
                            BipCouponDO bipCouponDO = optional.get();
                            BipCouponCustVO vo = new BipCouponCustVO();
                            BeanUtils.copyProperties(l,vo);
                            vo.setDetailInfo(bipCouponDO.getDetailInfo());
                            vo.setFreeAmt(bipCouponDO.getFreeAmt());
                            vo.setLimitAmt(bipCouponDO.getLimitAmt());
                            vo.setMatchType(bipCouponDO.getMatchType());
                            vo.setValidStime(bipCouponDO.getValidStime());
                            vo.setValidEtime(bipCouponDO.getValidEtime());
                            vo.setState(bipCouponDO.getState());
                            vo.setCouponName(bipCouponDO.getCouponName());
                            resList.add(vo);
                        }
                    });
                    return resList;
                }
            }
        }
        return null;
    }


    @Override
    public void newUserReceiveCoupon() {
        OrgUserEmpInfoRpcDTO empInfo = getCurrentOuIdInfo();
        Long ouId = empInfo.getOuId();
        if(null == ouId){
            return;
        }
        BipCustUserBindDO bipCustUserBindDO = new BipCustUserBindDO();
        if(null != empInfo.getUserId()){
            //通过userId查询客户信息
            QBipCustUserBindDO qBipCustUserBindDO = QBipCustUserBindDO.bipCustUserBindDO;
            BooleanExpression e = qBipCustUserBindDO.deleteFlag.eq(0).and(qBipCustUserBindDO.userId.eq(empInfo.getUserId()));
            Optional<BipCustUserBindDO> optional = bipCustUserBindRepo.findOne(e);
            if(optional.isPresent()){
                bipCustUserBindDO = optional.get();
                if(null == bipCustUserBindDO.getCustId()){
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户未绑定客户，不能领取优惠券");
                }
            }else {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户未绑定客户，不能领取优惠券");
            }
        }
        //是否支付过，新人券是要没支付过的用户领取
        CurrentUserDTO currentUser = UserService.currentUser();
        Boolean isPay = bipOrderService.isFirstOrder(currentUser.getUserId(),"ps");
        if(!isPay){
            //新用户
            QBipCouponDO qBipCouponDO = QBipCouponDO.bipCouponDO;
            BooleanExpression expression = qBipCouponDO.deleteFlag.eq(0).and(qBipCouponDO.ouId.eq(ouId)).and(qBipCouponDO.newCustShow.eq("1")).and(qBipCouponDO.newCustStime.gt(LocalDateTime.now())).and(qBipCouponDO.newCustEtime.lt(LocalDateTime.now()));
            Iterable<BipCouponDO> iterables = bipCouponRepo.findAll(expression);
            if(!IterUtil.isEmpty(iterables)){
                List<BipCouponDO> list = Lists.newArrayList(iterables);
                BipCustUserBindDO finalBipCustUserBindDO = bipCustUserBindDO;
                list.stream().forEach(bipCouponDO ->{
                    //是否领取过
                    if(!isReceiveCouponCust(bipCouponDO.getId(),currentUser.getUserId(),ouId)){
                        //正常领取
                        BipCouponCustDo bipCouponCustDo = new BipCouponCustDo();
                        BeanUtils.copyProperties(bipCouponDO,bipCouponCustDo);
                        bipCouponCustDo.setCouponId(bipCouponDO.getId());
                        bipCouponCustDo.setUserId(empInfo.getUserId());
                        bipCouponCustDo.setUserName(empInfo.getUserName());
                        bipCouponCustDo.setUseStatus(UdcEnum.SAL_COUPON_USE_STATUS_NOTUSED.getValueCode());
                        bipCouponCustDo.setCustId(finalBipCustUserBindDO.getCustId());
                        bipCouponCustDo.setCustName(finalBipCustUserBindDO.getCustName());
                        bipCouponCustDo.setCustCode(finalBipCustUserBindDO.getCustCode());
                        bipCouponCustDo.setId(null);
                        bipCouponCustRepo.save(bipCouponCustDo);
                        //优惠券数量-1
                        bipCouponDO.setTotalNum(bipCouponDO.getTotalNum() - 1);
                        //已领取数量+1
                        bipCouponDO.setReceiveNum(bipCouponDO.getReceiveNum() + 1);
                        bipCouponRepo.save(bipCouponDO);
                    }
                });
            }
        }
    }

    //查询是否领取过
    public Boolean isReceiveCouponCust(Long couponId,Long userId,Long ouId){
        QBipCouponCustDo qBipCouponCustDo = QBipCouponCustDo.bipCouponCustDo;
        BooleanExpression expression = qBipCouponCustDo.couponId.eq(couponId).and(qBipCouponCustDo.userId.eq(userId)).and(qBipCouponCustDo.ouId.eq(ouId));
        Long count = bipCouponCustRepo.count(expression);
        if(count > 0){
            return true;
        }
        return false;
    }

    /**
     * 处理过期优惠券
     * @param ouId
     */
    public void excuteOverDue(Long ouId){
        //查询ouId已经被领取的优惠券
        QBipCouponCustDo qBipCouponCustDo = QBipCouponCustDo.bipCouponCustDo;
        BooleanExpression expression = qBipCouponCustDo.ouId.eq(ouId).and(qBipCouponCustDo.useStatus.eq("NOTUSED")).and(qBipCouponCustDo.deleteFlag.eq(0));
        Iterable<BipCouponCustDo> iterables = bipCouponCustRepo.findAll(expression);
        if(!IterUtil.isEmpty(iterables)){
            List<BipCouponCustDo> list = Lists.newArrayList(iterables);
            list.stream().forEach(l ->{
                Long couponId = l.getCouponId();
                Optional<BipCouponDO> optional = bipCouponRepo.findById(couponId);
                if(optional.isPresent()){
                    BipCouponDO bipCouponDO = optional.get();
                    //是否新人专享 0是  1不是
//                    String newCustShow = bipCouponDO.getNewCustShow();
//                    if("0".equals(newCustShow)){
//                        // LocalDateTime newCustStime = bipCouponDO.getNewCustStime();
//                        LocalDateTime newCustEtime = bipCouponDO.getNewCustEtime();
//                        if(LocalDateTime.now().isAfter(newCustEtime)){
//                            //更新状态已失效
//                            l.setUseStatus(UdcEnum.SAL_COUPON_USE_STATUS_OVERDUE.getValueCode());
//                        }
//                    }
//                    if("1".equals(newCustShow)){
//                        LocalDateTime validEtime = l.getValidEtime();
//                        if(LocalDateTime.now().isAfter(validEtime)){
//                            //更新状态已失效
//                            l.setUseStatus(UdcEnum.SAL_COUPON_USE_STATUS_OVERDUE.getValueCode());
//                        }
//                    }
                    LocalDateTime validEtime = bipCouponDO.getValidEtime();
                    l.setValidStime(bipCouponDO.getValidStime());
                    l.setValidEtime(validEtime);
                    if(LocalDateTime.now().isAfter(validEtime)){
                        //更新状态已失效
                        l.setUseStatus(UdcEnum.SAL_COUPON_USE_STATUS_OVERDUE.getValueCode());
                    }
                    bipCouponCustRepo.save(l);
                }
            });
        }
    }

    /**
     * 处理过期优惠券
     * @param userId
     */
    public void excuteOverDueByUserId(Long userId){
        //查询ouId已经被领取的优惠券
        QBipCouponCustDo qBipCouponCustDo = QBipCouponCustDo.bipCouponCustDo;
        BooleanExpression expression = qBipCouponCustDo.userId.eq(userId).and(qBipCouponCustDo.useStatus.eq("NOTUSED")).and(qBipCouponCustDo.deleteFlag.eq(0));
        Iterable<BipCouponCustDo> iterables = bipCouponCustRepo.findAll(expression);
        if(!IterUtil.isEmpty(iterables)){
            List<BipCouponCustDo> list = Lists.newArrayList(iterables);
            list.stream().forEach(l ->{
                Long couponId = l.getCouponId();
                Optional<BipCouponDO> optional = bipCouponRepo.findById(couponId);
                if(optional.isPresent()){
                    BipCouponDO bipCouponDO = optional.get();
//                    BipCouponDO bipCouponDO = optional.get();
//                    //是否新人专享 0是  1不是
//                    String newCustShow = bipCouponDO.getNewCustShow();
//                    if("0".equals(newCustShow)){
//                        // LocalDateTime newCustStime = bipCouponDO.getNewCustStime();
//                        LocalDateTime newCustEtime = bipCouponDO.getNewCustEtime();
//                        if(LocalDateTime.now().isAfter(newCustEtime)){
//                            //更新状态已失效
//                            l.setUseStatus(UdcEnum.SAL_COUPON_USE_STATUS_OVERDUE.getValueCode());
//                        }
//                    }
//                    if("1".equals(newCustShow)){
//                        LocalDateTime validEtime = l.getValidEtime();
//                        if(LocalDateTime.now().isAfter(validEtime)){
//                            //更新状态已失效
//                            l.setUseStatus(UdcEnum.SAL_COUPON_USE_STATUS_OVERDUE.getValueCode());
//                        }
//                    }
                    LocalDateTime validEtime = bipCouponDO.getValidEtime();
                    l.setValidEtime(validEtime);
                    l.setValidStime(bipCouponDO.getValidStime());
                    if(LocalDateTime.now().isAfter(validEtime)){
                        //更新状态已失效
                        l.setUseStatus(UdcEnum.SAL_COUPON_USE_STATUS_OVERDUE.getValueCode());
                        bipCouponCustRepo.save(l);
                    }
                }
            });
        }
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> receiveCoupon(List<Long> ids) {
        OrgUserEmpInfoRpcDTO empInfo = getCurrentOuIdInfo();
        BipCustUserBindDO bipCustUserBindDO = new BipCustUserBindDO();
        if(null != empInfo.getUserId()){
            //通过userId查询客户信息
            QBipCustUserBindDO qBipCustUserBindDO = QBipCustUserBindDO.bipCustUserBindDO;
            BooleanExpression e = qBipCustUserBindDO.deleteFlag.eq(0).and(qBipCustUserBindDO.userId.eq(empInfo.getUserId()));
            Optional<BipCustUserBindDO> optional = bipCustUserBindRepo.findOne(e);
            if(optional.isPresent()){
                bipCustUserBindDO = optional.get();
                if(null == bipCustUserBindDO.getCustId()){
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户未绑定客户，不能领取优惠券");
                }
            }else {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户未绑定客户，不能领取优惠券");
            }

        }
        log.error("领取优惠券ID："+ JSON.toJSONString(ids));
        for (Long id : ids) {
            BipCouponDO bipCouponDO = getCouponById(id);
            //优惠券剩余数量
            if (null != bipCouponDO) {
                //优惠券数量
                Long totalNum = bipCouponDO.getTotalNum();
                if (totalNum > 0 ) {
                    LocalDateTime now = LocalDateTime.now();
                    if (bipCouponDO.getReceiveValidStime().isBefore(now) && bipCouponDO.getReceiveValidEtime().isAfter(now)) {

                        //查询用户是否已经领取过
                        BipCouponCustDo custDo = getByUserIdAndCouponId(empInfo.getUserId(), id);
                        if (null == custDo) {
                            //正常领取
                            BipCouponCustDo bipCouponCustDo = new BipCouponCustDo();
                            BeanUtils.copyProperties(bipCouponDO, bipCouponCustDo);
                            bipCouponCustDo.setCouponId(bipCouponDO.getId());
                            bipCouponCustDo.setUserId(empInfo.getUserId());
                            //通过userId查询客户信息
                            bipCouponCustDo.setCustId(bipCustUserBindDO.getCustId());
                            bipCouponCustDo.setCustCode(bipCustUserBindDO.getCustCode());
                            bipCouponCustDo.setCustName(bipCustUserBindDO.getCustName());
                            bipCouponCustDo.setUserName(empInfo.getUserName());
                            bipCouponCustDo.setUseStatus(UdcEnum.SAL_COUPON_USE_STATUS_NOTUSED.getValueCode());
                            bipCouponCustDo.setSecBuId(bipCouponDO.getSecBuId());
                            bipCouponCustDo.setSecUserId(bipCouponDO.getSecUserId());
                            bipCouponCustDo.setSecOuId(bipCouponDO.getOuId());
                            bipCouponCustDo.setId(null);
                            bipCouponCustRepo.save(bipCouponCustDo);
                            //优惠券数量-1
                            bipCouponDO.setTotalNum(bipCouponDO.getTotalNum() - 1);
                            //已领取数量+1
                            bipCouponDO.setReceiveNum(bipCouponDO.getReceiveNum() + 1);
                            bipCouponRepo.save(bipCouponDO);
                        }
                    }else {
                        throw new BusinessException("该优惠券已超出领取时间");
                    }
                }
            }
        }
        return ApiResult.ok();
    }

//    @Override
//    @Transactional
//    public String receiveCoupon(List<Long> ids) {
//        ids.stream().forEach(id ->{
//            BipCouponDO bipCouponDO = getCouponById(id);
//            //优惠券剩余数量
//            if(null == bipCouponDO){
//                return "优惠券不存在";
//            }
//            //优惠券数量
//            Long totalNum = bipCouponDO.getTotalNum();
//            if(totalNum == 0){
//                return "优惠券已发放完,请期待下次活动";
//            }
//            if(totalNum > 0){
//                //0不是  1是
////            if(bipCouponDO.getNewCustShow().equals("1") && !bipCouponDO.getNewCustStime().isAfter(LocalDateTime.now()) && !bipCouponDO.getNewCustEtime().isBefore(LocalDateTime.now())){
////                return "不在领取时间范围！";
////            }
//                if(!bipCouponDO.getSpecialAreaStime().isAfter(LocalDateTime.now()) && !bipCouponDO.getSpecialAreaEtime().isBefore(LocalDateTime.now())){
//                    return "不在领取时间范围！";
//                }
//                OrgUserEmpInfoRpcDTO empInfo = getCurrentEmpInfo();
//                //查询用户是否已经领取过
//                BipCouponCustDo custDo = getByUserIdAndCouponId(empInfo.getUserId(),id);
//                if(null != custDo){
//                    return "优惠券已存在";
//                }
//                //正常领取
//                BipCouponCustDo bipCouponCustDo = new BipCouponCustDo();
//                BeanUtils.copyProperties(bipCouponDO,bipCouponCustDo);
//                bipCouponCustDo.setCouponId(bipCouponDO.getId());
//                bipCouponCustDo.setUserId(empInfo.getUserId());
//                bipCouponCustDo.setUserName(empInfo.getUserName());
//                bipCouponCustDo.setUseStatus(UdcEnum.SAL_COUPON_USE_STATUS_NOTUSED.getValueCode());
//                bipCouponCustDo.setId(null);
//                bipCouponCustRepo.save(bipCouponCustDo);
//                //优惠券数量-1
//                bipCouponDO.setTotalNum(bipCouponDO.getTotalNum() - 1);
//                //已领取数量+1
//                bipCouponDO.setReceiveNum(bipCouponDO.getReceiveNum() + 1);
//                bipCouponRepo.save(bipCouponDO);
//            }else {
//                return "优惠券已经发放完，请期待下次活动！";
//            }
//            return "领取成功!";
//        });
//        return null;
//    }

    public BipCouponCustDo getByUserIdAndCouponId(Long userId,Long couponId){
        QBipCouponCustDo qBipCouponCustDo = QBipCouponCustDo.bipCouponCustDo;
        BooleanExpression expression = qBipCouponCustDo.couponId.eq(couponId).and(qBipCouponCustDo.userId.eq(userId)).and(qBipCouponCustDo.deleteFlag.eq(0));
        Optional<BipCouponCustDo> optional = bipCouponCustRepo.findOne(expression);
        if(optional.isEmpty()){
            return null;
        }
        return optional.get();
    }


    public BipCouponDO getCouponById(Long id){
        Optional<BipCouponDO> optional = bipCouponRepo.findById(id);
        if(optional.isEmpty()){
            return null;
        }
        return optional.get();
    }



    private OrgUserEmpInfoRpcDTO getCurrentEmpInfo() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户已失效,请重登录重试");
        }
        OrgUserEmpInfoRpcDTO userEmpInfo = orgEmpRpcService.findUserEmpInfo(currentUser.getUserId());
        if (userEmpInfo == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "无法获取当前用户信息");
        }
        return userEmpInfo;
    }

    private OrgUserEmpInfoRpcDTO getCurrentOuIdInfo() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户已失效,请重登录重试");
        }
        BipCustUserBindDO bipCustUserBindDO = bipCustUserBindRepoProc.getByUserId(currentUser.getUserId());

        if (bipCustUserBindDO == null || bipCustUserBindDO.getOuId() ==null ) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户未绑定公司");
        }

        OrgUserEmpInfoRpcDTO userEmpInfo = new OrgUserEmpInfoRpcDTO();
        userEmpInfo.setOuId(bipCustUserBindDO.getOuId());
        userEmpInfo.setUserId(currentUser.getUserId());
        userEmpInfo.setUserName(currentUser.getUserName());

        return userEmpInfo;
    }



}
