package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.lang.Assert;
import com.elitesland.yst.production.sale.api.service.shop.BipCompanyManageService;
import com.elitesland.yst.production.sale.api.service.shop.BipHelpCenterService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipHelpCreateParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipHelpQueryParam;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipHelpCenterRespVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.BipHelpConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.BipHelpCenterDO;
import com.elitesland.yst.production.sale.entity.QBipHelpCenterDO;
import com.elitesland.yst.production.sale.repo.shop.BipHelpCenterRepo;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * @author Joker (Xing Shixiang)
 * @create 2021-08-10 15:29
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class BipHelpCenterServiceImpl extends BaseServiceImpl implements BipHelpCenterService {

    private final BipHelpCenterRepo bipHelpCenterRepo;
    private static final QBipHelpCenterDO qBipHelpCenterDo = QBipHelpCenterDO.bipHelpCenterDO;
    private final RmiSysNextNumberService rmiSysNextNumberService;
    private final OrgEmpRpcService orgEmpRpcService;
    private final BipCompanyManageService bipCompanyManageService;


    @Override
    public List<BipHelpCenterRespVO> appfindAll() {
        checkUser();
        JPAQuery<BipHelpCenterRespVO> title = this.appletsFindTitle();
        return title.fetch();
    }

    @Override
    public BipHelpCenterRespVO getHelpById(Long id) {
        checkUser();
        JPAQuery<BipHelpCenterRespVO> byId = this.findTitleById(id);
        List<BipHelpCenterRespVO> fetch = byId.fetch();
        if (fetch.isEmpty()) {
            throw new BusinessException("没有此条数据");
        }
        return fetch.get(0);
    }

    @Override
    public PagingVO<BipHelpCenterRespVO> findAll(BipHelpQueryParam param) {
        var jpaQuery = findHelps(param);
        List<BipHelpCenterRespVO> fetch = jpaQuery.fetch();
        long total = jpaQuery.fetchCount();
        PageRequest pageRequest = wrapperPageRequest(param.getPageRequest(), null);
        appendPageAndSort(jpaQuery, pageRequest, qBipHelpCenterDo);
        return PagingVO
                .<BipHelpCenterRespVO>builder()
                .total(total)
                .records(fetch).build();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateStatus(Long id, String status) {
        jpaQueryFactory
                .update(qBipHelpCenterDo)
                .set(qBipHelpCenterDo.status, status)
                .where(qBipHelpCenterDo.id.eq(id)).execute();
        return id;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateDeleteFlag(Long id, Integer deleteFlag) {
        jpaQueryFactory
                .update(qBipHelpCenterDo)
                .set(qBipHelpCenterDo.deleteFlag, deleteFlag)
                .where(qBipHelpCenterDo.id.eq(id)).execute();
        return id;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long saveHelp(BipHelpCreateParam param) {
        Assert.isFalse(StringUtils.isEmpty(param.getTitle()),"文档标题不能为空");
        Assert.isFalse(StringUtils.isEmpty(param.getContestStruct()),"文档内容说明不能为空");

        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户已失效,请重登录重试");
        }
//        OrgUserEmpInfoRpcDTO userEmpInfo = orgEmpRpcService.findUserEmpInfo(currentUser.getUserId());
//        if (userEmpInfo == null) {
//            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "无法获取当前用户信息");
//        }
//        List<BipCompanyManageRespVO> companyManageByOuIds = bipCompanyManageService.findCompanyManageByOuIds(Arrays.asList(userEmpInfo.getOuId()));
//        if (CollectionUtils.isEmpty(companyManageByOuIds)) {
//            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户公司信息为空");
//        }
        BipHelpConvert convert = BipHelpConvert.INSTANCE;
        BipHelpCenterDO bipHelpCenterDO = convert.creatParamToDo(param);
//        bipHelpCenterDO.setSecUserId(userEmpInfo.getUserId());
//        bipHelpCenterDO.setSecOuId(userEmpInfo.getOuId());
//        Long buId = companyManageByOuIds.get(0).getBuId();
//        bipHelpCenterDO.setSecBuId(buId);
        //tx+yyMMdd+3位流水
        if (StringUtils.isEmpty(param.getFileCode())) {
            String fileCode = rmiSysNextNumberService.generateCode("yst-sale","tx", null);
            bipHelpCenterDO.setFileCode(fileCode);
        }
        return bipHelpCenterRepo.save(bipHelpCenterDO).getId();
    }


    JPAQuery<BipHelpCenterRespVO> appletsFindTitle(){
       return jpaQueryFactory.select(Projections.bean(BipHelpCenterRespVO.class,
               qBipHelpCenterDo.id,
               qBipHelpCenterDo.fileCode,
               qBipHelpCenterDo.title)
        ).from(qBipHelpCenterDo).where(qBipHelpCenterDo.status.eq(UdcEnum.BIP_HELP_STATUS_TRUE.getValueCode()));
    }
    JPAQuery<BipHelpCenterRespVO> findTitleById(Long id){
        return jpaQueryFactory.select(Projections.bean(BipHelpCenterRespVO.class,
                qBipHelpCenterDo.id,
                qBipHelpCenterDo.fileCode,
                qBipHelpCenterDo.context,
                qBipHelpCenterDo.contestStruct,
                qBipHelpCenterDo.status,
                qBipHelpCenterDo.title)
        ).from(qBipHelpCenterDo).where(qBipHelpCenterDo.id.eq(id));
    }

    JPAQuery<BipHelpCenterRespVO> findHelps(BipHelpQueryParam param){
        Predicate  predicate= qBipHelpCenterDo.isNotNull();
        JPAQuery<BipHelpCenterRespVO> jpaQuery = jpaQueryFactory.select(Projections.bean(BipHelpCenterRespVO.class,
                        qBipHelpCenterDo.id,
                        qBipHelpCenterDo.fileCode,
                        qBipHelpCenterDo.context,
                        qBipHelpCenterDo.contestStruct,
                        qBipHelpCenterDo.title,
                        qBipHelpCenterDo.status,
                        qBipHelpCenterDo.createTime
                )
        ).from(qBipHelpCenterDo);
        if (!StringUtils.isEmpty(param.getStatus())) {
            jpaQuery.where(predicate,qBipHelpCenterDo.status.eq(param.getStatus()));
        }
        return jpaQuery;
    }
    /**
     * 检查当前用户并返回用户信息
     *
     * @return CurrentUserDTO--当前用户信息
     */

    private static CurrentUserDTO checkUser() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "无法到获取当前用户请先登录");
        }
        return currentUser;
    }
}
