package com.elitesland.yst.production.sale.workflow.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.el.coordinator.core.common.exception.BusinessException;
//import com.elitesland.yst.production.sale.api.service.PriSalePriceAlterService;
import com.elitesland.yst.production.sale.api.vo.param.pri.PriSalePriceApproveParam;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.entity.PriSalePriceAlterDO;
import com.elitesland.yst.production.sale.entity.QPriSalePriceAlterDO;
import com.elitesland.yst.production.sale.repo.PriSalePriceAlterRepo;
import com.elitesland.yst.production.sale.repo.PriSalePriceAlterRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysUserFlowRoleRpcService;
import com.elitesland.yst.production.sale.workflow.service.PriSalePriceAlterProcessService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author yangzhibin
 * @date 2021/8/5
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class PriSalePriceAlterProcessServiceImpl implements PriSalePriceAlterProcessService {

    private final JPAQueryFactory jpaQueryFactory;
    private final PriSalePriceAlterRepo priSalePriceAlterRepo;
//    private final PriSalePriceAlterService priSalePriceAlterService;
    private final PriSalePriceAlterRepoProc priSalePriceAlterRepoProc;

    private final RmiSysUserFlowRoleRpcService rmiSysUserFlowRoleRpcService;
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void processStatusChange(long id, ProcInstStatus procInstStatus) {
        //1,查询单据是否存在
        Optional<PriSalePriceAlterDO> priSalePriceAlterDO = priSalePriceAlterRepo.findById(id);
        if (priSalePriceAlterDO.isPresent() == false) {
            throw new BusinessException("单据(id:" + id + ")不存在,无法审批");
        }

        QPriSalePriceAlterDO qPriSalePriceAlterDO = QPriSalePriceAlterDO.priSalePriceAlterDO;

        //2,修改审批状态
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qPriSalePriceAlterDO)
                .set(qPriSalePriceAlterDO.procInstStatus, procInstStatus)
                .where(qPriSalePriceAlterDO.id.eq(id));

        //3,修改单据状态
        switch (procInstStatus) {
            case NOTSUBMIT: // 未提交
                jpaUpdateClause.set(qPriSalePriceAlterDO.docStatus, UdcEnum.PRI_APPLY_STATUS_DR.getValueCode());//待提交
                break;
            case INTERRUPT: // 中断执行
                jpaUpdateClause.set(qPriSalePriceAlterDO.docStatus, UdcEnum.PRI_APPLY_STATUS_DR.getValueCode());//待提交
                priSalePriceAlterRepo.updateProcInstId(id,null);
                break;
            case REJECTED: // 审批拒绝
                jpaUpdateClause.set(qPriSalePriceAlterDO.docStatus, UdcEnum.PRI_APPLY_STATUS_RJ.getValueCode());//已拒绝
                break;
            case INVALID: // 作废
                jpaUpdateClause.set(qPriSalePriceAlterDO.docStatus, UdcEnum.PRI_APPLY_STATUS_CL.getValueCode());//已取消
                break;
            case APPROVING: // 审批中
                jpaUpdateClause.set(qPriSalePriceAlterDO.docStatus, UdcEnum.PRI_APPLY_STATUS_APPING.getValueCode());//审批中
                break;
            case APPROVED: // 审批通过
                jpaUpdateClause.set(qPriSalePriceAlterDO.docStatus, UdcEnum.PRI_APPLY_STATUS_CF.getValueCode())//已审批
                        .set(qPriSalePriceAlterDO.approvedTime, LocalDateTime.now())//审批完成时间
                ;
                break;
        }
        //执行
        jpaUpdateClause.execute();

        //4,其他业务
        if (procInstStatus.equals(ProcInstStatus.APPROVED)) {
            //todo:流程结束，处理业务
            PriSalePriceApproveParam priSalePriceApproveParam = new PriSalePriceApproveParam();
            priSalePriceApproveParam.setDocId(id);
            priSalePriceApproveParam.setApprStatus(UdcEnum.COM_APPR_STATUS_APPROVED.getValueCode());
          //  priSalePriceAlterService.approveAlter(priSalePriceApproveParam);
        }
    }

    @Override
    public List<String> taskAssignee(Long businessKey, String customParams) {

        log.info("通过ouId,自定义参数获取用户列表，时间:{},入参:{}",LocalDateTime.now(),businessKey);
        Long ouId = priSalePriceAlterRepoProc.getOuIdById(Long.valueOf(businessKey));
        try {
            SysUserIdFlowRoleRpcParam sysUserIdFlowRoleRpcParam = new SysUserIdFlowRoleRpcParam();
            sysUserIdFlowRoleRpcParam.setOuIds(Collections.singletonList(ouId));
            List<String> flowRoleCodes = Arrays.asList(customParams.split(","));
            sysUserIdFlowRoleRpcParam.setFlowRoleCodes(flowRoleCodes);
            // 3.通过公司和角色信息,调支撑域接口查用户获取id
            log.info("公司角色查询信息"+ sysUserIdFlowRoleRpcParam);
            List<Long> userIdsByFlowRoles = rmiSysUserFlowRoleRpcService.findUserIdsByFlowRoles(sysUserIdFlowRoleRpcParam).stream().filter(Objects::nonNull).collect(Collectors.toList());
            List<String> userIds = userIdsByFlowRoles.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(userIds)){
                return CollUtil.newArrayList(userIds);
            }
        }catch (Exception e){
            log.error("findUserIdsByFlowRoles error:",e);
            throw new BusinessException("调用支撑域查询审批角色对应审批人异常"+e,e);
        }
        return null;
    }
}