/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.controller.crm;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.auth.cas.model.AuthUserDTO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.sale.api.service.CustAccountService;
import com.elitesland.yst.production.sale.api.vo.save.CheckKapchaParam;
import com.elitesland.yst.production.sale.api.vo.save.CustAccountEnableVO;
import com.elitesland.yst.production.sale.api.vo.save.CustAccountUpdateVO;
import com.elitesland.yst.production.sale.config.cas.CasUserClientHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cust/account"}, produces={"application/json"})
@Api(tags={"\u5ba2\u6237\u8d26\u6237"})
public class CustAccountController {
    private static final Logger log = LoggerFactory.getLogger(CustAccountController.class);
    @Autowired
    private CustAccountService custAccountService;
    @Autowired
    private CasUserClientHelper casUserClientHelper;

    @PutMapping(value={"/create/{custCodes}"})
    @ApiOperation(value="\u521b\u5efa\u8d26\u53f7")
    public ApiResult<List<Long>> createCustAccount(@PathVariable List<String> custCodes) {
        ArrayList res = new ArrayList();
        List authUsers = this.custAccountService.createUser(custCodes);
        authUsers.forEach(user -> {
            Long userId = this.casUserClientHelper.onUpsert((AuthUserDTO)user);
            res.add(userId);
        });
        return ApiResult.ok(res);
    }

    @PutMapping(value={"/updatePwd"})
    @ApiOperation(value="\u4fee\u6539\u5bc6\u7801")
    public ApiResult<Long> updatePwd(@RequestBody CustAccountUpdateVO custAccountUpdate) {
        ApiResult sysUser = this.custAccountService.updatePwd(custAccountUpdate);
        Long userId = null;
        try {
            if (!sysUser.isSuccess()) {
                return ApiResult.fail((int)sysUser.getCode(), (String)sysUser.getMsg());
            }
            userId = this.casUserClientHelper.onUpdatePassword(((SysUserDTO)sysUser.getData()).getId(), custAccountUpdate.getNewPwd());
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5bc6\u7801 error:", (Throwable)e);
            throw new BusinessException("\u8c03\u7528\u4fee\u6539\u5bc6\u7801\u670d\u52a1\u5f02\u5e38" + e, (Throwable)e);
        }
        this.custAccountService.updateAccountPwd(((SysUserDTO)sysUser.getData()).getId(), custAccountUpdate);
        return ApiResult.ok((Object)userId);
    }

    @PostMapping(value={"/checkKaptcha"})
    @ApiOperation(value="\u9a8c\u8bc1\u7801\u9a8c\u8bc1")
    public ApiResult<String> checkKaptcha(@RequestBody CheckKapchaParam param) {
        return this.custAccountService.checkKaptcha(param);
    }

    @PostMapping(value={"/onEnabled"})
    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u72b6\u6001 \u542f\u7528/\u7981\u7528")
    public ApiResult<List<Long>> onEnabled(@RequestBody CustAccountEnableVO custAccountEnableVO) {
        List list = this.custAccountService.getByCustCodes(custAccountEnableVO);
        ArrayList accountIds = new ArrayList();
        list.forEach(l -> {
            this.casUserClientHelper.onEnabled(l.getUserId(), custAccountEnableVO.getEnable());
            accountIds.add(l.getId());
        });
        List accountId = this.custAccountService.updateAccountEnable(accountIds, custAccountEnableVO.getEnable());
        return ApiResult.ok((Object)accountId);
    }

    @GetMapping(value={"/onDelete/{custCodes}"})
    public ApiResult<Object> onDelete(@PathVariable List<String> custCodes) {
        if (CollectionUtil.isEmpty(custCodes)) {
            throw new BusinessException("\u53c2\u6570\u4e3a\u7a7a");
        }
        List list = this.custAccountService.getByCustCodes(custCodes);
        if (!CollectionUtil.isEmpty((Collection)list)) {
            list.stream().filter(l -> l.getIsOpenAccount().equals(true) && null != l.getUserId()).collect(Collectors.toList());
            list.forEach(l -> {
                if (l.getIsOpenAccount().equals(true) && null != l.getUserId()) {
                    this.casUserClientHelper.onDelete(l.getUserId());
                }
            });
        }
        List ids = list.stream().map(BaseModel::getId).collect(Collectors.toList());
        this.custAccountService.deleteAccount(ids);
        return ApiResult.ok();
    }
}

