/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.controller.sal;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.SalProjService;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalProjPagingParam;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalProjQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalProjSaveParam;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalProjDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalProjPageRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalProjSimpleRespVO;
import com.elitesland.yst.production.sale.api.vo.save.SalProjImportSaveVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import netscape.javascript.JSObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/proj"}, produces={"application/json"})
@Api(tags={"\u9500\u552e\u9879\u76ee"})
public class SalProjController
extends BaseController {
    @Autowired
    private SalProjService salProjService;

    @PostMapping(value={"/query"})
    @ApiOperation(value="\u9879\u76ee\u4fe1\u606f\u5206\u9875\u67e5\u8be2")
    @ApiOperationSupport(order=1)
    public ApiResult<PagingVO<SalProjPageRespVO>> query(@RequestBody SalProjPagingParam pageParam) {
        PagingVO result = this.salProjService.query(pageParam);
        return ApiResult.ok((Object)result);
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u4fdd\u5b58\u6216\u66f4\u65b0\u9879\u76ee\u4fe1\u606f")
    @ApiOperationSupport(order=2)
    public ApiResult<JSONObject> saveOrUpdate(@RequestBody @Valid SalProjSaveParam param) {
        return ApiResult.ok((Object)this.salProjService.save(param));
    }

    @GetMapping(value={"/detail/{id}"})
    @ApiOperation(value="\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u8be6\u60c5")
    @ApiOperationSupport(order=3)
    public ApiResult<SalProjDetailRespVO> queryOneDetail(@PathVariable(value="id") Long id) {
        SalProjDetailRespVO result = this.salProjService.queryOneDetail(id);
        return ApiResult.ok((Object)result);
    }

    @PostMapping(value={"/del"})
    @ApiOperation(value="\u5220\u9664\u9879\u76ee")
    @ApiOperationSupport(order=4)
    public ApiResult<JSObject> deleteProj(@RequestBody List<Long> ids) {
        this.salProjService.delSalProj(ids);
        return ApiResult.ok();
    }

    @PostMapping(value={"/component"})
    @ApiOperation(value="\u524d\u7aef\u7ec4\u4ef6\u67e5\u8be2\u9879\u76ee\u5217\u8868")
    @ApiOperationSupport(order=5)
    public ApiResult<List<SalProjSimpleRespVO>> componentQuery(@RequestBody SalProjQueryParam param) {
        return ApiResult.ok((Object)this.salProjService.queryByParam(param));
    }

    @PostMapping(value={"/ImportProjData"})
    @ApiOperation(value="\u5408\u540c\u5bfc\u5165\u9879\u76ee\u4fe1\u606f\u6570\u636e")
    @ApiOperationSupport(order=6)
    public ApiResult<Object> parseImportProjData(MultipartFile file) {
        List<?> parseData = null;
        try {
            parseData = this.importExcel(file, SalProjImportSaveVO.class, 3, 3);
        }
        catch (Exception e) {
            return ApiResult.fail((String)"\u89e3\u6790\u5bfc\u5165\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u4e25\u683c\u6309\u7167\u539f\u59cb\u6a21\u677f\u6570\u636e\u683c\u5f0f\u8fdb\u884c\u5bfc\u5165");
        }
        if (!CollectionUtils.isEmpty(parseData)) {
            return this.salProjService.projImportData(parseData);
        }
        return ApiResult.ok();
    }
}

