/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.rmi.ystsystem;

import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RmiSysUserRpcService {
    private static final Logger log = LogManager.getLogger(RmiSysUserRpcService.class);
    @Autowired
    private SysUserRpcService sysUserRpcService;
    @Autowired
    private UdcProvider udcProvider;
    @Autowired
    private SeqNumProvider sysNumberRuleService;

    public SysUserDTO getUserByUsername(String username) {
        ApiResult result = null;
        try {
            result = this.sysUserRpcService.getUserByUsername(username);
        }
        catch (Exception e) {
            log.error("\u7cfb\u7edf\u57df\u670d\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessException("\u7cfb\u7edf\u57df\u670d\u52a1\u5f02\u5e38", (Throwable)e);
        }
        if (result != null && result.isSuccess()) {
            return (SysUserDTO)result.getData();
        }
        return null;
    }

    public Map<String, String> sysUdcGetCodeMap(String domain, String udc) {
        try {
            Map codeMap = this.udcProvider.getValueMapByUdcCode(domain, udc);
            return codeMap;
        }
        catch (Exception e) {
            log.error("findCodeBatch error:", (Throwable)e);
            return new HashMap<String, String>();
        }
    }

    public String sysNumberRuleGenerateCode(String code, List<String> runtimeValues) {
        log.info("\u5e93\u5b58\u4e2d\u5fc3\u53d1\u53f7\u5668\u8c03\u7528\uff1a\u65f6\u95f4\uff1a{}\uff0c\u53c2\u6570{},{}", (Object)LocalDateTime.now(), (Object)code, runtimeValues);
        String sys = "";
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(runtimeValues);
        try {
            sys = this.sysNumberRuleService.generateCode("yst-sale", code, list);
        }
        catch (Exception e) {
            log.error("sysNumberRuleGenerateCode error:", (Throwable)e);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53d1\u53f7\u5668\u53d1\u53f7\u5931\u8d25");
        }
        return sys;
    }
}

