/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.sale.api.service.CrmCustOuService;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustOuParamVO;
import com.elitesland.yst.production.sale.api.vo.save.CrmCustOuParamSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.CrmCustOuSaveVO;
import com.elitesland.yst.production.sale.convert.CrmCustOuConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.entity.QCrmCustOuDO;
import com.elitesland.yst.production.sale.repo.CrmCustOuRepo;
import com.elitesland.yst.production.sale.repo.CrmCustOuRepoProc;
import com.elitesland.yst.production.sale.repo.CrmCustRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgEmpService;
import com.elitesland.yst.production.support.provider.org.param.OrgEmpRpcDtoParam;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class CrmCustOuServiceImpl
extends BaseServiceImpl
implements CrmCustOuService {
    private static final Logger log = LoggerFactory.getLogger(CrmCustOuServiceImpl.class);
    private static final QCrmCustOuDO Q_CRM_CUST_OUDO = QCrmCustOuDO.crmCustOuDO;
    private final RmiOrgEmpService rmiOrgEmpService;
    private final CrmCustOuRepo crmCustOuRepo;
    private final CrmCustRepoProc crmCustRepoProc;
    private final CrmCustOuRepoProc crmCustOuRepoProc;

    public List<CrmCustOuSaveVO> search(CrmCustOuParamVO searchParam) {
        JPAQuery<CrmCustOuSaveVO> jpaQuery = this.select(searchParam);
        long total = jpaQuery.fetchCount();
        if (total == 0L) {
            return new ArrayList<CrmCustOuSaveVO>();
        }
        List respVoS = jpaQuery.fetch();
        if (StringUtils.isEmpty((Object)searchParam.getIfTrans()) || Boolean.TRUE.equals(searchParam.getIfTrans())) {
            this.translatePage(respVoS);
        }
        return respVoS;
    }

    private void translatePage(List<CrmCustOuSaveVO> respVOList) {
        List agentEmpIds = respVOList.stream().map(CrmCustOuSaveVO::getAgentEmpId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
        List<Object> empDtoByParam = new ArrayList();
        if (!CollectionUtils.isEmpty(agentEmpIds)) {
            orgEmpRpcDtoParam.setEmpIds(agentEmpIds);
            try {
                empDtoByParam = this.rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);
            }
            catch (Exception e) {
                log.error("dubbo\u8bbf\u95eeemp\u67e5\u8be2\u63a5\u53e3\u5931\u8d25\uff1a" + e.getMessage());
                throw new BusinessException("dubbo\u670d\u52a1\u8c03\u7528\u652f\u6301\u57df\u67e5\u8be2\u5458\u5de5\u63a5\u53e3\u51fa\u9519");
            }
        }
        ArrayList finalEmpDtoByParam = empDtoByParam;
        respVOList.forEach(emp -> finalEmpDtoByParam.stream().filter(empDto -> empDto.getId().equals(emp.getAgentEmpId())).findFirst().ifPresent(empName -> emp.setAgentEmpName(empName.getEmpName())));
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> save(CrmCustOuParamSaveVO saveVo) {
        this.crmCustOuRepo.deleteByCustCode(saveVo.getCustCode());
        if (!CollectionUtils.isEmpty((Collection)saveVo.getCrmCustOuSaveVOS())) {
            List crmCustOuSaveVoS = saveVo.getCrmCustOuSaveVOS();
            List ouIdList = crmCustOuSaveVoS.stream().map(CrmCustOuSaveVO::getOuId).distinct().collect(Collectors.toList());
            Assert.isFalse((ouIdList.size() != crmCustOuSaveVoS.size() ? 1 : 0) != 0, (String)"\u8bf7\u4e0d\u8981\u540c\u65f6\u6dfb\u52a0\u76f8\u540c\u7684\u516c\u53f8", (Object[])new Object[0]);
            crmCustOuSaveVoS.forEach(save -> {
                save.setCustCode(saveVo.getCustCode());
                Assert.isFalse((boolean)this.crmCustRepoProc.existsCodeAndOuId(saveVo.getCustCode(), save.getOuId()), (String)("\u8be5\u5ba2\u6237\u5df2\u7ecf\u5c5e\u4e8e" + save.getOuName() + "\u516c\u53f8"), (Object[])new Object[0]);
                Assert.isFalse((boolean)this.crmCustOuRepoProc.existsCodeAndOuId(saveVo.getCustCode(), save.getOuId()), (String)"\u8be5\u516c\u53f8\u5df2\u7ecf\u5b58\u5728\u4e8e\u8868\u4e2d", (Object[])new Object[0]);
            });
            List crmCustOuDoS = crmCustOuSaveVoS.stream().map(CrmCustOuConvert.INSTANCE::saveVoToDo).collect(Collectors.toList());
            this.crmCustOuRepo.saveAll(crmCustOuDoS);
        }
        return ApiResult.ok();
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> deleteById(Long id) {
        this.crmCustOuRepo.deleteById(id);
        return ApiResult.ok();
    }

    public JPAQuery<CrmCustOuSaveVO> select(CrmCustOuParamVO searchParam) {
        if (ObjectUtils.isEmpty((Object)searchParam)) {
            return new JPAQuery();
        }
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmCustOuSaveVO.class, (Expression[])new Expression[]{CrmCustOuServiceImpl.Q_CRM_CUST_OUDO.id, CrmCustOuServiceImpl.Q_CRM_CUST_OUDO.ouId, CrmCustOuServiceImpl.Q_CRM_CUST_OUDO.ouCode, CrmCustOuServiceImpl.Q_CRM_CUST_OUDO.custCode, CrmCustOuServiceImpl.Q_CRM_CUST_OUDO.ouName, CrmCustOuServiceImpl.Q_CRM_CUST_OUDO.buId, CrmCustOuServiceImpl.Q_CRM_CUST_OUDO.buCode, CrmCustOuServiceImpl.Q_CRM_CUST_OUDO.buName, CrmCustOuServiceImpl.Q_CRM_CUST_OUDO.agentEmpId})).from((EntityPath)Q_CRM_CUST_OUDO);
        jpaQuery.where(this.where(searchParam));
        return jpaQuery;
    }

    public Predicate where(CrmCustOuParamVO param) {
        BooleanExpression predicate = Q_CRM_CUST_OUDO.isNotNull();
        if (!StringUtils.isEmpty((Object)param.getCustCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustOuServiceImpl.Q_CRM_CUST_OUDO.custCode.eq((Object)param.getCustCode()));
        }
        if (!StringUtils.isEmpty((Object)param.getOuId())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustOuServiceImpl.Q_CRM_CUST_OUDO.ouId.eq((Object)param.getOuId()));
        }
        if (!StringUtils.isEmpty((Object)param.getAgentEmpId())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustOuServiceImpl.Q_CRM_CUST_OUDO.agentEmpId.eq((Object)param.getAgentEmpId()));
        }
        if (!CollectionUtils.isEmpty((Collection)param.getAgentEmpIds())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustOuServiceImpl.Q_CRM_CUST_OUDO.agentEmpId.in((Collection)param.getAgentEmpIds()));
        }
        return predicate;
    }

    public CrmCustOuServiceImpl(RmiOrgEmpService rmiOrgEmpService, CrmCustOuRepo crmCustOuRepo, CrmCustRepoProc crmCustRepoProc, CrmCustOuRepoProc crmCustOuRepoProc) {
        this.rmiOrgEmpService = rmiOrgEmpService;
        this.crmCustOuRepo = crmCustOuRepo;
        this.crmCustRepoProc = crmCustRepoProc;
        this.crmCustOuRepoProc = crmCustOuRepoProc;
    }
}

