/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.common.utils.MapUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.core.support.udc.support.SysUdcProxyService;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.ExectRecordTempService;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.ExectRecordTempQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.FileInfoQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.TaskInfoQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.ExectRecordTempDtlRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.ExectRecordTempRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.FileInfoRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoRespVO;
import com.elitesland.yst.production.sale.api.vo.save.ExectRecordTempDtlSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.ExectRecordTempSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.FileInfoSaveVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.ExectRecordTempConvert;
import com.elitesland.yst.production.sale.convert.ExectRecordTempDtlConvert;
import com.elitesland.yst.production.sale.convert.FileinfoConvert;
import com.elitesland.yst.production.sale.entity.ExectRecordTempDO;
import com.elitesland.yst.production.sale.entity.ExectRecordTempDtlDO;
import com.elitesland.yst.production.sale.entity.FileInfoDO;
import com.elitesland.yst.production.sale.repo.ExectRecordTempDtlRepo;
import com.elitesland.yst.production.sale.repo.ExectRecordTempDtlRepoProc;
import com.elitesland.yst.production.sale.repo.ExectRecordTempRepo;
import com.elitesland.yst.production.sale.repo.ExectRecordTempRepoProc;
import com.elitesland.yst.production.sale.repo.FileInfoRepo;
import com.elitesland.yst.production.sale.repo.FileInfoRepoProc;
import com.elitesland.yst.production.sale.repo.TaskInfoRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExectRecordTempServiceImpl
implements ExectRecordTempService {
    private static final Logger log = LoggerFactory.getLogger(ExectRecordTempServiceImpl.class);
    private final ExectRecordTempRepo exectRecordTempRepo;
    private final ExectRecordTempRepoProc exectRecordTempRepoProc;
    private final ExectRecordTempDtlRepo exectRecordTempDtlRepo;
    private final ExectRecordTempDtlRepoProc exectRecordTempDtlRepoProc;
    private final RmiSysNextNumberService rmiSysNextNumberService;
    private final SysUdcProxyService sysUdcProxyService;
    private final TaskInfoRepoProc taskInfoRepoProc;
    private final FileInfoRepoProc fileInfoRepoProc;
    private final FileInfoRepo fileInfoRepo;
    private final UdcProvider udcProvider;
    @Value(value="${file.upload.url}")
    private String fileServerUrl;

    @Transactional
    public Long save(ExectRecordTempSaveVO saveVO) {
        List fileInfoSaveVOS;
        log.info("\u6267\u884c\u8bb0\u5f55\u6a21\u677f\u5165\u53c2:" + JSON.toJSONString((Object)saveVO));
        String orderNo = null;
        this.check(saveVO);
        if (saveVO.getId() != null && saveVO.getId() != 0L) {
            this.exectRecordTempDtlRepo.deleteByMasId(saveVO.getId());
            this.fileInfoRepoProc.sourceDel(Arrays.asList(saveVO.getId()));
        } else {
            orderNo = this.rmiSysNextNumberService.generateCode("yst-sale", "MB", new ArrayList<String>());
            log.info("\u6267\u884c\u8bb0\u5f55\u6a21\u677f\u53d1\u53f7\uff1a" + JSON.toJSONString((Object)orderNo));
        }
        saveVO.setState(StringUtils.isEmpty((CharSequence)saveVO.getState()) ? "1" : saveVO.getState());
        saveVO.setTempCode(StringUtils.isEmpty((CharSequence)orderNo) ? saveVO.getTempCode() : orderNo);
        ExectRecordTempDO exectRecordTempDO = ExectRecordTempConvert.INSTANCE.voToDO(saveVO);
        Long id = ((ExectRecordTempDO)((Object)this.exectRecordTempRepo.save((Object)exectRecordTempDO))).getId();
        List tempDtlSaveVOS = saveVO.getTempDtlSaveVOS();
        if (!CollectionUtils.isEmpty((Collection)tempDtlSaveVOS)) {
            List collect = tempDtlSaveVOS.stream().map(t -> {
                ExectRecordTempDtlDO exectRecordTempDtlDO = ExectRecordTempDtlConvert.INSTANCE.voToDO((ExectRecordTempDtlSaveVO)t);
                exectRecordTempDtlDO.setMasId(id);
                return exectRecordTempDtlDO;
            }).collect(Collectors.toList());
            this.exectRecordTempDtlRepo.saveAll(collect);
        }
        if (!CollectionUtils.isEmpty((Collection)(fileInfoSaveVOS = saveVO.getFileInfoSaveVOS()))) {
            List collect = fileInfoSaveVOS.stream().map(t -> {
                FileInfoDO fileInfoDO = FileinfoConvert.INSTANCE.voToDO((FileInfoSaveVO)t);
                fileInfoDO.setSourceId(id);
                return fileInfoDO;
            }).collect(Collectors.toList());
            this.fileInfoRepo.saveAll(collect);
        }
        return id;
    }

    @SysCodeProc
    public PagingVO<ExectRecordTempRespVO> query(ExectRecordTempQueryVO param) {
        log.info("\u6267\u884c\u8bb0\u5f55\u6a21\u677f\u5206\u9875\u5165\u53c2" + JSON.toJSONString((Object)param));
        PagingVO<ExectRecordTempRespVO> page = this.exectRecordTempRepoProc.page(param);
        page.stream().forEach(t -> t.setState("0".equals(t.getState()) ? "\u542f\u7528" : "\u505c\u7528"));
        this.udcConversion(page.getRecords());
        return page;
    }

    @SysCodeProc
    public ExectRecordTempRespVO queryDtl(ExectRecordTempQueryVO param) {
        log.info("\u6267\u884c\u8bb0\u5f55\u6a21\u677f\u660e\u7ec6\u5165\u53c2" + JSON.toJSONString((Object)param));
        if (param.getId() == null || param.getId() == 0L) {
            throw new BusinessException(ApiCode.FAIL, "id\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        ExectRecordTempRespVO exectRecordTempRespVO = this.exectRecordTempRepoProc.get(param.getId());
        List<ExectRecordTempDtlRespVO> exectRecordTempDtlRespVOS = this.exectRecordTempDtlRepoProc.get(param.getId());
        this.sysUdcProxyService.translate(exectRecordTempDtlRespVOS);
        exectRecordTempRespVO.setTempDtlRespVOS(exectRecordTempDtlRespVOS);
        FileInfoQueryVO fileInfoQueryVO = new FileInfoQueryVO();
        fileInfoQueryVO.setSourceId(param.getId());
        List<FileInfoRespVO> list = this.fileInfoRepoProc.getList(fileInfoQueryVO);
        exectRecordTempRespVO.setFileInfoRespVOS(list);
        exectRecordTempRespVO.setState("0".equals(exectRecordTempRespVO.getState()) ? "\u542f\u7528" : "\u505c\u7528");
        this.udcConversion(Arrays.asList(exectRecordTempRespVO));
        return exectRecordTempRespVO;
    }

    @Transactional
    @SysCodeProc
    public void open(Long id) {
        log.info("\u6a21\u677f\u505c\u7528\u63a5\u53e3\u5165\u53c2\uff1a" + JSON.toJSONString((Object)id));
        if (id == null || id == 0L) {
            throw new BusinessException(ApiCode.FAIL, "id\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        ExectRecordTempRespVO exectRecordTempRespVO = this.exectRecordTempRepoProc.get(id);
        if ("0".equals(exectRecordTempRespVO.getState())) {
            throw new BusinessException(ApiCode.FAIL, "\u542f\u7528\u72b6\u6001\u6a21\u677f\u4e0d\u9700\u8981\u518d\u6b21\u542f\u7528");
        }
        ArrayList<ExectRecordTempRespVO> tempList = new ArrayList();
        ExectRecordTempQueryVO exectRecordTempQueryVO = new ExectRecordTempQueryVO();
        List<String> taskList = Arrays.asList(exectRecordTempRespVO.getTaskType().split(";"));
        List<String> ouCodeList = Arrays.asList(exectRecordTempRespVO.getOuCode().split(";"));
        exectRecordTempQueryVO.setTaskTypeList(taskList);
        tempList = this.exectRecordTempRepoProc.getList(exectRecordTempQueryVO);
        this.udcConversion(tempList);
        this.updateStatus(id, "0");
    }

    private void updateStatus(Long id, String s) {
        this.exectRecordTempRepoProc.updateStatus(id, s);
    }

    @Transactional
    @SysCodeProc
    public void stop(Long id) {
        log.info("\u6a21\u677f\u505c\u7528\u63a5\u53e3\u5165\u53c2\uff1a" + JSON.toJSONString((Object)id));
        if (id == null || id == 0L) {
            throw new BusinessException(ApiCode.FAIL, "id\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        ExectRecordTempRespVO exectRecordTempRespVO = this.exectRecordTempRepoProc.get(id);
        if ("1".equals(exectRecordTempRespVO.getState())) {
            throw new BusinessException(ApiCode.FAIL, "\u505c\u7528\u72b6\u6001\u6a21\u677f\u4e0d\u9700\u8981\u518d\u6b21\u505c\u7528");
        }
        TaskInfoQueryVO taskInfoQueryVO = new TaskInfoQueryVO();
        taskInfoQueryVO.setExecutTemplateCode(exectRecordTempRespVO.getTempCode());
        List<TaskInfoRespVO> taskInfoRespVOS = this.taskInfoRepoProc.selectByQueryVO(taskInfoQueryVO);
        List collect = taskInfoRespVOS.stream().filter(t -> UdcEnum.SALESMAN_TASK_STATUS_WEE.getValueCode().equals(t.getState()) || UdcEnum.SALESMAN_TASK_STATUS_IPS.getValueCode().equals(t.getState())).collect(Collectors.toList());
        if (collect.size() > 0) {
            throw new BusinessException(ApiCode.FAIL, "\u9700\u8981\u5c06\u5173\u8054\u7684\u8fdb\u884c\u4e2d\u7684\u4efb\u52a1\u53d6\u6d88\u6389\u6216\u8005\u5b8c\u6210\u540e\uff0c\u624d\u53ef\u4ee5\u505c\u7528\u6b64\u6a21\u7248\uff01");
        }
        this.updateStatus(id, "1");
    }

    public List<ExectRecordTempRespVO> queryByCodes(List<String> codes) {
        log.info("\u6267\u884c\u8bb0\u5f55\u660e\u7ec6\u5165\u53c2" + JSON.toJSONString(codes));
        if (org.springframework.util.CollectionUtils.isEmpty(codes)) {
            return null;
        }
        List<ExectRecordTempRespVO> exectRecordTempRespVOS = this.exectRecordTempRepoProc.queryByCodes(codes);
        return exectRecordTempRespVOS;
    }

    public List<ExectRecordTempRespVO> queryByCodeAndTask(String taskType, String ouCode) {
        log.info("\u6839\u636e\u516c\u53f8\u7f16\u7801+\u4efb\u52a1\u7c7b\u578b\u67e5\u8be2\u6a21\u677f\u5165\u53c2" + JSON.toJSONString((Object)taskType) + JSON.toJSONString((Object)ouCode));
        if (Optional.ofNullable(taskType).isEmpty() || Optional.ofNullable(ouCode).isEmpty()) {
            return null;
        }
        List<ExectRecordTempDO> exectRecordTempDOS = this.exectRecordTempRepo.queryByCodeAndTask(taskType, ouCode);
        List<ExectRecordTempRespVO> collect = exectRecordTempDOS.stream().map(t -> {
            ExectRecordTempRespVO exectRecordTempRespVO;
            exectRecordTempRespVO.setState("0".equals((exectRecordTempRespVO = ExectRecordTempConvert.INSTANCE.doToResp((ExectRecordTempDO)((Object)t))).getState()) ? "\u542f\u7528" : "\u505c\u7528");
            return exectRecordTempRespVO;
        }).collect(Collectors.toList());
        return collect;
    }

    public ExectRecordTempRespVO queryByCode(String code) {
        log.info("queryByCode:" + JSON.toJSONString((Object)code));
        if (StringUtils.isEmpty((CharSequence)code)) {
            throw new BusinessException(ApiCode.FAIL, "\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        ExectRecordTempRespVO exectRecordTempRespVO = this.exectRecordTempRepoProc.queryByCode(code);
        if (Objects.isNull(exectRecordTempRespVO)) {
            return null;
        }
        List<ExectRecordTempDtlRespVO> exectRecordTempDtlRespVOS = this.exectRecordTempDtlRepoProc.get(exectRecordTempRespVO.getId());
        this.sysUdcProxyService.translate(exectRecordTempDtlRespVOS);
        exectRecordTempRespVO.setTempDtlRespVOS(exectRecordTempDtlRespVOS);
        exectRecordTempRespVO.setState("0".equals(exectRecordTempRespVO.getState()) ? "\u542f\u7528" : "\u505c\u7528");
        return exectRecordTempRespVO;
    }

    private void check(ExectRecordTempSaveVO saveVO) {
        if (saveVO.getTempName() == null) {
            throw new BusinessException(ApiCode.FAIL, "\u6a21\u677f\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (saveVO.getOuCode() == null) {
            throw new BusinessException(ApiCode.FAIL, "\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)saveVO.getOuId())) {
            throw new BusinessException(ApiCode.FAIL, "\u516c\u53f8id\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (saveVO.getOuName() == null) {
            throw new BusinessException(ApiCode.FAIL, "\u516c\u53f8\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (saveVO.getState() == null) {
            throw new BusinessException(ApiCode.FAIL, "\u72b6\u6001\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (saveVO.getTaskType() == null) {
            throw new BusinessException(ApiCode.FAIL, "\u4efb\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }

    public void udcConversion(List<ExectRecordTempRespVO> voList) {
        Map codeMap = this.udcProvider.getValueMapByUdcCode(UdcEnum.SALESMAN_TASK_TYPE_DST.getModel(), UdcEnum.SALESMAN_TASK_TYPE_DST.getCode());
        voList.stream().forEach(t -> {
            List<String> strings = Arrays.asList(t.getTaskType().split(";"));
            if (CollectionUtils.isNotEmpty(strings) && strings.size() > 1) {
                strings.stream().forEach(m -> {
                    if (MapUtil.isNotEmpty((Map)codeMap) && codeMap.containsKey(m)) {
                        t.setTaskTypeName((String)(StringUtils.isEmpty((CharSequence)t.getTaskTypeName()) ? (String)codeMap.get(m) : t.getTaskTypeName() + ";" + (String)codeMap.get(m)));
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(strings) && strings.size() == 1) {
                strings.stream().forEach(m -> {
                    if (MapUtil.isNotEmpty((Map)codeMap) && codeMap.containsKey(m)) {
                        t.setTaskTypeName((String)codeMap.get(m));
                    }
                });
            }
        });
    }

    public ExectRecordTempServiceImpl(ExectRecordTempRepo exectRecordTempRepo, ExectRecordTempRepoProc exectRecordTempRepoProc, ExectRecordTempDtlRepo exectRecordTempDtlRepo, ExectRecordTempDtlRepoProc exectRecordTempDtlRepoProc, RmiSysNextNumberService rmiSysNextNumberService, SysUdcProxyService sysUdcProxyService, TaskInfoRepoProc taskInfoRepoProc, FileInfoRepoProc fileInfoRepoProc, FileInfoRepo fileInfoRepo, UdcProvider udcProvider) {
        this.exectRecordTempRepo = exectRecordTempRepo;
        this.exectRecordTempRepoProc = exectRecordTempRepoProc;
        this.exectRecordTempDtlRepo = exectRecordTempDtlRepo;
        this.exectRecordTempDtlRepoProc = exectRecordTempDtlRepoProc;
        this.rmiSysNextNumberService = rmiSysNextNumberService;
        this.sysUdcProxyService = sysUdcProxyService;
        this.taskInfoRepoProc = taskInfoRepoProc;
        this.fileInfoRepoProc = fileInfoRepoProc;
        this.fileInfoRepo = fileInfoRepo;
        this.udcProvider = udcProvider;
    }
}

