/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.dto.param.ItemFreezeParam;
import com.elitesland.yst.production.sale.entity.BipItemDO;
import com.elitesland.yst.production.sale.entity.BipItemSkuDO;
import com.elitesland.yst.production.sale.event.ItemShelfEvent;
import com.elitesland.yst.production.sale.repo.shop.BipItemRepo;
import com.elitesland.yst.production.sale.repo.shop.BipItemRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepo;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepoProc;
import com.elitesland.yst.production.sale.service.BipItemRpcService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"/rpc/cloudt/sale/item"})
public class BipItemRpcServiceImpl
extends BaseServiceImpl
implements BipItemRpcService {
    private static final Logger log = LoggerFactory.getLogger(BipItemRpcServiceImpl.class);
    private final BipItemRepo itemRepo;
    private final BipItemSkuRepo bipItemSkuRepo;
    private final BipItemRepoProc bipItemRepoProc;
    private final BipItemSkuRepoProc bipItemSkuRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> updateItemFreeze(List<ItemFreezeParam> paramList) {
        log.info("\u51bb\u7ed3\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(paramList));
        ArrayList<Long> itemOffShelfIds = new ArrayList<Long>();
        for (ItemFreezeParam param : paramList) {
            Assert.notNull((Object)param.getFreeze(), (String)"\u51bb\u7ed3\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)param.getSkuCode(), (String)"SKU\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)param.getBuCode(), (String)"BuCode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            List<BipItemSkuDO> skuByCode = this.bipItemSkuRepoProc.findSkuByCode(param.getSkuCode());
            List<Long> itemIds = skuByCode.stream().map(BipItemSkuDO::getBipItemId).distinct().collect(Collectors.toList());
            List<Long> itemShouldIds = this.bipItemRepoProc.findByIdAndOuCode(itemIds, param.getBuCode());
            if (itemShouldIds == null || itemShouldIds.size() == 0) continue;
            ArrayList<BipItemSkuDO> collect = new ArrayList<BipItemSkuDO>();
            for (BipItemSkuDO sku : skuByCode) {
                if (!itemShouldIds.contains(sku.getBipItemId())) continue;
                sku.setFreeze(param.getFreeze());
                collect.add(sku);
                itemOffShelfIds.add(sku.getBipItemId());
            }
            log.info("\u51bb\u7ed3SKU\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(collect));
            if (collect.size() == 0) continue;
            this.bipItemSkuRepo.saveAll(collect);
        }
        List<Long> offShelf = this.filterOffShelf(itemOffShelfIds);
        this.updateOffShelfByApprove(offShelf);
        return ApiResult.ok();
    }

    private List<Long> filterOffShelf(List<Long> itemOffShelfIds) {
        ArrayList<Long> offShelfIds = new ArrayList<Long>();
        for (Long shelfId : itemOffShelfIds) {
            List<BipItemSkuDO> skuDOS = this.bipItemSkuRepoProc.queryByBipItemId(shelfId);
            List collect = skuDOS.stream().filter(BipItemSkuDO::getFreeze).collect(Collectors.toList());
            if (skuDOS.size() != collect.size()) continue;
            offShelfIds.add(shelfId);
        }
        return offShelfIds;
    }

    private void updateOffShelfByApprove(List<Long> offShelfIds) {
        List itemList = this.itemRepo.findAllById(offShelfIds);
        log.info("\u51bb\u7ed3\u81ea\u52a8\u4e0b\u67b6\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)itemList));
        List items = itemList.stream().filter(t -> UdcEnum.BIP_ITEM_STATE_SHELF.getValueCode().equals(t.getState()) && Boolean.TRUE.equals(t.getOnShelf())).collect(Collectors.toList());
        if (items.isEmpty()) {
            return;
        }
        for (BipItemDO item : items) {
            item.setState(UdcEnum.BIP_ITEM_STATE_OFF.getValueCode());
            item.setOnShelf(false);
            item.setTimeOnShelf(null);
            item.setTimeOffShelf(LocalDateTime.now());
            item.setOffShelfReason(UdcEnum.BIP_ITEM_OFF_SHELF_FREEZE.getValueCode());
        }
        log.info("\u51bb\u7ed3\u81ea\u52a8\u4e0b\u67b6\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(items));
        this.itemRepo.saveAll(items);
        for (BipItemDO item : items) {
            this.publishEventSync(new ItemShelfEvent(this, false, item.getId()));
        }
    }

    public BipItemRpcServiceImpl(BipItemRepo itemRepo, BipItemSkuRepo bipItemSkuRepo, BipItemRepoProc bipItemRepoProc, BipItemSkuRepoProc bipItemSkuRepoProc) {
        this.itemRepo = itemRepo;
        this.bipItemSkuRepo = bipItemSkuRepo;
        this.bipItemRepoProc = bipItemRepoProc;
        this.bipItemSkuRepoProc = bipItemSkuRepoProc;
    }
}

