/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.production.sale.api.service.shop.BipRotationChartService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipRotationChartQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipRetationChartVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipRetationChartSaveVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.BipRetationChartConvert;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.BipRetationChartDO;
import com.elitesland.yst.production.sale.entity.QBipRetationChartDO;
import com.elitesland.yst.production.sale.repo.shop.BipRetationChartRepo;
import com.elitesland.yst.production.sale.repo.shop.BipRotationChartRepoProc;
import com.elitesland.yst.production.sale.repo.shop.MktDiscountOffsetRepoProc;
import com.elitesland.yst.production.support.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BipRotationChartServiceImpl
implements BipRotationChartService {
    private final OrgEmpRpcService orgEmpRpcService;
    private final BipRetationChartRepo bipRetationChartRepo;
    private final BipRotationChartRepoProc bipRotationChartRepoProc;
    private final MktDiscountOffsetRepoProc mktDiscountOffsetRepoProc;
    private final QBipRetationChartDO qBipRetationChartDO = QBipRetationChartDO.bipRetationChartDO;
    private final Map<String, String> statusMap = new HashMap<String, String>();

    public PagingVO<BipRetationChartVO> search(BipRotationChartQueryParamVO param) {
        Predicate predicate = this.bipRotationChartRepoProc.where(param);
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)this.qBipRetationChartDO.getMetadata()));
        Page ret = this.bipRetationChartRepo.findAll(predicate, (Pageable)param.getPageRequest());
        List vos = ret.getContent().stream().map(BipRetationChartConvert.INSTANCE::doToVO).collect(Collectors.toList());
        for (BipRetationChartVO vo : vos) {
            if (!StringUtils.isNotBlank((CharSequence)vo.getStatus())) continue;
            vo.setStatusName(this.statusMap.get(vo.getStatus()));
        }
        return PagingVO.builder().total(ret.getTotalElements()).records(vos).build();
    }

    public List<BipRetationChartVO> homeRotation(Long ouId) {
        return this.bipRotationChartRepoProc.homeSlideshow(ouId);
    }

    public Optional<BipRetationChartVO> findIdOne(Long id) {
        return this.bipRetationChartRepo.findById(id).map(BipRetationChartConvert.INSTANCE::doToVO);
    }

    @Transactional(rollbackFor={Exception.class})
    public Long createOne(BipRetationChartSaveVO param) {
        Assert.notNull((Object)param.getOffsetCode(), (String)"\u8bf7\u8f93\u5165\u6ee1\u51cf\u6298\u6263\u7f16\u7801!", (Object[])new Object[0]);
        OrgUserEmpInfoRpcDTO empInfo = this.getCurrentEmpInfo();
        BipRetationChartDO bipRetationChartDO = BipRetationChartConvert.INSTANCE.saveToDo(param);
        bipRetationChartDO.setId(null);
        bipRetationChartDO.setSecBuId(empInfo.getBuId());
        bipRetationChartDO.setSecOuId(empInfo.getOuId());
        bipRetationChartDO.setSecUserId(empInfo.getUserId());
        bipRetationChartDO.setStatus(UdcEnum.COM_STATUS_RETAION_DRAFT.getValueCode());
        Assert.isTrue((boolean)this.mktDiscountOffsetRepoProc.checkValid(param.getOffsetCode()), (String)"\u8be5\u6ee1\u51cf\u6298\u6263\u672a\u751f\u6548!", (Object[])new Object[0]);
        return ((BipRetationChartDO)this.bipRetationChartRepo.save(bipRetationChartDO)).getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(BipRetationChartSaveVO param) {
        BipRetationChartDO objDo = BipRetationChartConvert.INSTANCE.saveToDo(param);
        Optional optional = this.bipRetationChartRepo.findById(objDo.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objDo.getId());
        }
        objDo.setId(((BipRetationChartDO)optional.get()).getId());
        this.bipRetationChartRepo.save(objDo);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlag(Long id) {
        BipRetationChartDO retationChartDO;
        Optional optionalItem = this.bipRetationChartRepo.findById(id);
        if (optionalItem.isPresent()) {
            retationChartDO = (BipRetationChartDO)optionalItem.get();
            if (UdcEnum.COM_STATUS_ACTIVEORNO_ACTIVE.getValueCode().equals(retationChartDO.getStatus())) {
                throw new BusinessException("\u542f\u7528\u72b6\u6001\u7684\u8f6e\u64ad\u56fe\u4e0d\u80fd\u5220\u9664");
            }
        } else {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        retationChartDO.setDeleteFlag(1);
        this.bipRetationChartRepo.save(retationChartDO);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> list) {
        list.forEach(this::updateDeleteFlag);
    }

    @Transactional(rollbackFor={Exception.class})
    public void changeStatus(List<Long> ids, String status) {
        if (UdcEnum.COM_STATUS_ACTIVEORNO_ACTIVE.getValueCode().equals(status)) {
            List slideshows = this.bipRetationChartRepo.findAllById(ids);
            for (BipRetationChartDO slideshow : slideshows) {
                LocalDateTime now = LocalDateTime.now();
                if (now.isAfter(slideshow.getEtime()) || now.isBefore(slideshow.getStime())) {
                    throw new BusinessException("\u6fc0\u6d3b\u9519\u8bef\uff0c\u5f53\u524d\u65f6\u95f4\u4e0d\u5728\u8be5\u8f6e\u64ad\u56fe\u7684\u751f\u6548\u65f6\u95f4\u4e4b\u5185\uff01");
                }
                if (this.bipRotationChartRepoProc.judgeActive(slideshow)) continue;
                throw new BusinessException("\u6fc0\u6d3b\u9519\u8bef\uff0c\u540c\u4e00\u65f6\u95f4\u540c\u4f18\u5148\u7ea7\u7684\u8f6e\u64ad\u56fe\u5df2\u5b58\u5728\uff01");
            }
        }
        if (!UdcEnum.COM_STATUS_ACTIVEORNO_ACTIVE.getValueCode().equals(status) && !UdcEnum.COM_STATUS_ACTIVEORNO_INACTIVE.getValueCode().equals(status)) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u72b6\u6001\u503c\u9519\u8bef:" + status);
        }
        this.bipRotationChartRepoProc.updateStatusBatch(ids, status);
    }

    private OrgUserEmpInfoRpcDTO getCurrentEmpInfo() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u5df2\u5931\u6548,\u8bf7\u91cd\u767b\u5f55\u91cd\u8bd5");
        }
        OrgUserEmpInfoRpcDTO userEmpInfo = this.orgEmpRpcService.findUserEmpInfo(currentUser.getUserId());
        if (userEmpInfo == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f");
        }
        return userEmpInfo;
    }

    public BipRotationChartServiceImpl(OrgEmpRpcService orgEmpRpcService, BipRetationChartRepo bipRetationChartRepo, BipRotationChartRepoProc bipRotationChartRepoProc, MktDiscountOffsetRepoProc mktDiscountOffsetRepoProc) {
        this.statusMap.put(UdcEnum.COM_STATUS_ACTIVEORNO_ACTIVE.getValueCode(), UdcEnum.COM_STATUS_ACTIVEORNO_ACTIVE.getValueCodeName());
        this.statusMap.put(UdcEnum.COM_STATUS_ACTIVEORNO_INACTIVE.getValueCode(), UdcEnum.COM_STATUS_ACTIVEORNO_INACTIVE.getValueCodeName());
        this.statusMap.put(UdcEnum.COM_STATUS_RETAION_DRAFT.getValueCode(), UdcEnum.COM_STATUS_RETAION_DRAFT.getValueCodeName());
        this.orgEmpRpcService = orgEmpRpcService;
        this.bipRetationChartRepo = bipRetationChartRepo;
        this.bipRotationChartRepoProc = bipRotationChartRepoProc;
        this.mktDiscountOffsetRepoProc = mktDiscountOffsetRepoProc;
    }
}

