package com.elitesland.yst.production.sale.controller.shop;

import com.elitesland.yst.production.sale.api.service.shop.BipAddressService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipAddressCreateParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipAddressUpdateParam;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipAddressVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author joker XingShixiang
 * @since 2021-09-01 14:43:56
 */
@RestController
@RequestMapping("/bip/address")
@Api(value = "收货地址", tags = {"收货地址"})
@RequiredArgsConstructor
public class BipAddressController {

    private final BipAddressService bipAddressService;

    @PostMapping("/create")
    @ApiOperation("新增一条收货地址")
    ApiResult<Long> createAddress(@RequestBody BipAddressCreateParam param) {
        return ApiResult.ok(bipAddressService.createAddress(param));
    }

    @DeleteMapping("/delete/{id}")
    @ApiOperation("删除一条收货地址（根据delete_flag逻辑删除）")
    @ApiImplicitParams(
            @ApiImplicitParam(name = "id" , value = "收获地址ID")
    )
    ApiResult<Long> deleteAddressById(@PathVariable Long id) {
        return ApiResult.ok(bipAddressService.deleteAddressById(id));
    }

    @PutMapping("/update")
    @ApiOperation("更新一条收货地址")
    ApiResult<Long> createAddress(@RequestBody BipAddressUpdateParam param) {
        return ApiResult.ok(bipAddressService.updateAddress(param));
    }

    @GetMapping("/findAll")
    @ApiOperation("根据客户id查找给客户的所有收货单")
    ApiResult<List<BipAddressVO>> selectAddress() {
        return ApiResult.ok(bipAddressService.findByAccountId());
    }

    @GetMapping("/findById/{id}")
    @ApiOperation("根据客户id查找给客户的所有收货单")
    ApiResult<BipAddressVO> findById(@PathVariable Long id) {
        return ApiResult.ok(bipAddressService.findById(id));
    }

    @PostMapping("/updateDefaultAddress/{id}")
    @ApiOperation("根据地址id更改是否为默认")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id" , value = "收获地址ID"),
    })
    ApiResult<Long> updateDefaultById(@PathVariable Long id) {
        return ApiResult.ok(bipAddressService.updateDefaultById(id));
    }

}


