package com.elitesland.yst.production.sale.convert;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoRespVO;
import com.elitesland.yst.production.sale.api.vo.save.TaskInfoSaveVO;
import com.elitesland.yst.production.sale.entity.TaskInfoDO;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

/**
 * <p>
 * 功能说明:业务员任务管理
 * </p>
 *
 * @Author Darren
 * @Date 2023/04/10
 * @Version 1.0
 * @Content:
 */
@Mapper(config = BaseMapperConfig.class)
public interface TaskInfoConvert {
    TaskInfoConvert INSTANCE = Mappers.getMapper(TaskInfoConvert.class);

    /**
     * saveVO转换DO
     *
     * @param saveVO 入参
     * @return DO
     */
    TaskInfoDO saveVoToDo(TaskInfoSaveVO saveVO);

    /**
     * DO转换RespVO
     *
     * @param taskInfoDO 入参
     * @return RespVO
     */
    TaskInfoRespVO doToRespVo(TaskInfoDO taskInfoDO);

    /**
     * respVO转换saveVO
     *
     * @param respVO 入参
     * @return saveVO
     */
    TaskInfoSaveVO respVoToSaveVO(TaskInfoRespVO respVO);

}
