package com.elitesland.yst.production.sale.entity;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/20/16:31
 * @Description:
 */

@Entity
@Table(name = "bip_order_back")
@org.hibernate.annotations.Table(appliesTo = "bip_order_back", comment = "订单表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class BipOrderBackDO extends BaseModel implements Serializable {


    private static final long serialVersionUID = 5722597196130784251L;
    @Column(name = "ou_id", columnDefinition = "bigInt(20) comment '公司id'")
    private Long ouId;

    @Column(name = "ou_code", columnDefinition = "varchar(64) comment '公司编码'")
    private String ouCode;


    @Column(name = "ou_name", columnDefinition = "varchar(64) comment '公司名称'")
    private String ouName;

    @Column(name = "bu_id", columnDefinition = "bigInt(20) comment '组织id'")
    private Long buId;

    @Column(name = "bu_code", columnDefinition = "varchar(64) comment '组织编码'")
    private String buCode;


    @Column(name = "bu_name", columnDefinition = "varchar(64) comment '组织名称'")
    private String buName;

    @Column(name = "order_id", columnDefinition = "bigInt(20) comment '订单主表id'")
    private Long orderId;
    @Column(name = "cust_id", columnDefinition = "bigInt(20) comment '下单客户id'")
    private Long custId;

    @Column(name = "cust_code", columnDefinition = "varchar(64) comment '下单客户编码'")
    private String custCode;

    @Column(name = "cust_code2", columnDefinition = "varchar(64) comment '下单客户编码'")
    private String custCode2;


    @Column(name = "cust_name", columnDefinition = "varchar(64) comment '下单客户姓名'")
    private String custName;

    @Column(name = "agent_emp_id", columnDefinition = "bigInt(20) comment '业务员员工id'")
    private Long agentEmpId;


    @Column(name = "agent_name", columnDefinition = "varchar(64)  comment '业务员员工名字'")
    private String agentName;

    @Column(name = "cust_account_id", columnDefinition = "bigInt(20) comment '登录人id'")
    private Long custAccountId;

    @Column(name = "cust_account_name", columnDefinition = "varchar(64) comment '登录人姓名'")
    private String custAccountName;


    @Column(name = "order_doc_no", columnDefinition = "varchar(64) comment '订单主表单号'")
    private String orderDocNo;

    @Column(name = "order_back_doc_no", columnDefinition = "varchar(64) comment '订单主表单号'")
    private String orderBackDocNo;


    @Column(name = "approve_time", columnDefinition = "datetime comment '审核时间'")
    private LocalDateTime approveTime;

    @Column(name = "sign_time", columnDefinition = "datetime comment '签收时间'")
    private LocalDateTime signTime;

    @Column(name = "refuse_reason", columnDefinition = "varchar(256) comment '审核拒绝原因'")
    private String refuseReason;

    @Column(name = "back_reason", columnDefinition = "varchar(256) comment '退款原因'")
    private String backReason;

    @Column(name = "status", columnDefinition = "varchar(32) comment '订单状态'")
    private String status;


    @Column(name = "apply_back_amt", columnDefinition = "decimal(20,2) default 0 comment '申请退款金额'")
    private BigDecimal applyBackAmt;

    @Column(name = "approve_back_amt", columnDefinition = "decimal(20,2) default 0 comment '批准退款金额'")
    private BigDecimal approveBackAmt;

    @Column(name = "back_type", columnDefinition = "varchar(20) comment '退货类型'")
    private String backType;

    @Column(name = "back_pay_time", columnDefinition = "datetime comment '退款时间'")
    private LocalDateTime backPayTime;

    @Column(name = "back_time", columnDefinition = "datetime comment '退货时间'")
    private LocalDateTime backTime;

    @Column(name = "is_word_order", columnDefinition = "tinyint(1) default 0 comment '是否需要生成工单'")
    private Boolean isWorkOrder;

    @Column(name = "shipper_name", columnDefinition = "varchar(32) comment '寄货人姓名'")
    private String shipperName;

    @Column(name = "shipper_tel", columnDefinition = "varchar(32) comment '寄货人电话'")
    private String shipperTel;

    @Column(name = "receiver_name", columnDefinition = "varchar(32) comment '收货人姓名'")
    private String receiverName;

    @Column(name = "receiver_tel", columnDefinition = "varchar(32) comment '收货人电话'")
    private String receiverTel;


    @Column(name = "file_codes", columnDefinition = "varchar(64) comment '退货图片'")
    private String fileCodes;

    @Column(name = "back_des", columnDefinition = "varchar(256) comment '退货描述'")
    private String backDes;

    @Column(name = "logist_doc_no", columnDefinition = "varchar(64) comment '物流单号'")
    private String logistDocNo;


    @Column(name = "txsn", columnDefinition = "varchar(64) comment '退货单流水号'")
    private String txsn;

    @Column(name = "return_msg", columnDefinition = "varchar(256) comment '退货单流水号'")
    private String returnMsg;

    @Column(name = "logis_company", columnDefinition = "varchar(256) comment '物流公司编号'")
    private String logisCompany;

    @Column(name = "is_create_receipt", columnDefinition = "tinyint(1) default 0 comment '是否生成退款单'")
    private Boolean isCreateReceipt;


    /*
     *   退货工作流,新增字段
     */
    /**
     * 审批原有
     */
    @Column(name = "approve_user_id", columnDefinition = "bigInt(20) comment '审批人id'")
    private Long approveUserId;

    @Column(name = "approve_user_name", columnDefinition = "varchar(32) comment '审批人姓名'")
    private String approveUserName;

    /**
     * 审批流字段新增
     */
    @ApiModelProperty("流程实例ID")
    @Column
    @Comment("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    @Column
    @Comment("流程实例状态")
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @ApiModelProperty(value = "提交时间")
    @Comment("提交时间")
    @Column
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    @Comment("审批通过时间")
    @Column
    private LocalDateTime approvedTime;

}
