package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name = "crm_cust_extend")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "crm_cust_extend", comment = "客户拓展表")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Data
@ApiModel(value = "crm_cust_extend", description = "客户拓展表")
public class CrmCustExtendDO extends BaseModel {

    private static final long serialVersionUID = -4779658570818887567L;

    @Column(name = "cust_id", columnDefinition = "bigint(18) default null  comment '客户ID'")
    private Long custId;

    @Column(name = "cust_code", columnDefinition = "varchar(255) comment '客户编码'")
    private String custCode;

    @Column(name = "inv_cust_code", columnDefinition = "varchar(255) comment '库存客户号 弹窗选择启用的客户信息，如果库存客户号为空时，客户看不到任务库存'")
    private String invCustCode;

    @Column(name = "order_signx", columnDefinition = "varchar(255) comment '向立马订货 是、否 从K3系统接口同步，用于标识某些二网客户能够直接向立马订货'")
    private String orderSignx;

    @Column(name = "adjust_Signx", columnDefinition = "varchar(255) comment '自动生成调整单  从K3系统接口同步， 是、否 场景：客户订购配件时，配件账户没有账款，能够从整车账户扣款，打了该标识的客户可以自动生成调整单'")
    private String adjustSignx;



}
