package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 销售合同收款计划
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/9 9:59 上午
 */
@Entity
@Table(name = "sal_contract_recv")
@org.hibernate.annotations.Table(appliesTo = "sal_contract_recv", comment = "销售合同收款计划")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class SalContractRecvDO extends BaseModel implements Serializable {

    @ApiModelProperty(value = "主表ID")
    @Column(name = "mas_id", columnDefinition = "bigint(20) default 0 comment '主表ID'")
    private Long masId;

    @ApiModelProperty("合同编号")
    @Column(name = "contract_no", columnDefinition = "varchar(40) comment '合同编号'")
    private String contractNo;

    @ApiModelProperty(value = "应收金额")
    @Column(name = "ar_amt", columnDefinition = "decimal(20, 2) default null comment '应收金额'")
    private BigDecimal arAmt;

    @ApiModelProperty(value = "币种")
    @Column(name = "curr_code", columnDefinition = "varchar(10) default null comment '币种'")
    private String currCode;

    @ApiModelProperty(value = "税率编号")
    @Column(name = "tax_rate_no", columnDefinition = "varchar(40) default null comment '税率编号'")
    private String taxRateNo;

    @ApiModelProperty(value = "税率")
    @Column(name = "tax_rate", columnDefinition = "decimal(20, 8) default null comment '税率'")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "应收日期")
    @Column(name = "ar_date", columnDefinition = "datetime default null comment '应收日期'")
    private LocalDate arDate;

    @ApiModelProperty(value = "实际收款日期")
    @Column(name = "real_recv_date", columnDefinition = "datetime default null comment '实际收款日期'")
    private LocalDate realRecvDate;

    @ApiModelProperty(value = "录入人")
    @Column(name = "inputer", columnDefinition = "varchar(20) default null comment '录入人'")
    private String inputer;

    @ApiModelProperty(value = "录入日期")
    @Column(name = "input_date", columnDefinition = "datetime default null comment '录入日期'")
    private LocalDate inputDate;

    @ApiModelProperty(value = "开票日期")
    @Column(name = "inv_date", columnDefinition = "datetime default null comment '开票日期'")
    private LocalDate invDate;

    @ApiModelProperty(value = "开票申请单ID")
    @Column(name = "inv_apply_id", columnDefinition = "bigint(20) default 0 comment '开票申请单ID'")
    private Integer invApplyId;

    @ApiModelProperty(value = "开票申请单号")
    @Column(name = "inv_apply_no", columnDefinition = "varchar(40) default null  comment '开票申请单号'")
    private String invApplyNo;

    @ApiModelProperty(value = "状态")
    @Column(name = "recv_status", columnDefinition = "varchar(40) default null comment '状态'")
    private String recvStatus;


}
