package com.elitesland.yst.production.sale.ext.cpcn.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author yifansir(jin yan qiang)
 * @date 2021/8/3
 */
@Data
@EqualsAndHashCode
@ApiModel(description = "中金综合支付参数")
public class CPCN5011Param implements Serializable {
    private static final long serialVersionUID = 8883182274949440488L;

    @ApiModelProperty("交易流水号")
    private String txSN;

    @ApiModelProperty("业务订单号")
    public String orderNo;

    @ApiModelProperty("付款用户ID")
    public String payerUserID;

    @ApiModelProperty("收款用户ID")
    public String payeeUserID;

    @ApiModelProperty("收款用户帐号")
    public String payeeAccountNumber;

    @ApiModelProperty("付款方式")
    public String paymentWay="80";

    @ApiModelProperty("待支付金额")
    public BigDecimal amount;

    @ApiModelProperty("后台通知地址")
    public String noticeUrl;

    @ApiModelProperty("回调URL地址")
    public String pageURL;

    @ApiModelProperty("商品名称")
    public String goodsName;

    @ApiModelProperty("平台名称")
    public String platformName;

    @ApiModelProperty("客户ip")
    public String clientIP;

    @ApiModelProperty("是否分账：1-否 0 是")
    public String hasSubsequentSplit;

    @ApiModelProperty("实时扣收手续费挂账的结算标识")
    public String deductionSettlementFlag;

    @ApiModelProperty("备注")
    public String remark;

    @ApiModelProperty("支付方式")
    public String payWay;

    @ApiModelProperty("支付类型")
    public String payType;

    @ApiModelProperty("发卡行")
    public String redirectPayBankID;

    @ApiModelProperty("支付方式限制")
    public String limitPay;

    @ApiModelProperty("支付方式限制")
    public String subOpenID;

    @ApiModelProperty("appId")
    public String subAppID;

    @ApiModelProperty("分期控制标识")
    public String installmentType;

    @ApiModelProperty("手续费收取模式")
    public String feeMode;

    @ApiModelProperty("支付方式限制")
    public String bankAccountNumber;

    @ApiModelProperty("分期期数")
    public String numberOfInstallments;

    @ApiModelProperty("跳转前来源")
    public String redirectSource;



}
