package com.elitesland.yst.production.sale.repo;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.ExectRecordTempQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.ExectRecordTempRespVO;
import com.elitesland.yst.production.sale.entity.QExectRecordTempDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

@Component
public class ExectRecordTempRepoProc {

    private final QExectRecordTempDO qExectRecordTempDO = QExectRecordTempDO.exectRecordTempDO;
    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    public PagingVO<ExectRecordTempRespVO> page(ExectRecordTempQueryVO exectRecordTempPageParam) {
        JPAQuery<ExectRecordTempRespVO> query = select(ExectRecordTempRespVO.class)
                .where(bulidPredicate(exectRecordTempPageParam));
        exectRecordTempPageParam.setPaging(query);
        exectRecordTempPageParam.fillOrders(query, qExectRecordTempDO);
        return PagingVO.<ExectRecordTempRespVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }


    public Long del(List<Long> ids) {
        Long res = jpaQueryFactory.update(qExectRecordTempDO)
                .set(qExectRecordTempDO.deleteFlag, 1)
                .where(qExectRecordTempDO.id.in(ids))
                .execute();
        return res;
    }


    public ExectRecordTempRespVO get(Long id) {
        ExectRecordTempRespVO exectRecordTempVO = select(ExectRecordTempRespVO.class)
                .where(qExectRecordTempDO.id.eq(id))
                .fetchOne();
        return exectRecordTempVO;
    }


    public List<ExectRecordTempRespVO> getList(ExectRecordTempQueryVO exectRecordTempQueryVO) {
        List<ExectRecordTempRespVO> res = select(ExectRecordTempRespVO.class)
                .where(bulidPredicate(exectRecordTempQueryVO))
                .where(qExectRecordTempDO.state.eq("0"))
                .fetch();
        return res;
    }


    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qExectRecordTempDO.tempCode,
                qExectRecordTempDO.tempName,
                qExectRecordTempDO.ouId,
                qExectRecordTempDO.ouCode,
                qExectRecordTempDO.ouName,
                qExectRecordTempDO.state,
                qExectRecordTempDO.taskType,
                qExectRecordTempDO.tempDesc,
                qExectRecordTempDO.id,
                qExectRecordTempDO.createTime,
                qExectRecordTempDO.creator,
                qExectRecordTempDO.updater,
                qExectRecordTempDO.modifyTime,
                qExectRecordTempDO.remark
        )).from(qExectRecordTempDO);
    }

    private Predicate bulidPredicate(ExectRecordTempQueryVO exectRecordTempPageParam) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder()
                .andLike(StringUtils.isNotBlank(exectRecordTempPageParam.getTempCode()), qExectRecordTempDO.tempCode, exectRecordTempPageParam.getTempCode())
                .andLike(StringUtils.isNotBlank(exectRecordTempPageParam.getTempName()), qExectRecordTempDO.tempName, exectRecordTempPageParam.getTempName())
                .andEq(null != exectRecordTempPageParam.getOuId(), qExectRecordTempDO.ouId, exectRecordTempPageParam.getOuId())
                .andLike(StringUtils.isNotBlank(exectRecordTempPageParam.getOuCode()), qExectRecordTempDO.ouCode, exectRecordTempPageParam.getOuCode())
                .andLike(StringUtils.isNotBlank(exectRecordTempPageParam.getOuName()), qExectRecordTempDO.ouName, exectRecordTempPageParam.getOuName())
                .andEq(StringUtils.isNotBlank(exectRecordTempPageParam.getState()), qExectRecordTempDO.state, exectRecordTempPageParam.getState())
                .andLike(StringUtils.isNotBlank(exectRecordTempPageParam.getTaskType()), qExectRecordTempDO.taskType, exectRecordTempPageParam.getTaskType())
                .andEq(StringUtils.isNotBlank(exectRecordTempPageParam.getTempDesc()), qExectRecordTempDO.tempDesc, exectRecordTempPageParam.getTempDesc())
                .andLike(StringUtils.isNotBlank(exectRecordTempPageParam.getCreator()), qExectRecordTempDO.creator, exectRecordTempPageParam.getCreator())
                .build();

        if(CollectionUtils.isNotEmpty(exectRecordTempPageParam.getTaskTypeList())){
            List<String> tempList = exectRecordTempPageParam.getTaskTypeList();
            List<Predicate> collect = tempList.stream().map(t -> {
                Predicate like = qExectRecordTempDO.taskType.like("%" + t + "%");
                return like;
            }).collect(Collectors.toList());
            predicate=ExpressionUtils.and(predicate,ExpressionUtils.anyOf(collect));
        }

        return predicate;
    }

    public void updateStatus(Long id, String s) {
       jpaQueryFactory.update(qExectRecordTempDO)
                .set(qExectRecordTempDO.state, s)
                .where(qExectRecordTempDO.id.eq(id))
                .execute();
    }

    public List<ExectRecordTempRespVO> queryByCodes(List<String> codes) {
        List<ExectRecordTempRespVO> fetch = select(ExectRecordTempRespVO.class)
                .where(qExectRecordTempDO.tempCode.in(codes))
                .where(qExectRecordTempDO.deleteFlag.eq(0).or(qExectRecordTempDO.deleteFlag.isNull()))
                .fetch();
        return fetch;
    }
    public ExectRecordTempRespVO queryByCode(String code) {
        ExectRecordTempRespVO fetch = select(ExectRecordTempRespVO.class)
                .where(qExectRecordTempDO.tempCode.eq(code))
                .where(qExectRecordTempDO.deleteFlag.eq(0).or(qExectRecordTempDO.deleteFlag.isNull()))
                .fetchOne();
        return fetch;
    }
}