package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.entity.PriSalePriceDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/5/19 11:26 上午
 */
public interface PriSalePriceRepo extends JpaRepository<PriSalePriceDO, Long>, QuerydslPredicateExecutor<PriSalePriceDO> {
    @Transactional
    @Modifying
    @Query(value = "update pri_sale_price set modify_user_id = ?1,updater = ?2 where id in ?3", nativeQuery = true)
    void updatePriSalePriceUpdater(Long modifyUserId, String updater, List<Long> ids);
}
