package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.api.vo.param.sal.SalReceiptPageParam;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalReceiptRespVO;
import com.elitesland.yst.production.sale.entity.QSalReceiptDDO;
import com.elitesland.yst.production.sale.entity.QSalReceiptDO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.val;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

/**
 * @auther JinXK
 * @date 2021/6/12 11:28
 */
@Repository
public class SalReceiptRepoProc {
    @Autowired
    private JPAQueryFactory jpaQueryFactory;
    /**
     * 查询字段
     */
    public JPAQuery<SalReceiptRespVO> select(SalReceiptPageParam param) {
        val salReceiptDO = QSalReceiptDO.salReceiptDO;
        val salReceiptDDO = QSalReceiptDDO.salReceiptDDO;

        Predicate predicate = salReceiptDO.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(SalReceiptRespVO.class,
                salReceiptDO.id,
                salReceiptDO.ouId,
                salReceiptDO.ouCode,
                salReceiptDO.ouName,
                salReceiptDO.buId,
                salReceiptDO.buName,
                salReceiptDO.docNo,
                salReceiptDO.docStatus,
                salReceiptDO.applyEmpId,
                salReceiptDO.applyName,
                salReceiptDO.applyDate,
                salReceiptDO.payMethod,
                salReceiptDO.planReceiptDate,
                salReceiptDO.b2bFlag,
                salReceiptDO.relateDocId,
                salReceiptDO.relateDocNo,
                salReceiptDO.receiptType,
                salReceiptDO.amt,
                salReceiptDO.tax,
                salReceiptDO.ckName,
                salReceiptDO.ckAccNo,
                salReceiptDO.ckBank,
                salReceiptDO.ckDate,
                salReceiptDO.ckDuedate,
                salReceiptDO.ckNo,
                salReceiptDO.ckAmt,
                salReceiptDO.ckStatus,
                salReceiptDO.ckAccepter,
                salReceiptDO.contractCode,
                salReceiptDO.ckBank1,
                salReceiptDO.saleRegion,
                salReceiptDO.contractName,
                salReceiptDO.contractId,
                salReceiptDO.custName,
                salReceiptDO.custCode,
                salReceiptDO.custId,
                salReceiptDO.offFlag,
                salReceiptDO.ckAllowtrFlag,
                salReceiptDO.writeoffAmt,
                salReceiptDO.transferAmt,
                salReceiptDO.transferingAmt,
                salReceiptDO.returnAmt,
                salReceiptDO.returningAmt,
                salReceiptDO.openAmt,
                salReceiptDO.docStatus2,
                salReceiptDO.soNo,
                salReceiptDO.soaOrSo,
                salReceiptDO.docType,
                salReceiptDO.bankId,
                salReceiptDO.bankCode,
                salReceiptDO.bankName,
                salReceiptDO.bankAcc,
                salReceiptDO.holderName,
                salReceiptDO.reason,
                salReceiptDO.custContactName,
                salReceiptDO.custContactTel,
                salReceiptDO.apprUserId,
                salReceiptDO.apprComment,
                salReceiptDO.remark,
                salReceiptDO.createUserId,
                salReceiptDO.creator,
                salReceiptDO.ouBankAcc,
                salReceiptDO.ouHolderName,
                salReceiptDO.currCode,
                salReceiptDO.currName

        )).from(salReceiptDO)
                .leftJoin(salReceiptDDO).on(salReceiptDO.id.eq(salReceiptDDO.masId));
        if (param != null) {
            jpaQuery.where(where(param));
        }
        jpaQuery.where(predicate, salReceiptDO.deleteFlag.eq(0).or(salReceiptDO.deleteFlag.isNull()));
        jpaQuery.where(predicate, DataAuthJpaUtil.dataAuthJpaPredicate(salReceiptDO.getMetadata()));
        jpaQuery.groupBy(salReceiptDO.id);
        jpaQuery.orderBy(salReceiptDO.modifyTime.desc());
        return jpaQuery;
    }


    /**
     * 条件查询
     *
     * @param param 查询条件
     */
    public Predicate where(SalReceiptPageParam param) {
        val salReceiptDO = QSalReceiptDO.salReceiptDO;
        val salReceiptDDO = QSalReceiptDDO.salReceiptDDO;
        Predicate predicate = salReceiptDO.isNotNull().or(salReceiptDO.isNull());
        if (!StringUtils.isEmpty(param.getDocNo())) {
            predicate = ExpressionUtils.and(predicate, salReceiptDO.docNo.like("%"+param.getDocNo()+"%"));
        }
        if (!StringUtils.isEmpty(param.getCustCode())) {
            predicate = ExpressionUtils.and(predicate, salReceiptDO.custCode.like("%"+param.getCustCode()+"%"));
        }
        if (!StringUtils.isEmpty(param.getCustName())) {
            predicate = ExpressionUtils.and(predicate, salReceiptDO.custName.like("%"+param.getCustName()+"%"));
        }
        if (!StringUtils.isEmpty(param.getContractCode())) {
            predicate = ExpressionUtils.and(predicate, salReceiptDO.contractCode.like("%"+param.getContractCode()+"%"));
        }
        if (!StringUtils.isEmpty(param.getContractName())) {
            predicate = ExpressionUtils.and(predicate, salReceiptDO.contractName.like("%"+param.getContractName()+"%"));
        }
        if (!StringUtils.isEmpty(param.getRelateDocNo())) {
            predicate = ExpressionUtils.and(predicate, salReceiptDO.relateDocNo.like("%"+param.getRelateDocNo()+"%"));
        }
        if (!StringUtils.isEmpty(param.getApplyName())) {
            predicate = ExpressionUtils.and(predicate, salReceiptDO.applyName.like("%"+param.getApplyName()+"%"));
        }
        if (!StringUtils.isEmpty(param.getId())) {
            predicate = ExpressionUtils.and(predicate, salReceiptDO.id.eq(param.getId()));
        }
        if (!StringUtils.isEmpty(param.getPayMethod())) {
            predicate = ExpressionUtils.and(predicate, salReceiptDO.payMethod.eq(param.getPayMethod()));
        }
        if (!StringUtils.isEmpty(param.getDocType())) {
            predicate = ExpressionUtils.and(predicate, salReceiptDO.docType.eq(param.getDocType()));
        }
        if (!StringUtils.isEmpty(param.getOuId())) {
            predicate = ExpressionUtils.and(predicate, salReceiptDO.ouId.eq(param.getOuId()));
        }
        if (!StringUtils.isEmpty(param.getDocStatus())) {
            predicate = ExpressionUtils.and(predicate, salReceiptDO.docStatus.eq(param.getDocStatus()));
        }
        if (!StringUtils.isEmpty(param.getApplyEmpId())) {
            predicate = ExpressionUtils.and(predicate, salReceiptDO.applyEmpId.eq(param.getApplyEmpId()));
        }
        if (!StringUtils.isEmpty(param.getReceiptType())) {
            predicate = ExpressionUtils.and(predicate, salReceiptDO.receiptType.eq(param.getReceiptType()));
        }
        if (!StringUtils.isEmpty(param.getB2bFlag())) {
            predicate = ExpressionUtils.and(predicate, salReceiptDO.b2bFlag.eq(param.getB2bFlag()));
        }
        if (!StringUtils.isEmpty(param.getSaleRegion())) {
            predicate = ExpressionUtils.and(predicate, salReceiptDO.applyDate.eq(param.getApplyDateStart()).or(salReceiptDO.applyDate.after(param.getApplyDateStart())));
        }
        if (!StringUtils.isEmpty(param.getDocStatus2())) {
            predicate = ExpressionUtils.and(predicate, salReceiptDO.docStatus2.eq(param.getDocStatus2()));
        }
        if (!StringUtils.isEmpty(param.getSoDocNo())) {
            predicate = ExpressionUtils.and(predicate, salReceiptDDO.soNo.eq(param.getSoDocNo()));
        }
        if (!StringUtils.isEmpty(param.getApplyDateStart())) {
            predicate = ExpressionUtils.and(predicate, salReceiptDO.applyDate.after(param.getApplyDateStart()));
        }
        if (!StringUtils.isEmpty(param.getApplyDateEnd())) {
            predicate = ExpressionUtils.and(predicate, salReceiptDO.applyDate.before(param.getApplyDateEnd()));
        }
        return predicate;
    }
}
