package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.entity.SaleStatisticsDealerDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;


/**
 * @author : WWW
 * @date : 2023-6-1
 * @desc : 销售业绩统计-经销商Repo
 */

@Repository
public interface SaleStatisticsDealerRepo extends JpaRepository<SaleStatisticsDealerDO, Long>, QuerydslPredicateExecutor<SaleStatisticsDealerDO> {

    /**
     * warn:删除时，请确认是否先调用 明细的删除方法，避免 主表删除了，但明细表依然存在的情况
     * @param startTime
     * @param endTime
     */
    @Transactional
    @Modifying
    @Query(value = "delete from sale_statistics_dealer where doc_time between ?1 and ?2", nativeQuery = true)
    void deleteByDocTime(LocalDateTime startTime, LocalDateTime endTime);
}

