package com.elitesland.yst.production.sale.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsDealerQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsDealerRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsDealerAppSumRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsDealerSumRespVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.entity.QSaleStatisticsDealerDO;
import com.elitesland.yst.production.sale.entity.QSaleStatisticsDealerDtlDO;
import com.elitesland.yst.production.sale.entity.SaleStatisticsDealerDO;
import com.querydsl.core.types.*;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import javax.transaction.Transactional;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;


/**
 * @author : WWW
 * @date : 2023-6-1
 * @desc : 销售业绩统计-经销商RepoProc
 */

@Component
public class SaleStatisticsDealerRepoProc extends BaseRepoProc<SaleStatisticsDealerDO> {

    private static final QSaleStatisticsDealerDO qSaleStatisticsDealerDO = QSaleStatisticsDealerDO.saleStatisticsDealerDO;
    private static final QSaleStatisticsDealerDtlDO qSaleStatisticsDealerDtlDO = QSaleStatisticsDealerDtlDO.saleStatisticsDealerDtlDO;

    protected SaleStatisticsDealerRepoProc() {
        super(qSaleStatisticsDealerDO);
    }

    private final String YEAR_MONTH = "yearMonth";
    private final String DOC_TIME_YEAR_MONTH = "docMonth";
    private final String SHIP_TOTAL_QTY = "shipTotalQty";
    private final String ORDER_TOTAL_QTY = "orderTotalQty";
    private final String DEALER_TOTAL_QTY = "dealerTotalQty";
    private final String AGENT_EMP_CODE = "agentEmpCode";

    /**
     * 根据客户编码查询主表ID，按id正序排列
     * @param custCode
     * @param minId
     * @param limit
     * @return
     */
    public List<Long> findIdsByCustCode(String custCode, Long minId, int limit) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qSaleStatisticsDealerDO.id)
                .from(qSaleStatisticsDealerDO)
                .where(qSaleStatisticsDealerDO.dealerCode.eq(custCode))
                .orderBy(qSaleStatisticsDealerDO.id.asc())
                .limit(limit);
        if(minId != null){
            jpaQuery.where(qSaleStatisticsDealerDO.id.gt(minId));
        }

        return jpaQuery.fetch();
    }

    public List<SaleStatisticsDealerRespVO> selectByQueryVO(SaleStatisticsDealerQueryVO queryVO) {
        List<Predicate> where = where(queryVO);
        JPAQuery<SaleStatisticsDealerRespVO> jpaQuery = select(SaleStatisticsDealerRespVO.class).where(ExpressionUtils.allOf(where));
        return jpaQuery.fetch();
    }

    public SaleStatisticsDealerRespVO selectOneByQueryVO(SaleStatisticsDealerQueryVO queryVO) {
        List<Predicate> where = where(queryVO);
        JPAQuery<SaleStatisticsDealerRespVO> jpaQuery = select(SaleStatisticsDealerRespVO.class).where(ExpressionUtils.allOf(where));
        return jpaQuery.fetchFirst();
    }

    public List<SaleStatisticsDealerRespVO> selectOldByQueryVO(SaleStatisticsDealerQueryVO queryVO) {
        List<Predicate> where = where(queryVO);
        JPAQuery<SaleStatisticsDealerRespVO> jpaQuery = jpaQueryFactory.select(Projections.bean(SaleStatisticsDealerRespVO.class,
                qSaleStatisticsDealerDO.id)).from(qSaleStatisticsDealerDO)
                .where(ExpressionUtils.allOf(where));
        return jpaQuery.fetch();
    }

    public List<SaleStatisticsDealerRespVO> selectPageByQueryVO(SaleStatisticsDealerQueryVO queryVO) {
        List<Predicate> where = where(queryVO);
        JPAQuery<SaleStatisticsDealerRespVO> jpaQuery = select(SaleStatisticsDealerRespVO.class).where(ExpressionUtils.allOf(where));
        queryVO.setPaging(jpaQuery);
        queryVO.fillOrders(jpaQuery, qSaleStatisticsDealerDO);
        return jpaQuery.fetch();
    }

    public StatisticsDealerSumRespVO pageSum(SaleStatisticsDealerQueryVO queryVO) {
        List<Predicate> where = where(queryVO);
        JPAQuery<StatisticsDealerSumRespVO> query = jpaQueryFactory.select(
                Projections.bean(StatisticsDealerSumRespVO.class,
                        qSaleStatisticsDealerDO.shipQty.sum().as(SHIP_TOTAL_QTY),
                        qSaleStatisticsDealerDO.orderQty.sum().as(ORDER_TOTAL_QTY),
                        qSaleStatisticsDealerDO.dealerCode.countDistinct().as(DEALER_TOTAL_QTY))
                        )
                .from(qSaleStatisticsDealerDO)
                .where(ExpressionUtils.allOf(where));
        return query.fetchFirst();
    }

    public PagingVO<SaleStatisticsDealerRespVO> page(SaleStatisticsDealerQueryVO queryVO) {
        List<Predicate> where = where2(queryVO);
        JPAQuery<SaleStatisticsDealerRespVO> query = pageSelect(SaleStatisticsDealerRespVO.class).where(ExpressionUtils.allOf(where));
        query.groupBy(qSaleStatisticsDealerDO.region, qSaleStatisticsDealerDO.dealerCode,
                qSaleStatisticsDealerDO.salesmanPath, qSaleStatisticsDealerDO.vehicleType,
                qSaleStatisticsDealerDO.docTime);
        //Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m')", qSaleStatisticsDealerDO.docTime).as(DOC_TIME_YEAR_MONTH));

        if (!Objects.isNull(queryVO.getShipTotalQtyFrom())) {
            query.having(qSaleStatisticsDealerDO.shipQty.sum().goe(queryVO.getShipTotalQtyFrom()));
        }
        if (!Objects.isNull(queryVO.getShipTotalQtyTo())) {
            query.having(qSaleStatisticsDealerDO.shipQty.sum().loe(queryVO.getShipTotalQtyTo()));
        }
        if (!Objects.isNull(queryVO.getOrderTotalQtyFrom())) {
            query.having(qSaleStatisticsDealerDO.orderQty.sum().goe(queryVO.getOrderTotalQtyFrom()));
        }
        if (!Objects.isNull(queryVO.getOrderTotalQtyTo())) {
            query.having(qSaleStatisticsDealerDO.orderQty.sum().loe(queryVO.getOrderTotalQtyTo()));
        }
        queryVO.setPaging(query);
//        query.orderBy(qSaleStatisticsDealerDO.docTime.yearMonth().desc());
        if (CollectionUtils.isNotEmpty(queryVO.getOrders())) {
            for (OrderItem orderItem : queryVO.getOrders()) {
                if (StringUtils.isNotBlank(orderItem.getColumn())) {
                    Order order = orderItem.isAsc() ? Order.ASC : Order.DESC;
                    OrderSpecifier orderSpecifier3 = new OrderSpecifier(order,
                            Expressions.stringTemplate(orderItem.getColumn()));
                    query.orderBy(orderSpecifier3);
                }
            }
        }
       /* OrderSpecifier orderSpecifier = new OrderSpecifier(Order.DESC,
                Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m-%d')", qSaleStatisticsDealerDO.docTime));
        query.orderBy(orderSpecifier);*/
        query.orderBy(qSaleStatisticsDealerDO.docTime.desc());
        query.orderBy(qSaleStatisticsDealerDO.createTime.desc());

        return PagingVO.<SaleStatisticsDealerRespVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public PagingVO<SaleStatisticsDealerRespVO> appPage(SaleStatisticsDealerQueryVO queryVO) {
        List<Predicate> where = where2(queryVO);
        JPAQuery<SaleStatisticsDealerRespVO> query = pageSelect(SaleStatisticsDealerRespVO.class).where(ExpressionUtils.allOf(where));
        query.groupBy(qSaleStatisticsDealerDO.region, qSaleStatisticsDealerDO.dealerCode,
                qSaleStatisticsDealerDO.salesmanPath, qSaleStatisticsDealerDO.docTime);

        if (!Objects.isNull(queryVO.getShipTotalQtyFrom())) {
            query.having(qSaleStatisticsDealerDO.shipQty.sum().goe(queryVO.getShipTotalQtyFrom()));
        }
        if (!Objects.isNull(queryVO.getShipTotalQtyTo())) {
            query.having(qSaleStatisticsDealerDO.shipQty.sum().loe(queryVO.getShipTotalQtyTo()));
        }
        if (!Objects.isNull(queryVO.getOrderTotalQtyFrom())) {
            query.having(qSaleStatisticsDealerDO.orderQty.sum().goe(queryVO.getOrderTotalQtyFrom()));
        }
        if (!Objects.isNull(queryVO.getOrderTotalQtyTo())) {
            query.having(qSaleStatisticsDealerDO.orderQty.sum().loe(queryVO.getOrderTotalQtyTo()));
        }
        //queryVO.fillOrders(query, qSaleStatisticsDealerDO);
//        query.orderBy(qSaleStatisticsDealerDO.docTime.yearMonth().desc());
        if (CollectionUtils.isNotEmpty(queryVO.getOrders())) {
            for (OrderItem orderItem : queryVO.getOrders()) {
                if (StringUtils.isNotBlank(orderItem.getColumn())) {
                    Order order = orderItem.isAsc() ? Order.ASC : Order.DESC;
                    OrderSpecifier orderSpecifier3 = new OrderSpecifier(order,
                            Expressions.stringTemplate(orderItem.getColumn()));
                    query.orderBy(orderSpecifier3);
                }
            }
        }
        query.orderBy(qSaleStatisticsDealerDO.docTime.desc());
        query.orderBy(qSaleStatisticsDealerDO.createTime.desc());

        queryVO.setPaging(query);
        return PagingVO.<SaleStatisticsDealerRespVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public List<SaleStatisticsDealerRespVO> dealerQuery(SaleStatisticsDealerQueryVO queryVO) {
        List<Predicate> where = where(queryVO);
        JPAQuery<SaleStatisticsDealerRespVO> query = pageSelect(SaleStatisticsDealerRespVO.class).where(ExpressionUtils.allOf(where));
        query.groupBy(qSaleStatisticsDealerDO.region, qSaleStatisticsDealerDO.dealerCode,
                qSaleStatisticsDealerDO.salesmanPath, qSaleStatisticsDealerDO.vehicleType,
                qSaleStatisticsDealerDO.docTime);

        if (!Objects.isNull(queryVO.getShipTotalQtyFrom())) {
            query.having(qSaleStatisticsDealerDO.shipQty.sum().goe(queryVO.getShipTotalQtyFrom()));
        }
        if (!Objects.isNull(queryVO.getShipTotalQtyTo())) {
            query.having(qSaleStatisticsDealerDO.shipQty.sum().loe(queryVO.getShipTotalQtyTo()));
        }
        if (!Objects.isNull(queryVO.getOrderTotalQtyFrom())) {
            query.having(qSaleStatisticsDealerDO.orderQty.sum().goe(queryVO.getOrderTotalQtyFrom()));
        }
        if (!Objects.isNull(queryVO.getOrderTotalQtyTo())) {
            query.having(qSaleStatisticsDealerDO.orderQty.sum().loe(queryVO.getOrderTotalQtyTo()));
        }

        return query.fetch();
    }

    public PagingVO<SaleStatisticsDealerRespVO> appDetailsPage(SaleStatisticsDealerQueryVO queryVO) {
        List<Predicate> where = where2(queryVO);
        JPAQuery<SaleStatisticsDealerRespVO> jpaQuery = pageSelect(SaleStatisticsDealerRespVO.class).where(ExpressionUtils.allOf(where));
        jpaQuery.groupBy(qSaleStatisticsDealerDO.itemType3, qSaleStatisticsDealerDO.vehicleType, qSaleStatisticsDealerDO.docTime);
        if (!Objects.isNull(queryVO.getShipTotalQtyFrom())) {
            jpaQuery.having(qSaleStatisticsDealerDO.shipQty.sum().goe(queryVO.getShipTotalQtyFrom()));
        }
        if (!Objects.isNull(queryVO.getShipTotalQtyTo())) {
            jpaQuery.having(qSaleStatisticsDealerDO.shipQty.sum().loe(queryVO.getShipTotalQtyTo()));
        }
        if (!Objects.isNull(queryVO.getOrderTotalQtyFrom())) {
            jpaQuery.having(qSaleStatisticsDealerDO.orderQty.sum().goe(queryVO.getOrderTotalQtyFrom()));
        }
        if (!Objects.isNull(queryVO.getOrderTotalQtyTo())) {
            jpaQuery.having(qSaleStatisticsDealerDO.orderQty.sum().loe(queryVO.getOrderTotalQtyTo()));
        }
        queryVO.setPaging(jpaQuery);
        queryVO.fillOrders(jpaQuery, qSaleStatisticsDealerDO);
        return PagingVO.<SaleStatisticsDealerRespVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    private <T> JPAQuery<T> pageSelect(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qSaleStatisticsDealerDO.id,
                qSaleStatisticsDealerDO.docTime,
                //qSaleStatisticsDealerDO.docTime.yearMonth().as(YEAR_MONTH),
                // Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m')", qSaleStatisticsDealerDO.docTime).as(DOC_TIME_YEAR_MONTH),
                qSaleStatisticsDealerDO.dealerCode,
                qSaleStatisticsDealerDO.dealerName,
                qSaleStatisticsDealerDO.dealerSerialNo,
                qSaleStatisticsDealerDO.region,
                //qSaleStatisticsDealerDO.type,
                qSaleStatisticsDealerDO.salesmanPath,
                qSaleStatisticsDealerDO.vehicleType,
                qSaleStatisticsDealerDO.shipQty.sum().as(SHIP_TOTAL_QTY),
                qSaleStatisticsDealerDO.orderQty.sum().as(ORDER_TOTAL_QTY),
                qSaleStatisticsDealerDO.custType,
                qSaleStatisticsDealerDO.itemType3,
                qSaleStatisticsDealerDO.remark,
                qSaleStatisticsDealerDO.createTime,
                qSaleStatisticsDealerDO.updateRegionFailureReason,
                qSaleStatisticsDealerDO.updateSalesmanFailureReason
        )).from(qSaleStatisticsDealerDO);
    }

    public List<StatisticsDealerAppSumRespVO> appSumByEmpCode(SaleStatisticsDealerQueryVO queryVO) {
        List<Predicate> where = where(queryVO);
        List<Predicate> dtlWhere = dtlWhere(queryVO);
        JPAQuery<StatisticsDealerAppSumRespVO> jpaQuery = jpaQueryFactory.select(
                Projections.bean(StatisticsDealerAppSumRespVO.class,
                        qSaleStatisticsDealerDtlDO.code.as(AGENT_EMP_CODE),
                        qSaleStatisticsDealerDO.shipQty.sum().as(SHIP_TOTAL_QTY),
                        qSaleStatisticsDealerDO.orderQty.sum().as(ORDER_TOTAL_QTY),
                        qSaleStatisticsDealerDO.dealerCode.countDistinct().as(DEALER_TOTAL_QTY)))
                .from(qSaleStatisticsDealerDO).leftJoin(qSaleStatisticsDealerDtlDO)
                .on(qSaleStatisticsDealerDO.id.eq(qSaleStatisticsDealerDtlDO.masId))
                .where(ExpressionUtils.allOf(where))
                .where(ExpressionUtils.allOf(dtlWhere));
        //JPAQuery<StatisticsDealerAppSumRespVO> jpaQuery = selectAppSumByEmpCode(StatisticsDealerAppSumRespVO.class).where(ExpressionUtils.allOf(where));
        jpaQuery.groupBy(qSaleStatisticsDealerDtlDO.code);
        return jpaQuery.fetch();
    }

    private List<Predicate> dtlWhere(SaleStatisticsDealerQueryVO queryVO) {
        List<Predicate> predicates = new ArrayList<>();

        if (!CollectionUtils.isEmpty(queryVO.getAgentEmpList())) {
            predicates.add(qSaleStatisticsDealerDtlDO.code.in(queryVO.getAgentEmpList()));
        }
        if (!StringUtils.isEmpty(queryVO.getLevel())) {
            predicates.add(qSaleStatisticsDealerDtlDO.level.eq(queryVO.getLevel()));
        }

        return predicates;
    }


    private List<Predicate> where(SaleStatisticsDealerQueryVO queryVO) {
        List<Predicate> predicates = new ArrayList<>();
        //predicates.add(qSaleStatisticsDealerDO.deleteFlag.eq(0).or(qSaleStatisticsDealerDO.deleteFlag.isNull()));

        if (Objects.equals(queryVO.getRegionFlag(), ConstantsSale.STATISTICS_DEALER_QUERY_FLAG)) {
            predicates.add(qSaleStatisticsDealerDO.region.isNull());
        }
        if (Objects.equals(queryVO.getSalesmanPathFlag(), ConstantsSale.STATISTICS_DEALER_QUERY_FLAG)) {
            predicates.add(qSaleStatisticsDealerDO.salesmanPath.isNull());
        }
        if (!Objects.isNull(queryVO.getId())) {
            predicates.add(qSaleStatisticsDealerDO.id.eq(queryVO.getId()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getIds())) {
            predicates.add(qSaleStatisticsDealerDO.id.in(queryVO.getIds()));
        }
        if (!StringUtils.isEmpty(queryVO.getDealerCode())) {
            predicates.add(qSaleStatisticsDealerDO.dealerCode.eq(queryVO.getDealerCode()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getDealerCodeList())) {
            predicates.add(qSaleStatisticsDealerDO.dealerCode.in(queryVO.getDealerCodeList()));
        }
        if (!StringUtils.isEmpty(queryVO.getDealerCodeKeyword())) {
            predicates.add(qSaleStatisticsDealerDO.dealerCode.like("%" + queryVO.getDealerCodeKeyword() + "%"));
        }
        if (!StringUtils.isEmpty(queryVO.getDealerName())) {
            predicates.add(qSaleStatisticsDealerDO.dealerName.like("%" + queryVO.getDealerName() + "%"));
        }
        if (!StringUtils.isEmpty(queryVO.getDealerKeyword())) {
            predicates.add(qSaleStatisticsDealerDO.dealerCode.like("%" + queryVO.getDealerKeyword() + "%").or(qSaleStatisticsDealerDO.dealerName.like("%" + queryVO.getDealerKeyword() + "%")));
        }
        if (!StringUtils.isEmpty(queryVO.getKeyword())) {
            predicates.add(qSaleStatisticsDealerDO.dealerCode.like("%" + queryVO.getKeyword() + "%").or(qSaleStatisticsDealerDO.dealerName.like("%" + queryVO.getKeyword() + "%")));
        }
        if (!StringUtils.isEmpty(queryVO.getDealerSerialNo())) {
            predicates.add(qSaleStatisticsDealerDO.dealerSerialNo.like("%" + queryVO.getDealerSerialNo() + "%"));
        }
        if (!StringUtils.isEmpty(queryVO.getDealerSerialNo1())) {
            predicates.add(qSaleStatisticsDealerDO.dealerSerialNo.eq(queryVO.getDealerSerialNo1()));
        }
        if (!StringUtils.isEmpty(queryVO.getRegion())) {
            predicates.add(qSaleStatisticsDealerDO.region.eq(queryVO.getRegion()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getRegionList())) {
            predicates.add(qSaleStatisticsDealerDO.region.in(queryVO.getRegionList()));
        }
        if (Objects.equals(queryVO.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_YES.getValueCode())){
            predicates.add(qSaleStatisticsDealerDO.region.isNull());
        }
        if (Objects.equals(queryVO.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_NO.getValueCode())){
            predicates.add(qSaleStatisticsDealerDO.region.isNotNull());
        }

        if (!StringUtils.isEmpty(queryVO.getType())) {
            predicates.add(qSaleStatisticsDealerDO.type.eq(queryVO.getType()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getTypeList())) {
            predicates.add(qSaleStatisticsDealerDO.type.in(queryVO.getTypeList()));
        }
        if (!StringUtils.isEmpty(queryVO.getSalesmanPath())) {
            predicates.add(qSaleStatisticsDealerDO.salesmanPath.eq(queryVO.getSalesmanPath()));
        }
        if (Objects.equals(queryVO.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_YES.getValueCode())){
            predicates.add(qSaleStatisticsDealerDO.salesmanPath.isNull());
        }
        if (Objects.equals(queryVO.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_NO.getValueCode())){
            predicates.add(qSaleStatisticsDealerDO.salesmanPath.isNotNull());
        }
        if (!StringUtils.isEmpty(queryVO.getVehicleType())) {
            predicates.add(qSaleStatisticsDealerDO.vehicleType.eq(queryVO.getVehicleType()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getVehicleTypeList())) {
            predicates.add(qSaleStatisticsDealerDO.vehicleType.in(queryVO.getVehicleTypeList()));
        }

        if (queryVO.getDocTimeStart() != null && queryVO.getDocTimeEnd() != null) {
            predicates.add(qSaleStatisticsDealerDO.docTime.between(queryVO.getDocTimeStart(), queryVO.getDocTimeEnd()));
        } else {
            if (queryVO.getDocTimeStart() != null) {
                predicates.add(qSaleStatisticsDealerDO.docTime.goe(queryVO.getDocTimeStart()));
            }
            if (queryVO.getDocTimeEnd() != null) {
                predicates.add(qSaleStatisticsDealerDO.docTime.loe(queryVO.getDocTimeEnd()));
            }
        }

        if (Objects.nonNull(queryVO.getDocTimeItStart())) {
            predicates.add(qSaleStatisticsDealerDO.docTime.yearMonth().goe(queryVO.getDocTimeItStart()));
        }
        if (Objects.nonNull(queryVO.getDocTimeItEnd())) {
            predicates.add(qSaleStatisticsDealerDO.docTime.yearMonth().loe(queryVO.getDocTimeItEnd()));
        }
        if (Objects.nonNull(queryVO.getDocMonth())) {
            BooleanExpression booleanTemplate = Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m')", qSaleStatisticsDealerDO.docTime)
                    .eq(queryVO.getDocMonth());
            predicates.add(booleanTemplate);
        }

        if (Objects.nonNull(queryVO.getDocTime())) {
            BooleanExpression booleanTemplate = Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m-%d')", qSaleStatisticsDealerDO.docTime)
                    .eq(queryVO.getDocTime().toLocalDate().toString());
            predicates.add(booleanTemplate);
        }
        /*if (queryVO.getDocTimeStart() != null && queryVO.getDocTimeEnd() != null) {
            predicate = StringUtils.isEmpty(param.getValidFrom()) ? predicate :
                    ExpressionUtils.and(predicate, Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m-%d')", jpaQDo.validFrom)
                            .eq(param.getValidFrom().toLocalDate().toString()));
            predicate = predicate = StringUtils.isEmpty(param.getValidTo()) ? predicate :
                    ExpressionUtils.and(predicate, Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m-%d')", jpaQDo.validTo)
                            .eq(param.getValidTo().toLocalDate().toString()));


        }*/
       /* if (Objects.nonNull(queryVO.getDocTimeStart())){
            BooleanExpression booleanTemplate  = Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m-%d')", qSaleStatisticsDealerDO.docTime)
                            .eq(queryVO.getDocTimeStart().toLocalDate().toString());
            predicates.add(booleanTemplate);
        }
        if (Objects.nonNull(queryVO.getDocTimeEnd())){

        }*/

        if (!Objects.isNull(queryVO.getShipQty())) {
            predicates.add(qSaleStatisticsDealerDO.shipQty.eq(queryVO.getShipQty()));
        }
        if (!Objects.isNull(queryVO.getOrderQty())) {
            predicates.add(qSaleStatisticsDealerDO.orderQty.eq(queryVO.getOrderQty()));
        }

        if (!StringUtils.isEmpty(queryVO.getCustType())) {
            predicates.add(qSaleStatisticsDealerDO.custType.eq(queryVO.getCustType()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getCustTypes())) {
            predicates.add(qSaleStatisticsDealerDO.custType.in(queryVO.getCustTypes()));
        }
        if (!StringUtils.isEmpty(queryVO.getItemType3())) {
            predicates.add(qSaleStatisticsDealerDO.itemType3.eq(queryVO.getItemType3()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getItemType3List())) {
            predicates.add(qSaleStatisticsDealerDO.itemType3.in(queryVO.getItemType3List()));
        }

        return predicates;
    }

    private List<Predicate> where2(SaleStatisticsDealerQueryVO queryVO) {
        List<Predicate> predicates = new ArrayList<>();
        //predicates.add(qSaleStatisticsDealerDO.deleteFlag.eq(0).or(qSaleStatisticsDealerDO.deleteFlag.isNull()));

        if (Objects.equals(queryVO.getRegionFlag(), ConstantsSale.STATISTICS_DEALER_QUERY_FLAG)) {
            predicates.add(qSaleStatisticsDealerDO.region.isNull());
        }
        if (Objects.equals(queryVO.getSalesmanPathFlag(), ConstantsSale.STATISTICS_DEALER_QUERY_FLAG)) {
            predicates.add(qSaleStatisticsDealerDO.salesmanPath.isNull());
        }
        if (!Objects.isNull(queryVO.getId())) {
            predicates.add(qSaleStatisticsDealerDO.id.eq(queryVO.getId()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getIds())) {
            predicates.add(qSaleStatisticsDealerDO.id.in(queryVO.getIds()));
        }
        if (!StringUtils.isEmpty(queryVO.getDealerCode())) {
            predicates.add(qSaleStatisticsDealerDO.dealerCode.eq(queryVO.getDealerCode()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getDealerCodeList())) {
            predicates.add(qSaleStatisticsDealerDO.dealerCode.in(queryVO.getDealerCodeList()));
        }
        if (!StringUtils.isEmpty(queryVO.getDealerCodeKeyword())) {
            predicates.add(qSaleStatisticsDealerDO.dealerCode.like("%" + queryVO.getDealerCodeKeyword() + "%"));
        }
        if (!StringUtils.isEmpty(queryVO.getDealerName())) {
            predicates.add(qSaleStatisticsDealerDO.dealerName.like("%" + queryVO.getDealerName() + "%"));
        }
        if (!StringUtils.isEmpty(queryVO.getDealerKeyword())) {
            predicates.add(qSaleStatisticsDealerDO.dealerCode.like("%" + queryVO.getDealerKeyword() + "%").or(qSaleStatisticsDealerDO.dealerName.like("%" + queryVO.getDealerKeyword() + "%")));
        }
        if (!StringUtils.isEmpty(queryVO.getKeyword())) {
            predicates.add(qSaleStatisticsDealerDO.dealerCode.like("%" + queryVO.getKeyword() + "%").or(qSaleStatisticsDealerDO.dealerName.like("%" + queryVO.getKeyword() + "%")));
        }
        if (!StringUtils.isEmpty(queryVO.getDealerSerialNo())) {
            predicates.add(qSaleStatisticsDealerDO.dealerSerialNo.like("%" + queryVO.getDealerSerialNo() + "%"));
        }
        if (!StringUtils.isEmpty(queryVO.getDealerSerialNo1())) {
            predicates.add(qSaleStatisticsDealerDO.dealerSerialNo.eq(queryVO.getDealerSerialNo1()));
        }
        if (!StringUtils.isEmpty(queryVO.getRegion())) {
            predicates.add(qSaleStatisticsDealerDO.region.eq(queryVO.getRegion()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getRegionList())) {
            predicates.add(qSaleStatisticsDealerDO.region.in(queryVO.getRegionList()));
        }
        if (Objects.equals(queryVO.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_YES.getValueCode())){
            predicates.add(qSaleStatisticsDealerDO.region.isNull());
        }
        if (Objects.equals(queryVO.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_NO.getValueCode())){
            predicates.add(qSaleStatisticsDealerDO.region.isNotNull());
        }

        if (!StringUtils.isEmpty(queryVO.getType())) {
            predicates.add(qSaleStatisticsDealerDO.type.eq(queryVO.getType()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getTypeList())) {
            predicates.add(qSaleStatisticsDealerDO.type.in(queryVO.getTypeList()));
        }
        if (!StringUtils.isEmpty(queryVO.getSalesmanPath())) {
            predicates.add(qSaleStatisticsDealerDO.salesmanPath.eq(queryVO.getSalesmanPath()));
        }
        if (Objects.equals(queryVO.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_YES.getValueCode())){
            predicates.add(qSaleStatisticsDealerDO.salesmanPath.isNull());
        }
        if (Objects.equals(queryVO.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_NO.getValueCode())){
            predicates.add(qSaleStatisticsDealerDO.salesmanPath.isNotNull());
        }
        if (!StringUtils.isEmpty(queryVO.getVehicleType())) {
            predicates.add(qSaleStatisticsDealerDO.vehicleType.eq(queryVO.getVehicleType()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getVehicleTypeList())) {
            predicates.add(qSaleStatisticsDealerDO.vehicleType.in(queryVO.getVehicleTypeList()));
        }

        if (queryVO.getDocTimeStart() != null && queryVO.getDocTimeEnd() != null) {
            predicates.add(qSaleStatisticsDealerDO.docTime.between(queryVO.getDocTimeStart(), queryVO.getDocTimeEnd()));
        } else {
            if (queryVO.getDocTimeStart() != null) {
                predicates.add(qSaleStatisticsDealerDO.docTime.goe(queryVO.getDocTimeStart()));
            }
            if (queryVO.getDocTimeEnd() != null) {
                predicates.add(qSaleStatisticsDealerDO.docTime.loe(queryVO.getDocTimeEnd()));
            }
        }

        if (Objects.nonNull(queryVO.getDocTimeItStart())) {
            predicates.add(qSaleStatisticsDealerDO.docTime.yearMonth().goe(queryVO.getDocTimeItStart()));
        }
        if (Objects.nonNull(queryVO.getDocTimeItEnd())) {
            predicates.add(qSaleStatisticsDealerDO.docTime.yearMonth().loe(queryVO.getDocTimeItEnd()));
        }
        if (Objects.nonNull(queryVO.getDocMonth())) {
            BooleanExpression booleanTemplate = Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m')", qSaleStatisticsDealerDO.docTime)
                    .eq(queryVO.getDocMonth());
            predicates.add(booleanTemplate);
        }

        if (Objects.nonNull(queryVO.getDocTime())) {
            BooleanExpression booleanTemplate = Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m-%d')", qSaleStatisticsDealerDO.docTime)
                    .eq(queryVO.getDocTime().toLocalDate().toString());
            predicates.add(booleanTemplate);
        }
        /*if (queryVO.getDocTimeStart() != null && queryVO.getDocTimeEnd() != null) {
            predicate = StringUtils.isEmpty(param.getValidFrom()) ? predicate :
                    ExpressionUtils.and(predicate, Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m-%d')", jpaQDo.validFrom)
                            .eq(param.getValidFrom().toLocalDate().toString()));
            predicate = predicate = StringUtils.isEmpty(param.getValidTo()) ? predicate :
                    ExpressionUtils.and(predicate, Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m-%d')", jpaQDo.validTo)
                            .eq(param.getValidTo().toLocalDate().toString()));


        }*/
       /* if (Objects.nonNull(queryVO.getDocTimeStart())){
            BooleanExpression booleanTemplate  = Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m-%d')", qSaleStatisticsDealerDO.docTime)
                            .eq(queryVO.getDocTimeStart().toLocalDate().toString());
            predicates.add(booleanTemplate);
        }
        if (Objects.nonNull(queryVO.getDocTimeEnd())){

        }*/

        if (!Objects.isNull(queryVO.getShipQty())) {
            predicates.add(qSaleStatisticsDealerDO.shipQty.eq(queryVO.getShipQty()));
        }
        if (!Objects.isNull(queryVO.getOrderQty())) {
            predicates.add(qSaleStatisticsDealerDO.orderQty.eq(queryVO.getOrderQty()));
        }

        if (!StringUtils.isEmpty(queryVO.getCustType())) {
            predicates.add(qSaleStatisticsDealerDO.custType.eq(queryVO.getCustType()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getCustTypes())) {
            predicates.add(qSaleStatisticsDealerDO.custType.in(queryVO.getCustTypes()));
        }
        if (!StringUtils.isEmpty(queryVO.getItemType3())) {
            predicates.add(qSaleStatisticsDealerDO.itemType3.eq(queryVO.getItemType3()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getItemType3List())) {
            predicates.add(qSaleStatisticsDealerDO.itemType3.in(queryVO.getItemType3List()));
        }

        if (StringUtils.isNotBlank(queryVO.getAgentEmp())) {
            predicates.add(qSaleStatisticsDealerDO.id.in(JPAExpressions
                    .select(qSaleStatisticsDealerDtlDO.masId)
                    .from(qSaleStatisticsDealerDtlDO)
                    .where(qSaleStatisticsDealerDtlDO.code.eq(queryVO.getAgentEmp()))));
        }

        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qSaleStatisticsDealerDO.id,
                qSaleStatisticsDealerDO.docTime,
                qSaleStatisticsDealerDO.dealerCode,
                qSaleStatisticsDealerDO.dealerName,
                qSaleStatisticsDealerDO.dealerSerialNo,
                qSaleStatisticsDealerDO.region,
                qSaleStatisticsDealerDO.type,
                qSaleStatisticsDealerDO.salesmanPath,
                qSaleStatisticsDealerDO.vehicleType,
                qSaleStatisticsDealerDO.shipQty,
                qSaleStatisticsDealerDO.orderQty,
                qSaleStatisticsDealerDO.custType,
                qSaleStatisticsDealerDO.itemType3,
                qSaleStatisticsDealerDO.updateRegionFailureReason,
                qSaleStatisticsDealerDO.updateSalesmanFailureReason,
                qSaleStatisticsDealerDO.remark,
                qSaleStatisticsDealerDO.createTime,
                qSaleStatisticsDealerDO.createUserId,
                qSaleStatisticsDealerDO.creator,
                qSaleStatisticsDealerDO.modifyTime,
                qSaleStatisticsDealerDO.modifyUserId,
                qSaleStatisticsDealerDO.updater,
                qSaleStatisticsDealerDO.tenantId,
                qSaleStatisticsDealerDO.deleteFlag,
                qSaleStatisticsDealerDO.belongOrgId,
                qSaleStatisticsDealerDO.tenantOrgId,
                qSaleStatisticsDealerDO.auditDataVersion,
                qSaleStatisticsDealerDO.secBuId,
                qSaleStatisticsDealerDO.secUserId,
                qSaleStatisticsDealerDO.secOuId
        )).from(qSaleStatisticsDealerDO);
    }

    public void updateDeleteFlagBatch(Integer deleteFlag, List<Long> ids) {
        jpaQueryFactory.update(qSaleStatisticsDealerDO)
                .set(qSaleStatisticsDealerDO.deleteFlag, deleteFlag)
                .where(qSaleStatisticsDealerDO.id.in(ids))
                .execute();
    }

    @Transactional(rollbackOn = {Exception.class})
    public void updateDeleteFlagByDocTime(Integer deleteFlag, LocalDate docTime) {
       /* jpaQueryFactory.update(qSaleStatisticsDealerDO)
                .set(qSaleStatisticsDealerDO.deleteFlag, deleteFlag)
                .where(Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m-%d')", qSaleStatisticsDealerDO.docTime)
                        .eq(docTime.toString()))
                .execute();*/

        JPAUpdateClause update = jpaQueryFactory.update(qSaleStatisticsDealerDO);
        update.set(qSaleStatisticsDealerDO.deleteFlag, deleteFlag);
        update.where(qSaleStatisticsDealerDO.docTime.goe(LocalDateTime.of(docTime, LocalTime.MIN)))
                .where(qSaleStatisticsDealerDO.docTime.loe(LocalDateTime.of(docTime, ConstantsSale.LOCAL_TIME_MAX)))
                .execute();

    }

    public Predicate selectRegionOrSalesmanPathWhere(SaleStatisticsDealerQueryVO queryVO) {
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);

        if (!StringUtils.isEmpty(queryVO.getDealerCode())) {
            predicate = ExpressionUtils.and(predicate, qSaleStatisticsDealerDO.dealerCode.eq(queryVO.getDealerCode()));
        }
        if (!StringUtils.isEmpty(queryVO.getRegion())) {
            predicate = ExpressionUtils.and(predicate, qSaleStatisticsDealerDO.region.eq(queryVO.getRegion()));
        }
        if (!StringUtils.isEmpty(queryVO.getSalesmanPath())) {
            predicate = ExpressionUtils.and(predicate, qSaleStatisticsDealerDO.salesmanPath.eq(queryVO.getSalesmanPath()));
        }
        if (!StringUtils.isEmpty(queryVO.getVehicleType())) {
            predicate = ExpressionUtils.and(predicate, qSaleStatisticsDealerDO.vehicleType.eq(queryVO.getVehicleType()));
        }
        if (Objects.nonNull(queryVO.getDocTime())) {
            predicate = ExpressionUtils.and(predicate, qSaleStatisticsDealerDO.docTime.eq(queryVO.getDocTime()));
        }
        if (Objects.nonNull(queryVO.getDocMonth())) {
            BooleanExpression booleanTemplate = Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m')", qSaleStatisticsDealerDO.docTime)
                    .eq(queryVO.getDocMonth());
            predicate = ExpressionUtils.and(predicate, booleanTemplate);
        }

        return predicate;
    }

}

