package com.elitesland.yst.production.sale.repo.shop;

import com.elitesland.yst.production.sale.api.vo.param.shop.MktDiscountOffsetQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktDiscountOffsetRespDVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktDiscountOffsetRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktDiscountOffsetVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.entity.BipItemDO;
import com.elitesland.yst.production.sale.entity.QBipItemDO;
import com.elitesland.yst.production.sale.entity.QMktDiscountOffsetDDO;
import com.elitesland.yst.production.sale.entity.QMktDiscountOffsetDO;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/10/16:53
 * @Description:
 */
@Repository
public class MktDiscountOffsetRepoProc {
    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    private final QMktDiscountOffsetDO qMktDiscountOffsetDO = QMktDiscountOffsetDO.mktDiscountOffsetDO;

    private final QMktDiscountOffsetDDO qMktDiscountOffsetDDO = QMktDiscountOffsetDDO.mktDiscountOffsetDDO;

    /**
     * 根据 入参，查询符合条件的商品促销信息
     *
     * @param ouId
     * @param customLevel 可为空，为空则查询全部客户级别
     * @param date        促销日期
     * @param itemIds
     * @return
     */
    public JPAQuery<MktDiscountOffsetVO> findMktDisCountOffset(Long ouId, String customLevel, LocalDateTime date, List<Long> itemIds) {

        JPAQuery<MktDiscountOffsetVO> jpaQuery = jpaQueryFactory.select(Projections.bean(MktDiscountOffsetVO.class,
                qMktDiscountOffsetDO.id.as("mktDiscountOffsetId"),
                qMktDiscountOffsetDO.code,
                qMktDiscountOffsetDO.name,
                qMktDiscountOffsetDO.validStime,
                qMktDiscountOffsetDO.validEtime,
                qMktDiscountOffsetDO.customLevel,
                qMktDiscountOffsetDO.ouId,
                qMktDiscountOffsetDO.ouCode,
                qMktDiscountOffsetDO.ouName,
                qMktDiscountOffsetDO.buId,
                qMktDiscountOffsetDO.buCode,
                qMktDiscountOffsetDO.buName,
                qMktDiscountOffsetDO.currCode,
                qMktDiscountOffsetDO.type,
                qMktDiscountOffsetDO.status,

                qMktDiscountOffsetDDO.id.as("mktDiscountOffsetDId"),
                qMktDiscountOffsetDDO.itemId,
                qMktDiscountOffsetDDO.itemCode,
                qMktDiscountOffsetDDO.itemName,
                qMktDiscountOffsetDDO.itemAttr,
                qMktDiscountOffsetDDO.uom,
                qMktDiscountOffsetDDO.limitAmt,
                qMktDiscountOffsetDDO.limitNum,
                qMktDiscountOffsetDDO.basePrice,
                qMktDiscountOffsetDDO.custPrice,
                qMktDiscountOffsetDDO.freeAmt,
                qMktDiscountOffsetDDO.discountPrice
        ))
                .from(qMktDiscountOffsetDO)
                .join(qMktDiscountOffsetDDO).on(qMktDiscountOffsetDO.id.eq(qMktDiscountOffsetDDO.mktDiscountOffsetId))

                .where(qMktDiscountOffsetDO.deleteFlag.eq(ConstantsSale.COMMON_DELETE_NO))
                .where(qMktDiscountOffsetDDO.deleteFlag.eq(ConstantsSale.COMMON_DELETE_NO))
                .where(qMktDiscountOffsetDO.status.eq(UdcEnum.MKT_DISCOUNT_OFFSET_STATUS_ENABLE.getValueCode()))
                .where(qMktDiscountOffsetDO.ouId.eq(ouId))
                .where(qMktDiscountOffsetDDO.itemId.in(itemIds))
                .where(qMktDiscountOffsetDO.validStime.before(date).or(qMktDiscountOffsetDO.validStime.eq(date)))
                .where(qMktDiscountOffsetDO.validEtime.after(date).or(qMktDiscountOffsetDO.validEtime.eq(date)));
        if (!StringUtils.isEmpty(customLevel)) {
            jpaQuery.where(qMktDiscountOffsetDO.customLevel.eq(customLevel).or(qMktDiscountOffsetDO.customLevel.isNull()));
        }
        return jpaQuery;
    }


    public JPAQuery<MktDiscountOffsetVO> findMktDisCountOffsetCode(Long ouId, String customLevel, LocalDateTime date, List<String> skuCodes) {

        JPAQuery<MktDiscountOffsetVO> jpaQuery = jpaQueryFactory.select(Projections.bean(MktDiscountOffsetVO.class,
                qMktDiscountOffsetDO.id.as("mktDiscountOffsetId"),
                qMktDiscountOffsetDO.code,
                qMktDiscountOffsetDO.name,
                qMktDiscountOffsetDO.validStime,
                qMktDiscountOffsetDO.validEtime,
                qMktDiscountOffsetDO.customLevel,
                qMktDiscountOffsetDO.ouId,
                qMktDiscountOffsetDO.ouCode,
                qMktDiscountOffsetDO.ouName,
                qMktDiscountOffsetDO.buId,
                qMktDiscountOffsetDO.buCode,
                qMktDiscountOffsetDO.buName,
                qMktDiscountOffsetDO.currCode,
                qMktDiscountOffsetDO.type,
                qMktDiscountOffsetDO.status,

                qMktDiscountOffsetDDO.id.as("mktDiscountOffsetDId"),
                qMktDiscountOffsetDDO.itemId,
                qMktDiscountOffsetDDO.itemCode,
                qMktDiscountOffsetDDO.itemName,
                qMktDiscountOffsetDDO.itemAttr,
                qMktDiscountOffsetDDO.uom,
                qMktDiscountOffsetDDO.limitAmt,
                qMktDiscountOffsetDDO.limitNum,
                qMktDiscountOffsetDDO.basePrice,
                qMktDiscountOffsetDDO.custPrice,
                qMktDiscountOffsetDDO.freeAmt,
                qMktDiscountOffsetDDO.discountPrice
        ))
                .from(qMktDiscountOffsetDO)
                .join(qMktDiscountOffsetDDO).on(qMktDiscountOffsetDO.id.eq(qMktDiscountOffsetDDO.mktDiscountOffsetId))

                .where(qMktDiscountOffsetDO.deleteFlag.eq(ConstantsSale.COMMON_DELETE_NO))
                .where(qMktDiscountOffsetDDO.deleteFlag.eq(ConstantsSale.COMMON_DELETE_NO))
                .where(qMktDiscountOffsetDO.status.eq(UdcEnum.MKT_DISCOUNT_OFFSET_STATUS_ENABLE.getValueCode()))
                .where(qMktDiscountOffsetDO.ouId.eq(ouId))
                .where(qMktDiscountOffsetDDO.itemCode.in(skuCodes))
                .where(qMktDiscountOffsetDO.validStime.before(date).or(qMktDiscountOffsetDO.validStime.eq(date)))
                .where(qMktDiscountOffsetDO.validEtime.after(date).or(qMktDiscountOffsetDO.validEtime.eq(date)));
        if (!StringUtils.isEmpty(customLevel)) {
            jpaQuery.where(qMktDiscountOffsetDO.customLevel.eq(customLevel).or(qMktDiscountOffsetDO.customLevel.isNull()));
        }
        return jpaQuery;
    }




    public JPAQuery<MktDiscountOffsetVO> findMktDisCountOffsetByLQ(Long ouId, String customLevel, LocalDateTime date, List<Long> itemIds) {

        JPAQuery<MktDiscountOffsetVO> jpaQuery = jpaQueryFactory.select(Projections.bean(MktDiscountOffsetVO.class,
                qMktDiscountOffsetDO.id.as("mktDiscountOffsetId"),
                qMktDiscountOffsetDO.code,
                qMktDiscountOffsetDO.name,
                qMktDiscountOffsetDO.validStime,
                qMktDiscountOffsetDO.validEtime,
                qMktDiscountOffsetDO.customLevel,
                qMktDiscountOffsetDO.ouId,
                qMktDiscountOffsetDO.ouCode,
                qMktDiscountOffsetDO.ouName,
                qMktDiscountOffsetDO.buId,
                qMktDiscountOffsetDO.buCode,
                qMktDiscountOffsetDO.buName,
                qMktDiscountOffsetDO.currCode,
                qMktDiscountOffsetDO.type,
                qMktDiscountOffsetDO.status,

                qMktDiscountOffsetDDO.id.as("mktDiscountOffsetDId"),
                qMktDiscountOffsetDDO.itemId,
                qMktDiscountOffsetDDO.itemCode,
                qMktDiscountOffsetDDO.itemName,
                qMktDiscountOffsetDDO.itemAttr,
                qMktDiscountOffsetDDO.uom,
                qMktDiscountOffsetDDO.limitAmt,
                qMktDiscountOffsetDDO.limitNum,
                qMktDiscountOffsetDDO.basePrice,
                qMktDiscountOffsetDDO.custPrice,
                qMktDiscountOffsetDDO.freeAmt,
                qMktDiscountOffsetDDO.discountPrice
        ))
                .from(qMktDiscountOffsetDO)
                .join(qMktDiscountOffsetDDO).on(qMktDiscountOffsetDO.id.eq(qMktDiscountOffsetDDO.mktDiscountOffsetId))

                .where(qMktDiscountOffsetDO.deleteFlag.eq(ConstantsSale.COMMON_DELETE_NO))
                .where(qMktDiscountOffsetDDO.deleteFlag.eq(ConstantsSale.COMMON_DELETE_NO))
                .where(qMktDiscountOffsetDO.status.eq(UdcEnum.MKT_DISCOUNT_OFFSET_STATUS_ENABLE.getValueCode()))
                .where(qMktDiscountOffsetDO.ouId.eq(ouId))
                .where(qMktDiscountOffsetDDO.itemId.in(itemIds))
                .where(qMktDiscountOffsetDO.validStime.before(date).or(qMktDiscountOffsetDO.validStime.eq(date)))
                .where(qMktDiscountOffsetDO.validEtime.after(date).or(qMktDiscountOffsetDO.validEtime.eq(date)));
        if (!StringUtils.isEmpty(customLevel)) {
            jpaQuery.where(qMktDiscountOffsetDO.customLevel.eq(customLevel));
        }else {
            jpaQuery.where(qMktDiscountOffsetDO.customLevel.eq("").or(qMktDiscountOffsetDO.customLevel.isNull()));
        }
        return jpaQuery;
    }

    /**
     * 查询主表
     *
     * @param queryParam 查询条件,可为空
     * @return jpaQuery
     */
    public JPAQuery<MktDiscountOffsetRespVO> select(MktDiscountOffsetQueryVO queryParam) {
        JPAQuery<MktDiscountOffsetRespVO> jpaQuery = jpaQueryFactory.select(Projections.bean(MktDiscountOffsetRespVO.class,
                qMktDiscountOffsetDO.id, qMktDiscountOffsetDO.code, qMktDiscountOffsetDO.name, qMktDiscountOffsetDO.validStime,
                qMktDiscountOffsetDO.validEtime, qMktDiscountOffsetDO.ouId, qMktDiscountOffsetDO.ouCode, qMktDiscountOffsetDO.ouName,
                qMktDiscountOffsetDO.buId, qMktDiscountOffsetDO.buCode, qMktDiscountOffsetDO.buName, qMktDiscountOffsetDO.customLevel,
                qMktDiscountOffsetDO.type, qMktDiscountOffsetDO.status, qMktDiscountOffsetDO.currCode
        ))
                .from(qMktDiscountOffsetDO)
                .where(qMktDiscountOffsetDO.deleteFlag.eq(ConstantsSale.COMMON_DELETE_NO))
                // .where(DataAuthJpaUtil.dataAuthJpaPredicate(qMktDiscountOffsetDO.getMetadata())) //数据权限
                ;
        if (queryParam != null) {
            jpaQuery.where(buildCondition(queryParam));
        }
        return jpaQuery;
    }

    /**
     * 查询条件
     *
     * @param queryParam 查询条件
     * @return predicate
     */
    private Predicate buildCondition(MktDiscountOffsetQueryVO queryParam) {
        Predicate predicate = qMktDiscountOffsetDO.isNotNull();
        if (!StringUtils.isEmpty(queryParam.getItemCode())){
            predicate = ExpressionUtils.and(predicate, qMktDiscountOffsetDO.id.in(queryParam.getIds()));
        }
        if (!StringUtils.isEmpty(queryParam.getCode())) {
            predicate = ExpressionUtils.and(predicate, qMktDiscountOffsetDO.code.like("%" + queryParam.getCode() + "%"));
        }
        if (!StringUtils.isEmpty(queryParam.getName())) {
            predicate = ExpressionUtils.and(predicate, qMktDiscountOffsetDO.name.like("%" + queryParam.getName() + "%"));
        }
        if (!StringUtils.isEmpty(queryParam.getValidStime())) {
            predicate = ExpressionUtils.and(predicate, qMktDiscountOffsetDO.validStime.eq(queryParam.getValidStime())
                    .or(qMktDiscountOffsetDO.validStime.after(queryParam.getValidStime())));
        }
        if (!StringUtils.isEmpty(queryParam.getValidEtime())) {
            predicate = ExpressionUtils.and(predicate, qMktDiscountOffsetDO.validEtime.eq(queryParam.getValidEtime())
                    .or(qMktDiscountOffsetDO.validEtime.before(queryParam.getValidEtime())));
        }
        if (!StringUtils.isEmpty(queryParam.getCustomLevel())) {
            predicate = ExpressionUtils.and(predicate, qMktDiscountOffsetDO.customLevel.eq(queryParam.getCustomLevel()).or(qMktDiscountOffsetDO.customLevel.isNull()));
        }
        if (!StringUtils.isEmpty(queryParam.getOuId())) {
            predicate = ExpressionUtils.and(predicate, qMktDiscountOffsetDO.ouId.eq(queryParam.getOuId()));
        }
        if (!StringUtils.isEmpty(queryParam.getBuId())) {
            predicate = ExpressionUtils.and(predicate, qMktDiscountOffsetDO.buId.eq(queryParam.getBuId()));
        }
        if (!StringUtils.isEmpty(queryParam.getType())) {
            predicate = ExpressionUtils.and(predicate, qMktDiscountOffsetDO.type.eq(queryParam.getType()));
        }
        if (!StringUtils.isEmpty(queryParam.getStatus())) {
            predicate = ExpressionUtils.and(predicate, qMktDiscountOffsetDO.status.eq(queryParam.getStatus()));
        }
        return predicate;
    }


    /**
     * 查询明细
     *
     * @param id 主表ID，可为空
     * @return jpaQuery
     */
    public JPAQuery<MktDiscountOffsetRespDVO> selectDetailsByMasId(Long id) {
        JPAQuery<MktDiscountOffsetRespDVO> jpaQuery = jpaQueryFactory.select(Projections.bean(MktDiscountOffsetRespDVO.class,
                qMktDiscountOffsetDDO.id, qMktDiscountOffsetDDO.mktDiscountOffsetId, qMktDiscountOffsetDDO.itemId, qMktDiscountOffsetDDO.itemCode,
                qMktDiscountOffsetDDO.itemName, qMktDiscountOffsetDDO.itemAttr, qMktDiscountOffsetDDO.uom, qMktDiscountOffsetDDO.limitAmt,
                qMktDiscountOffsetDDO.limitNum, qMktDiscountOffsetDDO.basePrice, qMktDiscountOffsetDDO.custPrice, qMktDiscountOffsetDDO.freeAmt,
                qMktDiscountOffsetDDO.discountPrice
        ))
                .from(qMktDiscountOffsetDDO)
                .where(qMktDiscountOffsetDDO.deleteFlag.eq(ConstantsSale.COMMON_DELETE_NO))
                // .where(DataAuthJpaUtil.dataAuthJpaPredicate(qMktDiscountOffsetDDO.getMetadata())) //数据权限
                ;
        if (id != null) {
            jpaQuery.where(qMktDiscountOffsetDDO.mktDiscountOffsetId.eq(id));
        }
        return jpaQuery;
    }

    public List<MktDiscountOffsetVO> selectForRotation(String offsetCode) {

        return jpaQueryFactory.select(Projections.bean(MktDiscountOffsetVO.class,
                qMktDiscountOffsetDO.id.as("mktDiscountOffsetId"),
                qMktDiscountOffsetDO.code,
                qMktDiscountOffsetDO.name,
                qMktDiscountOffsetDO.validStime,
                qMktDiscountOffsetDO.validEtime,
                qMktDiscountOffsetDO.customLevel,
                qMktDiscountOffsetDO.ouId,
                qMktDiscountOffsetDO.ouCode,
                qMktDiscountOffsetDO.ouName,
                qMktDiscountOffsetDO.buId,
                qMktDiscountOffsetDO.buCode,
                qMktDiscountOffsetDO.buName,
                qMktDiscountOffsetDO.currCode,
                qMktDiscountOffsetDO.type,
                qMktDiscountOffsetDO.status,

                qMktDiscountOffsetDDO.id.as("mktDiscountOffsetDId"),
                qMktDiscountOffsetDDO.itemId,
                qMktDiscountOffsetDDO.itemCode,
                qMktDiscountOffsetDDO.itemName,
                qMktDiscountOffsetDDO.itemAttr,
                qMktDiscountOffsetDDO.uom,
                qMktDiscountOffsetDDO.limitAmt,
                qMktDiscountOffsetDDO.limitNum,
                qMktDiscountOffsetDDO.basePrice,
                qMktDiscountOffsetDDO.custPrice,
                qMktDiscountOffsetDDO.freeAmt,
                qMktDiscountOffsetDDO.discountPrice
                ))
                .from(qMktDiscountOffsetDO)
                .leftJoin(qMktDiscountOffsetDDO).on(qMktDiscountOffsetDDO.mktDiscountOffsetId.eq(qMktDiscountOffsetDO.id))
                .where(qMktDiscountOffsetDO.code.eq(offsetCode)
                        .and(qMktDiscountOffsetDO.validStime.loe(LocalDateTime.now()))
                        .and(qMktDiscountOffsetDO.validEtime.goe(LocalDateTime.now()))
                        .and(qMktDiscountOffsetDO.status.eq(UdcEnum.MKT_DISCOUNT_OFFSET_STATUS_ENABLE.getValueCode())))
                .fetch();
    }

    public boolean checkValid(String offsetCode){
        return jpaQueryFactory.select(qMktDiscountOffsetDO.count())
                .from(qMktDiscountOffsetDO)
                .where(qMktDiscountOffsetDO.code.eq(offsetCode)
                        .and(qMktDiscountOffsetDO.validStime.loe(LocalDateTime.now()))
                        .and(qMktDiscountOffsetDO.validEtime.goe(LocalDateTime.now()))
                        .and(qMktDiscountOffsetDO.status.eq(UdcEnum.MKT_DISCOUNT_OFFSET_STATUS_ENABLE.getValueCode())))
                .fetchOne() > 0;
    }

    /**
     * 更新促销状态 标记
     *
     * @param ids
     * @param status 促销状态
     */
    public void updateStatusBatch(List<Long> ids, String status) {
        jpaQueryFactory.update(qMktDiscountOffsetDO)
                .set(qMktDiscountOffsetDO.status, status)
                .where(qMktDiscountOffsetDO.id.in(ids))
                // .where(DataAuthJpaUtil.dataAuthJpaPredicate(qMktDiscountOffsetDO.getMetadata()))
                .execute();
    }

    /**
     * 更新逻辑删除 标记
     *
     * @param ids
     * @param deleteFlag
     */
    public void updateDeleteFlagBatch(List<Long> ids, int deleteFlag) {
        jpaQueryFactory.update(qMktDiscountOffsetDO)
                .set(qMktDiscountOffsetDO.deleteFlag, deleteFlag)
                .where(qMktDiscountOffsetDO.id.in(ids))
                // .where(DataAuthJpaUtil.dataAuthJpaPredicate(qMktDiscountOffsetDO.getMetadata()))
                .execute();

        jpaQueryFactory.update(qMktDiscountOffsetDDO)
                .set(qMktDiscountOffsetDDO.deleteFlag, deleteFlag)
                .where(qMktDiscountOffsetDDO.mktDiscountOffsetId.in(ids))
                // .where(DataAuthJpaUtil.dataAuthJpaPredicate(qMktDiscountOffsetDDO.getMetadata()))
                .execute();
    }

    /**
     * 删除(主/附)表数据
     *
     * @param idList 删除的主表主键集合
     */
    public void deleteIdBatch(List<Long> idList) {
        jpaQueryFactory.delete(qMktDiscountOffsetDO)
                .where(qMktDiscountOffsetDO.id.in(idList))
                // .where(DataAuthJpaUtil.dataAuthJpaPredicate(qMktDiscountOffsetDO.getMetadata()))
                .execute();
        jpaQueryFactory.delete(qMktDiscountOffsetDDO)
                .where(qMktDiscountOffsetDDO.mktDiscountOffsetId.in(idList))
                // .where(DataAuthJpaUtil.dataAuthJpaPredicate(qMktDiscountOffsetDDO.getMetadata()))
                .execute();
    }

    /**
     * 校验  有效的时间区间内，是否存在相同的商品规则
     *
     * @param masId       可为null
     * @param ouId
     * @param customLevel
     * @param validStime
     * @param validEtime
     * @param itemIds
     * @return 重复的促销编号、商品编码
     */
    public List<Tuple> checkItemExitsInValidDate(Long masId, Long ouId, String customLevel, LocalDateTime validStime, LocalDateTime validEtime, List<Long> itemIds) {
        JPAQuery<Tuple> jpaQuery = jpaQueryFactory.select(qMktDiscountOffsetDO.code, qMktDiscountOffsetDDO.itemCode).distinct()
                .from(qMktDiscountOffsetDDO)
                .join(qMktDiscountOffsetDO)
                .on(qMktDiscountOffsetDDO.mktDiscountOffsetId.eq(qMktDiscountOffsetDO.id))
                .where(qMktDiscountOffsetDO.deleteFlag.eq(ConstantsSale.COMMON_DELETE_NO))
                .where(qMktDiscountOffsetDDO.deleteFlag.eq(ConstantsSale.COMMON_DELETE_NO))
                .where(qMktDiscountOffsetDO.ouId.eq(ouId))
                .where(qMktDiscountOffsetDDO.itemId.in(itemIds))
                .where(qMktDiscountOffsetDO.status.eq("ENABLE"))
                .where(qMktDiscountOffsetDO.validStime.between(validStime, validEtime)
                        .or(qMktDiscountOffsetDO.validEtime.between(validStime, validEtime))
                        .or(qMktDiscountOffsetDO.validStime.before(validStime).and(qMktDiscountOffsetDO.validEtime.after(validEtime)))
                );
        if (!StringUtils.isEmpty(customLevel)) {
            jpaQuery.where(qMktDiscountOffsetDO.customLevel.eq(customLevel).or(qMktDiscountOffsetDO.customLevel.isNull()));
        }
        if (masId != null) {
            jpaQuery.where(qMktDiscountOffsetDO.id.ne(masId));
        }
        return jpaQuery.fetch();
    }


   /**
       * @Description: 查询符合条件的折扣信息
       * @Param: [ouId, customLevel, date, itemId, num, amt]
       * @return: com.querydsl.jpa.impl.JPAQuery<com.elitesland.sale.api.vo.resp.shop.MktDiscountOffsetVO>
       * @Author: wangyinghao
       * @Date: 2021/9/7
       */
    public JPAQuery<MktDiscountOffsetVO> findMatchMktDisCountOffset(Long ouId, String customLevel, LocalDateTime date, Long itemId, Long num, BigDecimal amt) {

        JPAQuery<MktDiscountOffsetVO> jpaQuery = jpaQueryFactory.select(Projections.bean(MktDiscountOffsetVO.class,
                qMktDiscountOffsetDO.id.as("mktDiscountOffsetId"),
                qMktDiscountOffsetDO.code,
                qMktDiscountOffsetDO.name,
                qMktDiscountOffsetDO.validStime,
                qMktDiscountOffsetDO.validEtime,
                qMktDiscountOffsetDO.customLevel,
                qMktDiscountOffsetDO.ouId,
                qMktDiscountOffsetDO.ouCode,
                qMktDiscountOffsetDO.ouName,
                qMktDiscountOffsetDO.buId,
                qMktDiscountOffsetDO.buCode,
                qMktDiscountOffsetDO.buName,
                qMktDiscountOffsetDO.currCode,
                qMktDiscountOffsetDO.type,
                qMktDiscountOffsetDO.status,

                qMktDiscountOffsetDDO.id.as("mktDiscountOffsetDId"),
                qMktDiscountOffsetDDO.itemId,
                qMktDiscountOffsetDDO.itemCode,
                qMktDiscountOffsetDDO.itemName,
                qMktDiscountOffsetDDO.itemAttr,
                qMktDiscountOffsetDDO.uom,
                qMktDiscountOffsetDDO.limitAmt,
                qMktDiscountOffsetDDO.limitNum,
                qMktDiscountOffsetDDO.basePrice,
                qMktDiscountOffsetDDO.custPrice,
                qMktDiscountOffsetDDO.freeAmt,
                qMktDiscountOffsetDDO.discountPrice
        ))
                .from(qMktDiscountOffsetDO)
                .join(qMktDiscountOffsetDDO).on(qMktDiscountOffsetDO.id.eq(qMktDiscountOffsetDDO.mktDiscountOffsetId))

                .where(qMktDiscountOffsetDO.deleteFlag.eq(ConstantsSale.COMMON_DELETE_NO))
                .where(qMktDiscountOffsetDDO.deleteFlag.eq(ConstantsSale.COMMON_DELETE_NO))
                .where(qMktDiscountOffsetDO.status.eq(UdcEnum.MKT_DISCOUNT_OFFSET_STATUS_ENABLE.getValueCode()))
                .where(qMktDiscountOffsetDO.ouId.eq(ouId))
                .where(qMktDiscountOffsetDDO.itemId.eq(itemId))
                .where(qMktDiscountOffsetDO.validStime.before(date).or(qMktDiscountOffsetDO.validStime.eq(date)))
                .where(qMktDiscountOffsetDO.validEtime.after(date).or(qMktDiscountOffsetDO.validEtime.eq(date)));
        if (!StringUtils.isEmpty(customLevel)) {
            jpaQuery.where(qMktDiscountOffsetDO.customLevel.eq(customLevel).or(qMktDiscountOffsetDO.customLevel.isNull()));
        }
        if(Objects.nonNull(num)){
            jpaQuery.where(qMktDiscountOffsetDO.type.eq("0"));
            jpaQuery.where(qMktDiscountOffsetDDO.limitNum.eq(num));

        }
        if(Objects.nonNull(amt)){
            jpaQuery.where(qMktDiscountOffsetDO.type.goe("1"));
            jpaQuery.where(qMktDiscountOffsetDDO.limitAmt.goe(amt));
        }
        return jpaQuery;
    }

    public List<Long> getOuIdById(Long id){
        return jpaQueryFactory.select(qMktDiscountOffsetDO.ouId).from(qMktDiscountOffsetDO)
                .where(qMktDiscountOffsetDO.id.eq(id)).fetch();
    }

    public List<Long> getOffsetSkuId(Long id){
        return jpaQueryFactory.select(qMktDiscountOffsetDDO.itemId).from(qMktDiscountOffsetDDO)
                .where(qMktDiscountOffsetDDO.mktDiscountOffsetId.eq(id)).fetch();
    }

    public List<String> getOffsetSkuCode(Long id){
        return jpaQueryFactory.select(qMktDiscountOffsetDDO.itemCode).from(qMktDiscountOffsetDDO)
                .where(qMktDiscountOffsetDDO.mktDiscountOffsetId.eq(id)).fetch();
    }

    public List<Long> getOffsetId(Long ouId){
        return jpaQueryFactory.select(qMktDiscountOffsetDO.id).from(qMktDiscountOffsetDO)
                .where(qMktDiscountOffsetDO.ouId.eq(ouId))
                .where(qMktDiscountOffsetDO.status.eq("ENABLE"))
                .where(qMktDiscountOffsetDO.deleteFlag.eq(0))
                .fetch();
    }

    public List<Long> getOffsetDetailSkuId(List<Long> ids){
        return jpaQueryFactory.select(qMktDiscountOffsetDDO.itemId).from(qMktDiscountOffsetDDO)
                .where(qMktDiscountOffsetDDO.mktDiscountOffsetId.in(ids))
                .where(qMktDiscountOffsetDDO.deleteFlag.eq(0))
                .fetch();
    }

    public List<String> getOffsetDetailSkuCode(List<Long> ids){
        return jpaQueryFactory.select(qMktDiscountOffsetDDO.itemCode).from(qMktDiscountOffsetDDO)
                .where(qMktDiscountOffsetDDO.mktDiscountOffsetId.in(ids))
                .where(qMktDiscountOffsetDDO.deleteFlag.eq(0))
                .fetch();
    }

    public List<Long> findMasIdByItemCode(String itemCode){
        return jpaQueryFactory.select(qMktDiscountOffsetDDO.mktDiscountOffsetId).from(qMktDiscountOffsetDDO)
                .where(qMktDiscountOffsetDDO.itemCode.like("%"+itemCode+"%"))
                .where(qMktDiscountOffsetDDO.deleteFlag.eq(0).or(qMktDiscountOffsetDDO.deleteFlag.isNull()))
                .fetch();
    }

}
