package com.elitesland.yst.production.sale.rmi.ystsupport;


import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.dto.req.SysAreaQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysAreaRpcService;
import com.elitesland.yst.production.support.provider.item.service.ItmItemRpcService;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddressRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgAddressRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.service.OrgAddrRpcService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/3 09:59
 */
@Slf4j
@Component
public class RmiCityCodeService {

    @Autowired
    private SysAreaRpcService sysAreaRpcService;

    public List<SysAreaRespDTO> findCityCodeListByParam(SysAreaQueryDTO param){
        try {
            ApiResult<List<SysAreaRespDTO>> sysAreaRespDTOListApiResult = sysAreaRpcService.queryList(param);
            return CollUtil.isNotEmpty(sysAreaRespDTOListApiResult.getData()) ? sysAreaRespDTOListApiResult.getData() : new ArrayList<>(0);
        } catch (Exception e) {
            log.error("远程调用支撑域区域相关服务异常:{}", e.getMessage());
            throw new BusinessException("远程调用支撑域省地区查询相关服务异常"+e,e);
        }
    }
}
