package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.elitesland.yst.production.sale.api.dto.CustDTO;
import com.elitesland.yst.production.sale.api.service.BusFirstMenuConfService;
import com.elitesland.yst.production.sale.api.service.PriSalePriceService;
import com.elitesland.yst.production.sale.api.service.shop.BipCustUserBindService;
import com.elitesland.yst.production.sale.api.vo.param.menu.BusFirstMenuConfDSaveParam;
import com.elitesland.yst.production.sale.api.vo.param.menu.BusFirstMenuConfPagingParam;
import com.elitesland.yst.production.sale.api.vo.param.menu.BusFirstMenuConfSaveParam;
import com.elitesland.yst.production.sale.api.vo.param.pri.PriSalePriceTypeQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipHomeMenuPageVO;
import com.elitesland.yst.production.sale.api.vo.resp.menu.BusFirstMenuConfDVO;
import com.elitesland.yst.production.sale.api.vo.resp.menu.BusFirstMenuConfVO;
import com.elitesland.yst.production.sale.api.vo.resp.pri.PriSalePriceTypeRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipHomeDetailVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipHomeMenuVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.BusMenuConvert;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.*;
import com.elitesland.yst.production.sale.repo.BusFirstMenuConfDRepo;
import com.elitesland.yst.production.sale.repo.BusFirstMenuConfDRepoProc;
import com.elitesland.yst.production.sale.repo.BusFirstMenuConfRepo;
import com.elitesland.yst.production.sale.repo.BusFirstMenuConfRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepo;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepoProc;
//import com.elitesland.yst.production.sale.rmi.ystsupport.RmiItemService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.support.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.google.common.collect.Lists;
import com.querydsl.core.types.dsl.BooleanExpression;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@Service
@Slf4j
@RequiredArgsConstructor
public class BusFirstMenuConfServiceImpl implements BusFirstMenuConfService {

    private final BusFirstMenuConfRepo busFirstMenuConfRepo;

    private final BusFirstMenuConfRepoProc busFirstMenuConfRepoProc;

    private final RmiSysNextNumberService rmiSysNextNumberService;

    private final OrgEmpRpcService orgEmpRpcService;

    private final BusFirstMenuConfDRepo busFirstMenuConfDRepo;

    private final BusFirstMenuConfDRepoProc busFirstMenuConfDRepoProc;

    private final BipCustUserBindService custUserBindService;

    private final PriSalePriceService salePriceService;

    private final BipItemRepoProc bipItemRepoProc;
    private final BipItemSkuRepoProc bipItemSkuRepoProc;
//    private final RmiItemService rmiItemService;

    /**
     * 停用
     *
     * @param ids
     * @return
     */
    @Override
    public ApiResult<Object> stopMenuConf(List<Long> ids) {
        if (null != ids && !ids.isEmpty()) {
            ids.stream().forEach(id -> {
                Optional<BusFirstMenuConfDO> optional = busFirstMenuConfRepo.findById(id);
                if (optional.isPresent()) {
                    BusFirstMenuConfDO busFirstMenuConfDO = optional.get();
                    busFirstMenuConfDO.setStatus(UdcEnum.COM_STATUS_ACTIVEORNO_INACTIVE.getValueCode());
                    busFirstMenuConfRepo.save(busFirstMenuConfDO);
                }
            });
        }
        return ApiResult.ok();
    }

    @Override
    public void delMenuPic(Long id) {
        Optional<BusFirstMenuConfDO> optional = busFirstMenuConfRepo.findById(id);
        if (optional.isPresent()) {
            BusFirstMenuConfDO busFirstMenuConfDO = optional.get();
            busFirstMenuConfDO.setImgSign(null);
            busFirstMenuConfRepo.save(busFirstMenuConfDO);
        }
    }

    @Override
    public List<BusFirstMenuConfVO> findFirstPage(Long ouId) {
        QBusFirstMenuConfDO qBusFirstMenuConfDO = QBusFirstMenuConfDO.busFirstMenuConfDO;
        BooleanExpression expression = qBusFirstMenuConfDO.ouId.eq(ouId).and(qBusFirstMenuConfDO.status.eq(UdcEnum.COM_STATUS_ACTIVEORNO_ACTIVE.getCode()));
        Iterable<BusFirstMenuConfDO> iterable = busFirstMenuConfRepo.findAll(expression);
        List<BusFirstMenuConfVO> list = new ArrayList<>();
        if (null != iterable) {
            iterable.forEach(d -> {
                BusFirstMenuConfVO busFirstMenuConfVO = new BusFirstMenuConfVO();
                BeanUtils.copyProperties(d, busFirstMenuConfVO);
                list.add(busFirstMenuConfVO);
            });
        }
        return list;
    }


    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @Override
    public ApiResult<Object> delMenuConf(List<Long> ids) {
        if (null != ids && !ids.isEmpty()) {
            QBusFirstMenuConfDDO qBusFirstMenuConfDDO = QBusFirstMenuConfDDO.busFirstMenuConfDDO;
            ids.stream().forEach(id -> {
                Optional<BusFirstMenuConfDO> optional = busFirstMenuConfRepo.findById(id);
                if (optional.isPresent()) {
                    BusFirstMenuConfDO busFirstMenuConfDO = optional.get();
                    busFirstMenuConfDO.setDeleteFlag(1);
                    busFirstMenuConfRepo.save(busFirstMenuConfDO);
                    BooleanExpression expression = qBusFirstMenuConfDDO.menuId.eq(id);
                    Iterable<BusFirstMenuConfDDO> iterables = busFirstMenuConfDRepo.findAll(expression);
                    if (!IterUtil.isEmpty(iterables)) {
                        List<BusFirstMenuConfDDO> list = Lists.newArrayList(iterables);
                        list.stream().forEach(l -> {
                            l.setDeleteFlag(1);
                            busFirstMenuConfDRepo.save(l);
                        });
                    }
                }
            });
        }
        return ApiResult.ok();
    }

    /**
     * 启用菜单
     *
     * @param ids
     * @return
     */
    @Override
    public ApiResult<Object> openMenuConf(List<Long> ids) {
        if (null != ids && !ids.isEmpty()) {
            ids.stream().forEach(id -> {
                Optional<BusFirstMenuConfDO> optional = busFirstMenuConfRepo.findById(id);
                if (optional.isPresent()) {
                    BusFirstMenuConfDO busFirstMenuConfDO = optional.get();
                    busFirstMenuConfDO.setStatus(UdcEnum.COM_STATUS_ACTIVEORNO_ACTIVE.getValueCode());
                    busFirstMenuConfRepo.save(busFirstMenuConfDO);
                }
            });
        }
        return ApiResult.ok();
    }


    /**
     * 分页查询
     *
     * @return
     */
    @Override
    @SysCodeProc
    public PagingVO<BusFirstMenuConfVO> findMenuConfPagingResult(BusFirstMenuConfPagingParam param) {
//        OrgUserEmpInfoRpcDTO empInfo = getCurrentEmpInfo();
//        param.setOuId(empInfo.getOuId());
        PagingVO<BusFirstMenuConfVO> list = busFirstMenuConfRepoProc.findMenuConfPagingResult(param);
        return list;
    }

    @Override
    @SysCodeProc
    public BusFirstMenuConfVO findMenuById(Long id) {
        Optional<BusFirstMenuConfDO> optional = busFirstMenuConfRepo.findById(id);
        if (optional.isPresent()) {
            BusFirstMenuConfDO busFirstMenuConfDO = optional.get();
            BusFirstMenuConfVO vo = new BusFirstMenuConfVO();
            BeanUtils.copyProperties(busFirstMenuConfDO, vo);
            List<BusFirstMenuConfDVO> resList = new ArrayList<>();
            List<BusFirstMenuConfDDO> list = getByMenuId(id);
            if (null != list && !list.isEmpty()) {
                list.stream().forEach(ddo -> {
                    if (StringUtils.isNotBlank(ddo.getState()) && ddo.getState().equals(UdcEnum.BIP_ITEM_STATE_SHELF.getValueCode())) {
                        BusFirstMenuConfDVO busFirstMenuConfDVO = new BusFirstMenuConfDVO();
                        BeanUtils.copyProperties(ddo, busFirstMenuConfDVO);
                        busFirstMenuConfDVO.setItemId(ddo.getItemId());
                        resList.add(busFirstMenuConfDVO);
                    }
                });
                if (null != resList && !resList.isEmpty()) {
                    //     vo.setList(resList.stream().sorted(Comparator.comparing(BusFirstMenuConfDVO :: getSort)).collect(Collectors.toList()));
                    vo.setList(resList);
                }
            }
            return vo;
        }
        return null;
    }

    public List<BusFirstMenuConfDDO> getByMenuId(Long id) {
        QBusFirstMenuConfDDO qBusFirstMenuConfDDO = QBusFirstMenuConfDDO.busFirstMenuConfDDO;
        BooleanExpression expression = qBusFirstMenuConfDDO.menuId.eq(id).and(qBusFirstMenuConfDDO.deleteFlag.eq(0));
        Iterable<BusFirstMenuConfDDO> iterables = busFirstMenuConfDRepo.findAll(expression);
        if (!IterUtil.isEmpty(iterables)) {
            return Lists.newArrayList(iterables);
        }
        return null;
    }


    /**
     * 新增或修改
     *
     * @param param
     * @return
     */
    @Override
    public ApiResult<Object> addOrUpdateMenuConf(BusFirstMenuConfSaveParam param) {

        log.info("菜单新增参数：{}", JSON.toJSONString(param));
        
        BusFirstMenuConfDO busFirstMenuConfDO = new BusFirstMenuConfDO();
        OrgUserEmpInfoRpcDTO empInfo = getCurrentEmpInfo();
        if (null == param.getId()) {
            BeanUtils.copyProperties(param, busFirstMenuConfDO);
            busFirstMenuConfDO.setSecBuId(empInfo.getBuId());
            busFirstMenuConfDO.setSecOuId(empInfo.getOuId());
            busFirstMenuConfDO.setSecUserId(empInfo.getUserId());
            busFirstMenuConfDO.setStatus(UdcEnum.COM_STATUS_ACTIVEORNO_INACTIVE.getValueCode());
            String menuCode = rmiSysNextNumberService.generateCode("yst-sale","MENU_MANAGE", new ArrayList<>());
            busFirstMenuConfDO.setMenuNo(menuCode);
        } else {
            Optional<BusFirstMenuConfDO> optional = busFirstMenuConfRepo.findById(param.getId());
            if (optional.isPresent()) {
                busFirstMenuConfDO = optional.get();
                busFirstMenuConfDO.setOuId(param.getOuId());
                busFirstMenuConfDO.setOuName(param.getOuName());
                busFirstMenuConfDO.setMenuName(param.getMenuName());
                busFirstMenuConfDO.setImgSign(param.getImgSign());
                busFirstMenuConfDO.setMenuSort(param.getMenuSort());
            }
        }
        busFirstMenuConfDO = busFirstMenuConfRepo.save(busFirstMenuConfDO);
        //删除详情
        QBusFirstMenuConfDDO qBusFirstMenuConfDDO = QBusFirstMenuConfDDO.busFirstMenuConfDDO;
        BooleanExpression expression = qBusFirstMenuConfDDO.menuId.eq(busFirstMenuConfDO.getId()).and(qBusFirstMenuConfDDO.deleteFlag.eq(0));
        Iterable<BusFirstMenuConfDDO> iterables = busFirstMenuConfDRepo.findAll(expression);
        if (!IterUtil.isEmpty(iterables)) {
            List<BusFirstMenuConfDDO> ddoList = Lists.newArrayList(iterables);
            ddoList.stream().forEach(ddo -> {
                ddo.setDeleteFlag(1);
                busFirstMenuConfDRepo.save(ddo);
            });
        }
        List<BusFirstMenuConfDSaveParam> paramList = param.getList();
        if (null != paramList && !paramList.isEmpty()) {
            BusFirstMenuConfDO finalBusFirstMenuConfDO = busFirstMenuConfDO;
            paramList.stream().forEach(params -> {
                BusFirstMenuConfDDO busFirstMenuConfDDO = new BusFirstMenuConfDDO();
                BeanUtils.copyProperties(params, busFirstMenuConfDDO);
                busFirstMenuConfDDO.setOuId(param.getOuId());
                busFirstMenuConfDDO.setOuName(param.getOuName());

                busFirstMenuConfDDO.setItemId(params.getItemId());
                busFirstMenuConfDDO.setItemAttr(params.getItemAttr());
                busFirstMenuConfDDO.setItemBrand(params.getItemBrand());
                busFirstMenuConfDDO.setBarcode(params.getBarcode());
                busFirstMenuConfDDO.setSort(params.getSort());
                busFirstMenuConfDDO.setCategoryName(params.getCategoryName());
                busFirstMenuConfDDO.setMenuId(finalBusFirstMenuConfDO.getId());
                if (StringUtils.isBlank(params.getState())) {
                    busFirstMenuConfDDO.setState(UdcEnum.BIP_ITEM_STATE_SHELF.getValueCode());
                }

                Assert.notNull(busFirstMenuConfDDO.getItemId(),"商品【"+params.getItemName()+"】的ID不能为空！");
                Assert.notBlank(busFirstMenuConfDDO.getItemCode(),"商品【"+params.getItemName()+"】的编码不能为空！");

                busFirstMenuConfDRepo.save(busFirstMenuConfDDO);
            });
        }
        return ApiResult.ok();
    }


    private OrgUserEmpInfoRpcDTO getCurrentEmpInfo() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户已失效,请重登录重试");
        }
        OrgUserEmpInfoRpcDTO userEmpInfo = orgEmpRpcService.findUserEmpInfo(currentUser.getUserId());
        if (userEmpInfo == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "无法获取当前用户信息");
        }
        return userEmpInfo;
    }

    @Override
    public List<BipHomeMenuVO> findHomeMenu(Long ouId) {

        // 选择的ouId最高优先权
        if (ouId != null) {
            List<BusFirstMenuConfDO> dos = busFirstMenuConfRepoProc
                    .selectForHome(ouId)
                    .stream()
                    .peek(bfmc -> {
                        if (null != bfmc.getMenuSort()) {
                            return;
                        }
                        bfmc.setMenuSort(999);
                    })
                    .sorted(Comparator.comparing(BusFirstMenuConfDO::getMenuSort))
                    .collect(Collectors.toList());

            return BusMenuConvert.INSTANCE.dosToVOS(dos);
        }

        return Collections.emptyList();
    }

    @Override
    public PagingVO<BipHomeDetailVO> findHomeMenuDetails(BipHomeMenuPageVO bipHomeMenuPageVO) {

//        Assert.notNull(bipHomeMenuPageVO.getMenuId(), "菜单ID不能为空！");
//
//        // 分页
//        var ret = busFirstMenuConfDRepo.findAll(busFirstMenuConfDRepoProc.whereForHome(bipHomeMenuPageVO), bipHomeMenuPageVO.getPageRequest());
//        var vos = ret.getContent().stream().map(BusMenuConvert.INSTANCE::dodToVO).collect(Collectors.toList());
//
//        List<BipItemDO> items = bipItemRepoProc.getItemByCodes(vos.stream().map(BipHomeDetailVO::getItemCode).collect(Collectors.toList()));
//        Map<String, BipItemDO> itemDOMap = items.stream().collect(Collectors.toMap(BipItemDO::getItemCode, item -> item, (t1, t2) -> t1));
//
//        // 查询客户等级价格补充数据
//        for (var vo : vos) {
//
//            BipItemDO it = itemDOMap.get(vo.getItemCode());
//
//            if (it==null||!it.getOnShelf()) continue;
//
//            List<BipItemSkuDO> skuDOList = bipItemSkuRepoProc.findSkuOnMenu(bipHomeMenuPageVO.getOuId(),vo.getItemCode());
//
//            if (skuDOList.size()==0) continue;
//
//            ItmItemRpcDtoParam codeparam = new ItmItemRpcDtoParam();
//            codeparam.setItemCodes(skuDOList.stream().map(BipItemSkuDO::getSkuCode).collect(Collectors.toList()));
//            List<ItmItemRpcDTO> dtos = new ArrayList<>(rmiItemService.findItemListByParam(codeparam));
//            if (dtos.size() == 0){
//                throw new BusinessException("查询菜单商品价格时，未在支撑域找到该商品："+JSON.toJSONString(skuDOList));
//            }
//
//            vo.setItemId(it.getId());
//            vo.setMainPicId(it.getMainPicId());
//            vo.setMainPicUrl(it.getMainPicUrl());
//            vo.setItemTitle(it.getTitle());
//            vo.setCurrCode("CNY");
//            List<SupportItem> supportItems = new ArrayList<>();
//            for (ItmItemRpcDTO dto : dtos) {
//                SupportItem supportItem = SupportItem
//                        .builder()
//                        .id(dto.getId())
//                        .uom(dto.getUom())
//                        .build();
//
//                supportItems.add(supportItem);
//            }
//            vo.setSupportItems(supportItems);
//
//        }
//
//        List<BipHomeDetailVO> collect = vos.stream().filter(zvo -> zvo.getSupportItems().size() > 0).collect(Collectors.toList());
//
//        // 最小客户等级价格
//        convertCustPrice(collect);
//
//        // 最小基础价格
//        convertBasePrice(collect, bipHomeMenuPageVO.getOuId());
//
//        return PagingVO.<BipHomeDetailVO>builder()
//                .total((long) collect.size())
//                .records(collect)
//                .build();
        return null;
    }

    private void convertCustPrice(List<BipHomeDetailVO> detail) {

        CurrentUserDTO user = UserService.currentUser();

        if (user==null){
            return;
        }

        CustDTO cust = custUserBindService.getCustOfUserBind(user.getUserId()).getData();

        if (cust == null || StringUtils.isBlank(cust.getCustLevel())){
            return;
        }

        for (var resp : detail) {
            PriSalePriceTypeQueryParam param = new PriSalePriceTypeQueryParam();
            param.setPriceType(UdcEnum.PRI_SALE_PRICE_TYPE_GROUP.getValueCode());
            param.setCustLevel(cust.getCustLevel());
            param.setCurrCode("CNY");
            param.setOuId(cust.getOuId());

            // 设置最小客户等级价格
            resp.getSupportItems()
                    .stream()
                    .map(item -> {
                        param.setItemId(item.getId());
                        param.setUom(item.getUom());

                        PriSalePriceTypeRespVO vo = salePriceService.queryPrice(param);

                        log.info("菜单详情最小客户等级价格：" + JSON.toJSONString(vo));

                        return vo;
                    })
                    .filter(Objects::nonNull)
                    .map(PriSalePriceTypeRespVO::getPrice)
                    .min(BigDecimal::compareTo)
                    .ifPresentOrElse(resp::setPriceCust,()->resp.setPriceCust(null));

        }

    }

    private void convertBasePrice(List<BipHomeDetailVO> respVOList, Long ouId) {

        Assert.notNull(ouId, "菜单列表的商品查询基础价格时公司ID不能为空");

        for (var resp : respVOList) {
            PriSalePriceTypeQueryParam param = new PriSalePriceTypeQueryParam();

            param.setPriceType(UdcEnum.PRI_SALE_PRICE_TYPE_BASE.getValueCode());
            param.setCurrCode(resp.getCurrCode());
            param.setOuId(ouId);

            // 设置最小基础价格
            resp.getSupportItems()
                    .stream()
                    .map(item->{
                        param.setItemId(item.getId());
                        param.setUom(item.getUom());

                        PriSalePriceTypeRespVO vo = salePriceService.queryPrice(param);

                        log.info("菜单详情最小基础价格：{}", JSON.toJSONString(vo));

                        return vo;
                    })
                    .filter(Objects::nonNull)
                    .map(PriSalePriceTypeRespVO::getPrice)
                    .min(BigDecimal::compareTo)
                    .ifPresentOrElse(resp::setPrice,()->resp.setPrice(null));
        }
    }

}
