package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysCurrencyRpcService;
import com.elitesland.yst.production.sale.api.service.SalContractRecvService;
//import com.elitesland.yst.production.sale.api.service.SalContractService;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalContractQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalContractRecvPagingParam;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustSimpleVO;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalContractRecvPageRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalContractSimpleRespVO;
import com.elitesland.yst.production.sale.api.vo.save.SalConRecvImportSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.SalContractImportSaveVO;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.common.model.UserDTO;
import com.elitesland.yst.production.sale.convert.SalContractRecvConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.SalContractDO;
import com.elitesland.yst.production.sale.entity.SalContractRecvDO;
import com.elitesland.yst.production.sale.repo.*;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiCommonService;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/9 1:09 下午
 */
@Service
@RequiredArgsConstructor
public class SalContractRecvServiceImpl extends BaseServiceImpl implements SalContractRecvService {


//    private final SalContractService salContractService;
    private final RmiCommonService rmiCommonService;
    private final CrmCustRepoProc crmCustRepoProc;
    private final SalContractRepo salContractRepo;
    private final SalContractRecvRepo salContractRecvRepo;
    private final SalContractRepoProc salContractRepoProc;
    private final SysCurrencyRpcService sysCurrencyRpcService;

    @Override
    @SysCodeProc
    public PagingVO<SalContractRecvPageRespVO> query(SalContractRecvPagingParam pageParam) {
//        Predicate predicate = qSalContractRecvDO.isNotNull();
////        // 添加权限信息
//        predicate = ExpressionUtils.and(predicate, DataAuthJpaUtil.dataAuthJpaPredicate(qSalContractRecvDO.getMetadata()));
//        // 合同编号和合同名称不为空的话，需要先反查合同
//        if (Objects.nonNull(pageParam)) {
//            if (StrUtil.isNotBlank(pageParam.getContractNo()) ||
//                    StrUtil.isNotBlank(pageParam.getContractName()) || Objects.nonNull(pageParam.getCustId())) {
//                var contractQueryParam = new SalContractQueryParam();
//                contractQueryParam.setContractNo(pageParam.getContractNo());
//                contractQueryParam.setContractName(pageParam.getContractName());
//                contractQueryParam.setCustId(pageParam.getCustId());
//                List<SalContractSimpleRespVO> contractResult = salContractService.queryByParam(contractQueryParam);
//                List<Long> contractIds = contractResult.stream().map(SalContractSimpleRespVO::getId).collect(Collectors.toList());
//                pageParam.setContractIds(contractIds);
//            }
//            if (CollUtil.isNotEmpty(pageParam.getContractIds())) {
//                predicate = ExpressionUtils.and(predicate, qSalContractRecvDO.masId.in(pageParam.getContractIds()));
//            }
//            if (Objects.nonNull(pageParam.getArDate())) {
//                predicate = ExpressionUtils.and(predicate, qSalContractRecvDO.arDate.eq(pageParam.getArDate()));
//            }
//        }
//        var jpaQuery = jpaQueryFactory.select(
//                Projections.bean(SalContractRecvPageRespVO.class,
//                        qSalContractRecvDO.id,
//                        qSalContractRecvDO.masId,
//                        qSalContractRecvDO.arAmt,
//                        qSalContractRecvDO.currCode,
//                        qSalContractRecvDO.arDate,
//                        qSalContractRecvDO.inputer,
//                        qSalContractRecvDO.inputDate)
//
//        ).from(qSalContractRecvDO).where(predicate);
//        long total = jpaQuery.fetchCount();
//        if (total == 0) {
//            return PagingVO.<SalContractRecvPageRespVO>builder().build();
//        }
//        // 添加分页和排序
//        var pageRequest = wrapperPageRequest(pageParam.getPageRequest(), null);
//        appendPageAndSort(jpaQuery, pageRequest, qSalContractRecvDO);
//        // 查询结果
//        List<SalContractRecvPageRespVO> pageResult = jpaQuery.fetch();
//        // 填充币种名称
//        List<String> currCodes = pageResult.stream().map(SalContractRecvPageRespVO::getCurrCode).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
//        List<ComCurrRpcDTO> currRpcResult = rmiCommonService.findCurrDtoList(currCodes);
//        // 补充合同数据
//        List<Long> contractIds = pageResult.stream().map(SalContractRecvPageRespVO::getMasId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
//        SalContractQueryParam salContractQueryParam = new SalContractQueryParam();
//        salContractQueryParam.setIds(contractIds);
//        List<SalContractSimpleRespVO> contractResult = salContractService.queryByParam(salContractQueryParam);
//        pageResult.forEach(r -> {
//            contractResult.stream().filter(con -> con.getId().equals(r.getMasId()))
//                    .findFirst().ifPresent(contract -> {
//                r.setContractNo(contract.getContractNo());
//                r.setContractName(contract.getContractName());
//                r.setCurrCode(contract.getCurrCode());
//                r.setCustName(contract.getCustName());
//                r.setCustCode(contract.getCustCode());
//            });
//            currRpcResult.stream().filter(c -> (StrUtil.isNotBlank(r.getCurrCode()) && r.getCurrCode().equals(c.getCurrCode())))
//                    .findFirst().ifPresent(curr -> r.setCurrName(curr.getCurrName()));
//        });
//        return PagingVO.<SalContractRecvPageRespVO>builder()
//                .total(total)
//                .records(pageResult).build();
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> conRecvImportData(List<SalConRecvImportSaveVO> parseData) {
        importDataHadle(parseData);
        List<SalContractRecvDO> salContractRecvDOS = parseData.stream().map(SalContractRecvConvert.INSTANCE::importToDO).collect(Collectors.toList());
        salContractRecvRepo.saveAll(salContractRecvDOS);
        return ApiResult.ok();
    }

    private void importDataHadle(List<SalConRecvImportSaveVO> parseData){
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "无法到获取当前用户");
        }

        // 相关数据是否存在校验
        List<String> contractCodes = parseData.stream().map(SalConRecvImportSaveVO::getContractNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Set<String> currNames = parseData.stream().map(SalConRecvImportSaveVO::getCurrCode).filter(Objects::nonNull).collect(Collectors.toSet());
        List<SalContractDO> allByContractNoIn = salContractRepo.findAllByContractNoIn(contractCodes);

        ApiResult<List<SysCurrencyRespDTO>> sysCurrencyRespDTOListApiResult = sysCurrencyRpcService.listByCodes(currNames);
        Assert.notNull(sysCurrencyRespDTOListApiResult,"查询币种失败");
        Assert.isTrue(sysCurrencyRespDTOListApiResult.isSuccess(),"查询币种失败");

        // 以销售合同号为key进行map分组
        Map<String, List<SalConRecvImportSaveVO>> contractRecvListMap =  parseData.stream().collect(Collectors.groupingBy(SalConRecvImportSaveVO::getContractNo));
        parseData.forEach(importVo ->{
            //必填校验
            Assert.isFalse(StringUtils.isEmpty(importVo.getContractNo()), "excel中存在数据合同编码为空");
            Assert.isFalse(StringUtils.isEmpty(importVo.getArDate()), "excel中存在数据应收日期为空");
            Assert.isFalse(StringUtils.isEmpty(importVo.getArAmt()), "excel中存在数据应收金额为空");
            // 相关数据是否存在校验
            SalContractDO salContractDO = allByContractNoIn.stream().filter(con -> con.getContractNo().equals(importVo.getContractNo()))
                    .findFirst().orElseThrow(
                            new BusinessException("合同号为:" + importVo.getContractNo() + "的合同在我方系统中不存在,请检查")
                    );
            importVo.setMasId(salContractDO.getId());
            importVo.setSecOuId(salContractDO.getSecOuId());
            importVo.setSecBuId(salContractDO.getSecBuId());
            importVo.setSecUserId(salContractDO.getSecUserId());
            if (ObjectUtils.isEmpty(importVo.getInputer())){
                importVo.setInputer(currentUser.getDetail().getUsername());
            }
            importVo.setInputDate(LocalDate.now());
            // 6.币种处理
            if (!ObjectUtils.isEmpty(importVo.getCurrCode())){
                String currCode = sysCurrencyRespDTOListApiResult.getData().stream().filter(curr -> curr.getCurrName().equals(importVo.getCurrCode()))
                        .findFirst().orElseThrow(
                                new BusinessException("合同号为:" + importVo.getContractNo() + "的合同收款计划数据币种不存在于本系统中请检查")
                        ).getCurrCode();
                importVo.setCurrCode(currCode);
                if (!importVo.getCurrCode().equals(salContractDO.getCurrCode())){
                    throw new BusinessException("合同号为:" + importVo.getContractNo() + "的合同收款计划数据币种与所属合同的币种不一致请检查");
                }
            }else{
                importVo.setCurrCode(salContractDO.getCurrCode());
            }
        });
        // 针对于金额的校验,所有的收款计划收款金额不能大于对应合同的总金额
        for (String key: contractRecvListMap.keySet()) {
            // 查询已经存在的收款计划(通过合同号)
            List<SalContractRecvDO> allByContractNo = salContractRecvRepo.findAllByContractNo(key);
            BigDecimal totalArAmt = BigDecimal.ZERO;
            if (!CollectionUtils.isEmpty(allByContractNo)){
                totalArAmt = allByContractNo.stream().map(SalContractRecvDO::getArAmt).reduce(BigDecimal::add).get();
            }
            // 查询对应合同的收款金额总和
            BigDecimal totalAmt = salContractRepoProc.getTotalAmt(key);
            // 本次验收金额总数
            List<SalConRecvImportSaveVO> salConRecvImportSaveVOS = contractRecvListMap.get(key);
            BigDecimal acTotalAmt = salConRecvImportSaveVOS.stream().map(SalConRecvImportSaveVO::getArAmt).reduce(BigDecimal::add).get();
            if (totalArAmt.add(acTotalAmt).compareTo(totalAmt) == 1){
                throw new BusinessException("合同号为:" + key + "的合同收款计划数据,收款金额总和大于合同的总金额,请检查");
            }
        }
    }
}
