package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.sale.api.dto.CustDTO;
import com.elitesland.yst.production.sale.api.service.PriSalePriceService;
import com.elitesland.yst.production.sale.api.service.shop.BipCustUserBindService;
import com.elitesland.yst.production.sale.api.service.shop.BipItemAppService;
import com.elitesland.yst.production.sale.api.vo.param.pri.PriSalePriceTypeQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipItemAppQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipItemRecommendAppQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.pri.PriSalePriceTypeRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.*;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.*;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.shop.BipItemConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.*;
import com.elitesland.yst.production.sale.repo.CrmCustRepoProc;
import com.elitesland.yst.production.sale.repo.FirstSpecialItemRepo;
import com.elitesland.yst.production.sale.repo.FirstSpecialRepo;
import com.elitesland.yst.production.sale.repo.shop.*;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgAddrService;
import com.elitesland.yst.production.support.provider.org.param.OrgAddressRpcDtoParam;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.querydsl.core.types.*;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.jpa.JPAExpressions;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/30
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BipItemAppServiceImpl extends BaseServiceImpl implements BipItemAppService {

    private final BipItemRepo itemRepo;
    private final BipItemRepoProc itemRepoProc;
    private final BipItemExtRepo itemExtRepo;
    private final BipItemPicRepoProc itemPicRepoProc;
    private final BipItemSkuRepoProc itemSkuRepoProc;
    private final CrmCustRepoProc custRepoProc;

    private final BipCustUserBindService custUserBindService;
    private final PriSalePriceService salePriceService;

    private final BipOrderRepo bipOrderRepo;
    private final BipOrderDRepo bipOrderDRepo;

    private final FirstSpecialRepo firstSpecialRepo;
    private final FirstSpecialItemRepo firstSpecialItemRepo;

    private final BipItemSkuRepo bipItemSkuRepo;
    private final BipItemSkuRepoProc bipItemSkuRepoProc;
//
//    private final RmiItemService rmiItemService;
    private final RmiOrgAddrService rmiOrgAddrService;

    private final MktDiscountGiftRepoProc mktDiscountGiftRepoProc;
    private final MktDiscountOffsetRepoProc mktDiscountOffsetRepoProc;

    private static final BipItemConvert CONVERT = BipItemConvert.INSTANCE;
    private static final QBipItemDO ITEM_DO = QBipItemDO.bipItemDO;

    @Override
    public ApiResult<PagingVO<BipItemListAppRespVO>> queryForApp(BipItemAppQueryParamVO queryParamVO) {
        queryParamVO.setCurrent(NumberUtil.max(1, ObjectUtil.defaultIfNull(queryParamVO.getCurrent(), 1)));
        queryParamVO.setSize(NumberUtil.max(1, ObjectUtil.defaultIfNull(queryParamVO.getSize(), 10)));

        var pageData = searchForAppByDB(queryParamVO);
        if (CollUtil.isEmpty(pageData.getRecords())) {
            return ApiResult.ok(pageData);
        }

        Long userId = currentUserId();

        // 设置支撑域商品
        setSupportItem(pageData.getRecords());
        // 获取最小价格
        setMinPrice(pageData.getRecords(), userId, queryParamVO.getOuId());

        for (var item : pageData.getRecords()) {
            item.setGiftFlag(false);
            item.setOffsetFlag(false);
            var discountGift = findDiscountGift(item.getId(), queryParamVO.getOuId());
            if (discountGift!=null && discountGift.size()>0){
                item.setGiftFlag(true);
            }
            var discountOffset = findDiscountOffset(item.getId(), queryParamVO.getOuId());
            if (discountOffset!=null && discountOffset.size()>0){
                item.setOffsetFlag(true);
            }
        }

        return ApiResult.ok(pageData);
    }

    @Override
    public ApiResult<List<BipItemListAppRespVO>> rotationItem(String offsetCode) {
        List<MktDiscountOffsetVO> offsetVOS = mktDiscountOffsetRepoProc.selectForRotation(offsetCode);

        if (offsetVOS.size()==0){
            return ApiResult.ok(Collections.emptyList());
        }

        List<BipItemDO> spus = bipItemSkuRepoProc.findSkuOnRotation(offsetVOS.get(0).getOuId(),
                offsetVOS.stream()
                        .map(MktDiscountOffsetVO::getItemCode)
                        .filter(Objects::nonNull)
                        .collect(Collectors.toList()));

        List<Long> spuIds = spus.stream().map(BipItemDO::getId).filter(Objects::nonNull).collect(Collectors.toList());

        if (CollUtil.isEmpty(spuIds)) {
            return ApiResult.ok(Collections.emptyList());
        }

        var items = jpaQueryFactory.select(Projections.bean(BipItemListAppRespVO.class,
                ITEM_DO.id,
                ITEM_DO.mainPicFileCode.as("picFileCode"),
                ITEM_DO.mainPicUrl.as("picUrl"),
                ITEM_DO.title,
                ITEM_DO.itemId,
                ITEM_DO.price,
                ITEM_DO.numSale,
                ITEM_DO.numSale90,
                ITEM_DO.rateEvalGood,
                ITEM_DO.scoreEval
        )).from(ITEM_DO)
                .where(ITEM_DO.id.in(spuIds))
                .fetch();

        // 设置支撑域商品
        setSupportItem(items);

        Long userId = currentUserId();
        // 获取最小价格
        setMinPrice(items, userId, offsetVOS.get(0).getOuId());

        return ApiResult.ok(items);
    }

    @Override
    public ApiResult<List<BipItemRecommendAppRespVO>> queryForAppRecommend(BipItemRecommendAppQueryParamVO queryParamVO) {
        if (queryParamVO.getBipItemId() == null) {
            return ApiResult.ok(Collections.emptyList());
        }

        // 查询商品的分类
        var itemCategory = itemRepoProc.getItemCategory(queryParamVO.getBipItemId());
        if (itemCategory == null) {
            return ApiResult.ok(Collections.emptyList());
        }

        // 查询同类商品
        var size = ObjectUtil.defaultIfNull(queryParamVO.getSize(), 2);
        var respVoList = searchForRecommendByDb(itemCategory.getCategoryId3(), 3, queryParamVO.getBipItemId(), size);
        if (respVoList.size() < size) {
            // 数量不够时，依次扩大类别
            var respVOMap = respVoList.stream().collect(Collectors.toMap(BipItemRecommendAppRespVO::getId, t -> t, (t1, t2) -> t1));
            var respVoListTemp = searchForRecommendByDb(itemCategory.getCategoryId2(), 2, queryParamVO.getBipItemId(), size);
            if (CollUtil.isNotEmpty(respVoListTemp)) {
                for (var temp : respVoListTemp) {
                    respVOMap.put(temp.getId(), temp);
                }
            }

            respVoListTemp = searchForRecommendByDb(itemCategory.getCategoryId1(), 1, queryParamVO.getBipItemId(), size);
            if (CollUtil.isNotEmpty(respVoListTemp)) {
                for (var temp : respVoListTemp) {
                    respVOMap.put(temp.getId(), temp);
                }
            }
            respVoList = new ArrayList<>(respVOMap.values());
        }

        // 获取客户价格
        if (respVoList.isEmpty()) {
            return ApiResult.ok(respVoList);
        }
        var userId = currentUserId();

        // 设置支撑域商品
        setSupportItem(respVoList);
        // 获取客户价格
        setMinPrice(respVoList, userId, queryParamVO.getOuId());

        for (var item : respVoList) {
            item.setGiftFlag(false);
            item.setOffsetFlag(false);
            var discountGift = findDiscountGift(item.getId(), queryParamVO.getOuId());
            if (discountGift!=null && discountGift.size()>0){
                item.setGiftFlag(true);
            }
            var discountOffset = findDiscountOffset(item.getId(), queryParamVO.getOuId());
            if (discountOffset!=null && discountOffset.size()>0){
                item.setOffsetFlag(true);
            }
        }

        return ApiResult.ok(respVoList);
    }

    @Override
    public ApiResult<PagingVO<BipItemHotAppRespVO>> queryForAppHot(Long ouId) {
        //热销商品 只取前10条
        Assert.notNull(ouId,"公司ID不能为空");
        var respVo = searchForHotByDb(ouId);

        if (respVo == null || respVo.getRecords() == null || respVo.getRecords().isEmpty()) {
            return ApiResult.ok(respVo);
        }

        var user = UserService.currentUser();
        Long userId = user == null ? null : user.getUserId();

        // 设置支撑域商品
        setSupportItem(respVo.getRecords());
        // 获取最小价格
        setMinPrice(respVo.getRecords(), userId, ouId);

        return ApiResult.ok(respVo);
    }

    private void setSupportItem(List<? extends BaseBipItemAppRespVO> vos) {
//        for (var vo : vos) {
//            List<BipItemSkuDO> skuDOList = bipItemSkuRepo.findByBipItemIdInAndFreeze(Collections.singletonList(vo.getId()), false);
//
//            if (skuDOList.size()==0) continue;
//
//            ItmItemRpcDtoParam codeparam = new ItmItemRpcDtoParam();
//            codeparam.setItemCodes(skuDOList.stream().map(BipItemSkuDO::getSkuCode).collect(Collectors.toList()));
//            List<ItmItemRpcDTO> dtos = new ArrayList<>(rmiItemService.findItemListByParam(codeparam));
//            if (dtos.size() == 0) {
//                throw new BusinessException("查询商品价格时，未在支撑域找到该商品：" + JSON.toJSONString(skuDOList));
//            }
//
//            vo.setCurrCode("CNY");
//            List<SupportItem> supportItems = new ArrayList<>();
//            for (ItmItemRpcDTO dto : dtos) {
//                SupportItem supportItem = SupportItem
//                        .builder()
//                        .id(dto.getId())
//                        .uom(dto.getUom())
//                        .build();
//
//                supportItems.add(supportItem);
//            }
//            vo.setSupportItems(supportItems);
//        }

    }

    /**
     * 设置最低价格
     *
     * @param respVOList 商品所在列表
     * @param userId     用户id
     */
    private void setMinPrice(List<? extends BaseBipItemAppRespVO> respVOList, Long userId, Long ouId) {
        CustDTO cust = custUserBindService.getCustOfUserBind(userId).getData();
        for (var resp : respVOList) {
            // 客户价格
            if (cust != null && StringUtils.isNotBlank(cust.getCustLevel())) {
                PriSalePriceTypeQueryParam param = new PriSalePriceTypeQueryParam();
                param.setPriceType(UdcEnum.PRI_SALE_PRICE_TYPE_GROUP.getValueCode());
                param.setCustLevel(cust.getCustLevel());
                param.setCurrCode(resp.getCurrCode());
                param.setOuId(cust.getOuId());

                // 设置最小客户等级价格
                resp.getSupportItems()
                        .stream()
                        .map(item -> {
                            param.setItemId(item.getId());
                            param.setUom(item.getUom());

                            PriSalePriceTypeRespVO vo = salePriceService.queryPrice(param);

                            log.info("商品最小客户等级价格：" + JSON.toJSONString(vo));

                            return vo;
                        })
                        .filter(Objects::nonNull)
                        .map(PriSalePriceTypeRespVO::getPrice)
                        .min(BigDecimal::compareTo)
                        .ifPresentOrElse(resp::setPriceCust,()->resp.setPriceCust(null));

            }

            // 基础价格 使用前端传过来的ouId
            PriSalePriceTypeQueryParam param = new PriSalePriceTypeQueryParam();
            param.setPriceType(UdcEnum.PRI_SALE_PRICE_TYPE_BASE.getValueCode());
            Assert.notNull(ouId, "商品查询基础价格时，公司ID不能为空！");
            param.setOuId(ouId);
            param.setCurrCode(resp.getCurrCode());
            param.setCustLevel(null);

            // 设置最小基础价格
            resp.getSupportItems()
                    .stream()
                    .map(item->{
                        param.setItemId(item.getId());
                        param.setUom(item.getUom());

                        PriSalePriceTypeRespVO vo = salePriceService.queryPrice(param);

                        log.info("商品最小基础价格：" + JSON.toJSONString(vo));

                        return vo;
                    })
                    .filter(Objects::nonNull)
                    .map(PriSalePriceTypeRespVO::getPrice)
                    .min(BigDecimal::compareTo)
                    .ifPresentOrElse(resp::setPrice,()->resp.setPrice(null));
        }
    }


    /**
     * 查询Sku客户等级价
     *
     * @param skuCode sku编号
     * @param userId  用户id
     * @return 等级价
     */
    private Map<String, BigDecimal> findSkuCustPriceReMap(String skuCode, Long userId, Long ouId) {
//        Map<String, BigDecimal> map = new HashMap<>();
//        log.info("查询商品详情SKU价格入参：" + skuCode + " " + userId);
//
//        if (StringUtils.isBlank(skuCode)) {
//            throw new BusinessException("查询商品详情价格时SkuCode不能为空！");
//        }
//
//        CustDTO cust = custUserBindService.getCustOfUserBind(userId).getData();
//
//        // 查询支撑域商品ID和单位
//        ItmItemRpcDtoParam codeParam = new ItmItemRpcDtoParam();
//        codeParam.setItemCodes(Collections.singletonList(skuCode));
//        List<ItmItemRpcDTO> dtos = new ArrayList<>(rmiItemService.findItemListByParam(codeParam));
//        if (dtos.size() == 0) {
//            throw new BusinessException("查询商品详情价格时，未在支撑域找到该商品：" + JSON.toJSONString(skuCode));
//        }
//        ItmItemRpcDTO dto = dtos.get(0);
//
//        if (cust != null) {
//            // 客户等级价格
//            PriSalePriceTypeQueryParam param = new PriSalePriceTypeQueryParam();
//            param.setPriceType(UdcEnum.PRI_SALE_PRICE_TYPE_GROUP.getValueCode());
//            param.setCustLevel(cust.getCustLevel());
//            param.setCurrCode("CNY");
//            param.setOuId(cust.getOuId());
//            param.setItemId(dto.getId());
//            param.setUom(dto.getUom());
//
//            // 客户等级价格
//            PriSalePriceTypeRespVO priceResult = null;
//            if (StringUtils.isNotBlank(cust.getCustLevel())) {
//                log.info("商品详情等级价格入参：" + skuCode + " ouId:" + cust.getOuId() + " 价格查询参数" + JSON.toJSONString(param));
//                priceResult = salePriceService.queryPrice(param);
//                log.info("商品详情等级价格：" + skuCode + " ouId:" + cust.getOuId() + " 价格信息" + JSON.toJSONString(priceResult));
//            }
//
//            BigDecimal custPrice = priceResult == null ? null : priceResult.getPrice();
//
//            map.put("custPrice", custPrice);
//        }
//
//        // 基础价格
//        PriSalePriceTypeQueryParam param2 = new PriSalePriceTypeQueryParam();
//        param2.setPriceType(UdcEnum.PRI_SALE_PRICE_TYPE_BASE.getValueCode());
//        param2.setCurrCode("CNY");
//        param2.setOuId(ouId);
//        param2.setItemId(dto.getId());
//        param2.setUom(dto.getUom());
//        log.info("商品详情基础价格入参：" + skuCode + " ouId:" + ouId + " 价格查询参数" + JSON.toJSONString(param2));
//        PriSalePriceTypeRespVO priceResult2 = salePriceService.queryPrice(param2);
//        log.info("商品详情基础价格：" + skuCode + " ouId:" + ouId + " 价格信息" + JSON.toJSONString(priceResult2));
//
//        if (priceResult2 == null || priceResult2.getPrice() == null) {
//            throw new BusinessException("查询商品详情价格时，商品：" + skuCode + " 基础价格为空");
//        }
//
//        BigDecimal basePrice = priceResult2.getPrice();
//        map.put("basePrice", basePrice);
//
//        return map;
        return null;
    }

    private List<MktDiscountGiftVO> findDiscountGift(Long bipItemId, Long ouId){
        var skuDOList = itemSkuRepoProc.queryByBipItemIdFreeze(bipItemId);
        List<Long> skuIds = skuDOList.stream().map(BipItemSkuDO::getId).collect(Collectors.toList());

        Long userId = currentUserId();
        CustDTO cust = custUserBindService.getCustOfUserBind(userId).getData();

        String custLevel = cust==null ? null : cust.getCustLevel();

        QMktGiftDO qMktGiftDO = QMktGiftDO.mktGiftDO;
        QMktDiscountGiftDDO qMktDiscountGiftDDO = QMktDiscountGiftDDO.mktDiscountGiftDDO;

        return mktDiscountGiftRepoProc
                .findMktDisCountGift(ouId, custLevel, LocalDateTime.now(), skuIds)
                .leftJoin(qMktGiftDO)
                .on(qMktDiscountGiftDDO.discountGiftCode.eq(qMktGiftDO.discountGiftCode))
                .where(qMktGiftDO.validStime.loe(LocalDateTime.now())
                        .and(qMktGiftDO.validEtime.goe(LocalDateTime.now()))
                        .and(qMktGiftDO.stockNowNum.gt(0)))
                .fetch();

    }

    private List<MktDiscountOffsetVO> findDiscountOffset(Long bipItemId, Long ouId){
        var skuDOList = itemSkuRepoProc.queryByBipItemIdFreeze(bipItemId);
        List<Long> skuIds = skuDOList.stream().map(BipItemSkuDO::getId).collect(Collectors.toList());

        Long userId = currentUserId();
        CustDTO cust = custUserBindService.getCustOfUserBind(userId).getData();

        String custLevel = cust==null ? null : cust.getCustLevel();

        return mktDiscountOffsetRepoProc.findMktDisCountOffsetByLQ(ouId, custLevel, LocalDateTime.now(), skuIds).fetch();
    }


    @Override
    public ApiResult<List<BipItemRecGoodAppRespVO>> queryForRecGood(Long ouId, Integer size) {
        size = ObjectUtil.defaultIfNull(size, 10);
        var respVoList = searchForRecGoodByDb(ouId, size);
        if (respVoList.isEmpty()) {
            return ApiResult.ok(respVoList);
        }

        var userId = currentUserId();

        // 查询最低价格
        setMinPrice(respVoList, userId, ouId);

        return ApiResult.ok(respVoList);
    }

    @Override
    public ApiResult<BipItemDetailAppRespVO> getDetail(Long id, Long ouId) {
        var item = itemRepo.findById(id).orElse(null);
        if (item == null || BooleanUtil.isFalse(item.getOnShelf())) {
            return ApiResult.fail("商品已失效");
        }
        // 扩展信息
        var itemExt = itemExtRepo.findById(item.getExtId()).orElseThrow(new BusinessException("系统繁忙，请稍后再试"));
        Long userId = currentUserId();

        var respVO = new BipItemDetailAppRespVO();
        // 设置商品的基本信息
        fillBase(respVO, item);
        // 设置商品图片
        fillPic(respVO, item);
        // 设置商品sku属性信息
        respVO.setAttr(getItemAttr(item.getId()));
        // 设置商品的扩展信息
        fillExt(respVO, itemExt);
        // 设置价格
        fillPrice(respVO, userId, ouId);
        // 显示赠品信息
        fillGiftList(respVO);

        return ApiResult.ok(respVO);
    }

    /**
     * 商品详情填充价格
     *
     * @param respVO 商品详情
     * @param userId 用户id
     * @param ouId   公司id
     */
    private void fillPrice(BipItemDetailAppRespVO respVO, Long userId, Long ouId) {

        BaseBipItemAppRespVO vo = new BaseBipItemAppRespVO();
        vo.setId(respVO.getId());
        // 设置支撑域商品
        setSupportItem(Collections.singletonList(vo));

        for (BipItemAttrAppRespVO.Sku sku : respVO.getAttr().getSkuList()) {
            Map<String, BigDecimal> prices = findSkuCustPriceReMap(sku.getSkuCode(), userId, ouId);
            if (null != prices.get("basePrice")) {
                sku.setPrice(prices.get("basePrice"));
            }
            if (null != prices.get("custPrice")) {
                sku.setPriceCust(prices.get("custPrice"));
            }
        }

        // 设置最小基础价格
        respVO.getAttr().getSkuList()
                .stream()
                .map(BipItemAttrAppRespVO.Sku::getPrice)
                .filter(Objects::nonNull)
                .min(BigDecimal::compareTo)
                .ifPresentOrElse(respVO::setPrice,()->respVO.setPrice(null));

        // 设置最小客户等级价格
        respVO.getAttr().getSkuList()
                .stream()
                .map(BipItemAttrAppRespVO.Sku::getPriceCust)
                .filter(Objects::nonNull)
                .min(BigDecimal::compareTo)
                .ifPresentOrElse(respVO::setPriceCust,()->respVO.setPriceCust(null));

    }

    @Override
    public ApiResult<BipItemAttrAppRespVO> getItemSku(Long id) {
        if (id == null) {
            return ApiResult.fail("商品的标识为空");
        }

        var sku = getItemAttr(id);
        return ApiResult.ok(sku);
    }

    @Override
    public ApiResult<List<BipReceiptAddrAppRespVO>> queryReceiptAddr() {
//        var user = SecurityContextUtil.currentUser();
//        if (user == null) {
//            return ApiResult.fail("登录超时，请重新登录");
//        }
//        // 查询用户关联的客户
//        var custId = custUserBindService.getCustIdByUserId(user.getUser().getId()).getData();
//        if (custId == null) {
//            return ApiResult.fail("请先绑定公司");
//        }
//
//        // 根据用户获取所属客户的地址
//        var addrs = queryAddrByCust(custId);
//        return ApiResult.ok(addrs);
        return null;
    }

    /**
     * 支付成功后的操作 在支付成功回调时候调用  用来更新商品总销量
     *
     * @param docNo
     */
    @Override
    public void updateItemSalNumAll(String docNo) {
        //查询订单
        QBipOrderDO qBipOrderDO = QBipOrderDO.bipOrderDO;
        BooleanExpression expression = qBipOrderDO.docNo.eq(docNo);
        Optional<BipOrderDO> optional = bipOrderRepo.findOne(expression);
        log.info("-----------订单编号-----------------------", docNo);
        if (optional.isPresent()) {
            log.info("-----------更新商品销量订单编号-----------------------", docNo);
            BipOrderDO bipOrderDO = optional.get();
            Long orderId = bipOrderDO.getId();
            //查询订单明细
            QBipOrderDDO qBipOrderDDO = QBipOrderDDO.bipOrderDDO;
            BooleanExpression detailExpr = qBipOrderDDO.orderId.eq(orderId);
            Iterable<BipOrderDDO> iterables = bipOrderDRepo.findAll(detailExpr);
            if (!IterUtil.isEmpty(iterables)) {
                List<BipOrderDDO> detailList = Lists.newArrayList(iterables);
                detailList.stream().forEach(d -> {
                    //取出订单详情里面的商品ID和ouId和数量 通过商品ID和ouID查询商品信息  把数量加到商品总销量
                    Long ouId = bipOrderDO.getOuId();
                    Long itemId = d.getItemId();
                    Long buyQty = d.getBuyQty();
                    QBipItemDO qBipItemDO = QBipItemDO.bipItemDO;
                    BooleanExpression itemExpr = qBipItemDO.ouId.eq(ouId).and(qBipItemDO.id.eq(itemId));
                    Optional<BipItemDO> itemOption = itemRepo.findOne(itemExpr);
                    log.info("-----------查询订单商品-----------------------");
                    if (!itemOption.isEmpty()) {
                        BipItemDO bipItemDO = itemOption.get();
                        log.info("-----------商品信息-----------------------" + JSON.toJSONString(bipItemDO));
                        Long salNum = bipItemDO.getNumSale();
                        if (null != salNum && null != buyQty) {
                            bipItemDO.setNumSale(salNum + buyQty);
                            itemRepo.save(bipItemDO);
                            log.info("-----------更新商品销量信息成功-----------------------");
                        }
                    }
                });
            }
        }
    }

    private Long obtainOuId(Long ouId) {
        if (ouId != null) {
            return ouId;
        }
        var userId = currentUserId();
        if (userId == null) {
            return null;
        }

        // 查询用户绑定的公司ID
        var custInfo = custUserBindService.getCustOfUserBind(userId);
        return custInfo.getData().getOuId();
    }

    private void fillGiftList(BipItemDetailAppRespVO respVO) {
        List<Long> itemIds = new ArrayList<>();
        itemIds.add(respVO.getId());
        List<BipGiftVO> giftList = mktDiscountGiftRepoProc.getGiftListByCode(null, itemIds).fetch();
        if (giftList != null && giftList.size() > 0) {
            respVO.setGiftList(giftList);
        }
    }

    private List<BipReceiptAddrAppRespVO> queryAddrByCust(Long custId) {
        // 先获取地址号
        var addrNo = custRepoProc.getAddrNo(custId);
        if (addrNo == null) {
            return Collections.emptyList();
        }

        // 根据地址号获取地址信息
        var addrQueryParm = new OrgAddressRpcDtoParam();
        addrQueryParm.setAddrNos(ListUtil.toList(addrNo));
        var addrResult = rmiOrgAddrService.findAddrAddressListByParam(addrQueryParm);
        if (CollUtil.isEmpty(addrResult)) {
            return Collections.emptyList();
        }

        return addrResult.stream().map(t -> {
            var vo = new BipReceiptAddrAppRespVO();
            vo.setId(t.getId());
            vo.setDef(BooleanUtil.isTrue(t.getDefaultFlag()));
            vo.setUsername(t.getContPerson());
            vo.setPhone(t.getMobile());
            vo.setProvince(t.getProvince());
            vo.setProvinceName(t.getProvinceName());
            vo.setCity(t.getCity());
            vo.setCityName(t.getCityName());
            vo.setCounty(t.getCounty());
            vo.setCountyName(t.getCountyName());
            vo.setStreet(t.getStreet());
            vo.setStreetName(t.getAddrName());
            vo.setAddress(t.getDetailAddr());

            return vo;
        }).collect(Collectors.toList());
    }

    private void fillBase(BipItemDetailAppRespVO respVO, BipItemDO itemDO) {
        respVO.setId(itemDO.getId());
        respVO.setItemId(itemDO.getItemId());
        respVO.setTitle(itemDO.getTitle());
        respVO.setPrice(itemDO.getPrice());
        respVO.setNumSale90(itemDO.getNumSale90());
        respVO.setNumSale(itemDO.getNumSale());
    }

    private void fillPic(BipItemDetailAppRespVO respVO, BipItemDO itemDO) {
        var picDOList = itemPicRepoProc.queryByBipItemId(itemDO.getId());
        if (picDOList.isEmpty()) {
            respVO.setPicList(Collections.emptyList());
            return;
        }

        var picList = picDOList.stream().map(t -> {
            var vo = CONVERT.itemPic2RespVO(t);
            vo.setImage(isImage(t.getMimeType()));
            return vo;
        }).collect(Collectors.toList());
        respVO.setPicList(picList);
    }

    private boolean isImage(String mimeType) {
        return mimeType != null && mimeType.toLowerCase().startsWith("image/");
    }

    private BipItemAttrAppRespVO getItemAttr(Long bipItemId) {
        var skuDOList = itemSkuRepoProc.queryByBipItemIdFreeze(bipItemId);
        var attr = new BipItemAttrAppRespVO();

        if (skuDOList.isEmpty()) {
            attr.setAttrList(Collections.emptyList());
            attr.setSkuList(Collections.emptyList());
            return attr;
        }

        // SKU列表
        List<BipItemAttrAppRespVO.Sku> skuList = skuDOList.stream().map(t -> {
            var vo = CONVERT.skuDO2VO(t);
            vo.setAttrList(convert2List(t.getAttr(), BipItemSkuAttrRespVO.class));
            return vo;
        }).filter(t -> (!t.getFreeze())).collect(Collectors.toList());
        //查询首单价格
        var item = itemRepo.findById(bipItemId).orElse(null);
        QFirstSpecialDO qFirstSpecialDO = QFirstSpecialDO.firstSpecialDO;
        BooleanExpression expression = qFirstSpecialDO.deleteFlag.eq(0)
                .and(qFirstSpecialDO.itemId.eq(bipItemId))
                .and(qFirstSpecialDO.ouId.eq(item.getOuId()))
                .and(qFirstSpecialDO.status.eq("ACTIVE"));
        Optional<FirstSpecialDO> optional = firstSpecialRepo.findOne(expression);
        if (optional.isPresent()) {
            FirstSpecialDO firstSpecialDO = optional.get();
            QFirstSpecialItemDO qFirstSpecialItemDO = QFirstSpecialItemDO.firstSpecialItemDO;
            BooleanExpression expr = qFirstSpecialItemDO.specialId.eq(firstSpecialDO.getId()).and(qFirstSpecialItemDO.deleteFlag.eq(0));
            Iterable<FirstSpecialItemDO> speItems = firstSpecialItemRepo.findAll(expr);
            if (!IterUtil.isEmpty(speItems)) {
                List<FirstSpecialItemDO> speItemList = Lists.newArrayList(speItems);
                skuList.stream().forEach(sku -> {
                    for (FirstSpecialItemDO itemDO : speItemList) {
                        if (sku.getId().equals(itemDO.getSkuId())) {
                            sku.setPreferentialPrice(itemDO.getPreferentialPrice());
                        }
                    }
                });
            }
        }
        if (!skuList.isEmpty()) {
            for (var sku : skuList) {
                if (null != sku.getAttrList() && !sku.getAttrList().isEmpty()) {
                    String skuStr = JSON.toJSONString(sku.getAttrList());
                    List<BipItemSkuAttrRespVO> skuArray = JSON.parseArray(skuStr, BipItemSkuAttrRespVO.class);
                    List<BipItemSkuAttrRespVO> skuAttrs = skuArray.stream().sorted(Comparator.comparing(BipItemSkuAttrRespVO::getCode)).collect(Collectors.toList());
                    // List<BipItemSkuAttrRespVO> skuAttrs = sku.getAttrList().stream().sorted(Comparator.comparing(BipItemSkuAttrRespVO::getCode)).collect(Collectors.toList());
                    sku.setAttrList(skuAttrs);
                }
            }
        }

        attr.setSkuList(skuList);
        // 组合所有的属性
        var attrList = skuList.stream().flatMap(t -> objectMapper.convertValue(t.getAttrList(), new TypeReference<List<BipItemSkuAttrRespVO>>() {
        }).stream())
                .collect(Collectors.groupingBy(BipItemSkuAttrRespVO::getCode))
                .entrySet()
                .stream()
                .map(entry -> {
                    var v = new BipItemAttrAppRespVO.Attr();
                    v.setCode(entry.getKey());
                    v.setName(entry.getValue().get(0).getName());
                    v.setValueList(entry.getValue().stream().map(BipItemSkuAttrRespVO::getValue).distinct().collect(Collectors.toList()));

                    return v;
                }).collect(Collectors.toList());

        List<BipItemAttrAppRespVO.Attr> attrs = new ArrayList<>();
        if (attrList != null && attrList.size() > 0) {
            attrs = attrList.stream().sorted(Comparator.comparing(BipItemAttrAppRespVO.Attr::getCode)).collect(Collectors.toList());
        }
        attr.setAttrList(attrs);

        return attr;
    }

    private void fillExt(BipItemDetailAppRespVO respVO, BipItemExtDO extDO) {
        // 商品参数
        respVO.setSpecList(convert2List(extDO.getSpec(), BipItemSpecRespVO.class));
        // 内容详情图片
        respVO.setContentPicList(convert2List(extDO.getContent(), BipItemPicAppRespVO.class));
    }

    private List<BipItemRecGoodAppRespVO> searchForRecGoodByDb(Long ouId, Integer size) {
        ouId = obtainOuId(ouId);
        var condition = ouId == null ? ITEM_DO.onShelf.eq(true) : ITEM_DO.ouId.eq(ouId).and(ITEM_DO.onShelf.eq(true));
        return jpaQueryFactory.select(Projections.bean(BipItemRecGoodAppRespVO.class,
                ITEM_DO.id,
                ITEM_DO.mainPicFileCode.as("picFileCode"),
                ITEM_DO.mainPicUrl.as("picUrl"),
                ITEM_DO.title,
                ITEM_DO.price
        )).from(ITEM_DO)
                .where(condition)
                .limit(size)
                .orderBy(new OrderSpecifier[]{ITEM_DO.numSale90.desc()})
                .fetch();
    }

    private PagingVO<BipItemHotAppRespVO> searchForHotByDb(Long ouId) {

        var query = jpaQueryFactory.select(Projections.bean(BipItemHotAppRespVO.class,
                    ITEM_DO.id,
                    ITEM_DO.mainPicFileCode.as("picFileCode"),
                    ITEM_DO.mainPicUrl.as("picUrl"),
                    ITEM_DO.title,
                    ITEM_DO.price
                )).from(ITEM_DO)
                .where(ITEM_DO.ouId.eq(ouId).and(ITEM_DO.onShelf.eq(true)));

        var total = query.fetchCount();

        var records = query
                .orderBy(ITEM_DO.numSale90.desc())
                .limit(10)
                .fetch();
        return PagingVO.<BipItemHotAppRespVO>builder().total(total).records(records).build();
    }

    private List<BipItemRecommendAppRespVO> searchForRecommendByDb(Long categoryId, Integer categoryLevel, Long excludeItemId, Integer size) {
        NumberPath<Long> categoryIdPath = itemRepoProc.getCategory(categoryLevel);

        return jpaQueryFactory.select(Projections.bean(BipItemRecommendAppRespVO.class,
                ITEM_DO.id,
                ITEM_DO.mainPicFileCode.as("picFileCode"),
                ITEM_DO.mainPicUrl.as("picUrl"),
                ITEM_DO.title,
                ITEM_DO.price
        )).from(ITEM_DO)
                .where(categoryIdPath.eq(categoryId)
                        .and(ITEM_DO.ouId.eq(JPAExpressions.select(ITEM_DO.ouId).from(ITEM_DO).where(ITEM_DO.id.eq(excludeItemId))))
                        .and(ITEM_DO.onShelf.eq(true))
                        .and(ITEM_DO.id.ne(excludeItemId))
                ).limit(size)
                .fetch();
    }

    private PagingVO<BipItemListAppRespVO> searchForAppByDB(BipItemAppQueryParamVO queryParamVO) {
        var ouId = obtainOuId(queryParamVO.getOuId());

        // 必须是已上架的
        Predicate condition = ouId == null ? ITEM_DO.onShelf.eq(true) : ITEM_DO.ouId.eq(ouId).and(ITEM_DO.onShelf.eq(true));
        if (StrUtil.isNotBlank(queryParamVO.getKeyword())) {
            var keyword = "%" + queryParamVO.getKeyword() + "%";
            condition = ExpressionUtils.and(condition, ITEM_DO.title.like(keyword).or(ITEM_DO.categoryName3.like(keyword)));
        }

        var jpaQuery = jpaQueryFactory.select(Projections.bean(BipItemListAppRespVO.class,
                ITEM_DO.id,
                ITEM_DO.mainPicFileCode.as("picFileCode"),
                ITEM_DO.mainPicUrl.as("picUrl"),
                ITEM_DO.title,
                ITEM_DO.itemId,
                ITEM_DO.price,
                ITEM_DO.numSale,
                ITEM_DO.numSale90,
                ITEM_DO.rateEvalGood,
                ITEM_DO.scoreEval
                )
        )
                .from(ITEM_DO)
                .where(condition);
        var count = jpaQuery.fetchCount();
        var order = obtainOrder(queryParamVO);

        var dataList = jpaQuery
                .orderBy(order)
                .offset((queryParamVO.getCurrent() - 1) * queryParamVO.getSize())
                .limit(queryParamVO.getSize())
                .fetch();
        return PagingVO.<BipItemListAppRespVO>builder().total(count).records(dataList).build();
    }

    private OrderSpecifier[] obtainOrder(BipItemAppQueryParamVO queryParamVO) {
        if (queryParamVO.getOrderSaleDesc() != null) {
            // 根据近90天的销量排序
            return new OrderSpecifier[]{new OrderSpecifier(queryParamVO.getOrderSaleDesc() ? Order.DESC : Order.ASC, ITEM_DO.numSale90)};
        }
        if (queryParamVO.getOrderPriceDesc() != null) {
            // 根据价格排序
            return new OrderSpecifier[]{new OrderSpecifier(queryParamVO.getOrderPriceDesc() ? Order.DESC : Order.ASC, ITEM_DO.price)};
        }

        // 默认根据上架时间排序
        return new OrderSpecifier[]{new OrderSpecifier(Order.DESC, ITEM_DO.timeOnShelf)};
    }
}
