package com.elitesland.yst.production.sale.task.delay;

import com.elitesland.yst.production.sale.api.service.shop.BipItemMngService;
import com.elitescloud.cloudt.core.task.delay.DelayTaskHandler;
import com.elitescloud.cloudt.core.task.delay.TaskInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 商品定时上线任务.
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/27
 */
@Component
@Slf4j
public class BipItemTimingOnShelfTask implements DelayTaskHandler<Long> {

    public static final String TASK_TYPE = "bip_item_onShelf";
    private final BipItemMngService bipItemMngService;

    public BipItemTimingOnShelfTask(BipItemMngService bipItemMngService) {
        this.bipItemMngService = bipItemMngService;
    }

    @Override
    public String[] supportType() {
        return new String[]{TASK_TYPE};
    }

    @Override
    public boolean execute(TaskInfo<Long> taskInfo) {
        var itemId = taskInfo.getPayload();

        log.info("商品【{}】定时上线", itemId);
        var res = bipItemMngService.updateOnShelfByTask(itemId);
        log.info("商品【{}】定时上线结果：{}", itemId, res);
        return true;
    }
}
