/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.controller.shop;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.sale.api.service.shop.BipItemCategoryService;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemCategoryRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.ItemCatTreeAllRespVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemCategorySaveVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5546\u54c1\u5206\u7c7b"})
@ApiSupport(author="Kaiser\uff08wang shao\uff09")
@RestController
@RequestMapping(value={"/bip/itemCat"}, produces={"application/json"})
public class BipItemCategoryController
extends BaseController {
    private final BipItemCategoryService categoryService;

    public BipItemCategoryController(BipItemCategoryService categoryService) {
        this.categoryService = categoryService;
    }

    @ApiOperation(value="\u5546\u54c1\u5206\u7c7b\u6811\u5f62\u6570\u636e\u83b7\u53d6")
    @ApiOperationSupport(order=0)
    @ApiImplicitParams(value={@ApiImplicitParam(name="ouId", value="\u6240\u5c5e\u516c\u53f8")})
    @GetMapping(value={"/tree"})
    public ApiResult<List<ItemCatTreeAllRespVO>> tree(Long ouId) {
        return ouId == null ? this.categoryService.treeAll() : this.categoryService.treeAll(ouId);
    }

    @ApiOperation(value="\u5546\u54c1\u5206\u7c7b\u4fdd\u5b58")
    @ApiOperationSupport(order=1)
    @PostMapping(value={""})
    public ApiResult<Long> save(@RequestBody @Valid BipItemCategorySaveVO saveVO) {
        return this.categoryService.save(saveVO);
    }

    @ApiOperation(value="\u5546\u54c1\u5206\u7c7b\u4fee\u6539")
    @ApiOperationSupport(order=2)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5206\u7c7bID")})
    @PutMapping(value={"/{id}"})
    public ApiResult<Long> update(@PathVariable Long id, @RequestBody @Valid BipItemCategorySaveVO saveVO) {
        return this.categoryService.update(saveVO, id);
    }

    @ApiOperation(value="\u5546\u54c1\u5206\u7c7b\u83b7\u53d6")
    @ApiOperationSupport(order=2)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5206\u7c7bID")})
    @GetMapping(value={"/{id}"})
    public ApiResult<BipItemCategoryRespVO> get(@PathVariable Long id) {
        return this.categoryService.get(id);
    }

    @ApiOperation(value="\u5207\u6362\u662f\u5426\u542f\u7528")
    @ApiOperationSupport(order=3)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5206\u7c7bID")})
    @PatchMapping(value={"/{id}/enable"})
    public ApiResult<Long> updateEnable(@PathVariable Long id) {
        return this.categoryService.updateEnable(id);
    }

    @ApiOperation(value="\u5546\u54c1\u5206\u7c7b\u5220\u9664")
    @ApiOperationSupport(order=4)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5206\u7c7bID")})
    @DeleteMapping(value={"/{id}"})
    public ApiResult<Long> delete(@PathVariable Long id) {
        return this.categoryService.delete(id);
    }
}

