/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.core.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class TreeDataUtil<T> {
    private final List<T> dataOriginal;
    private final Function<T, Object> getId;
    private final Function<T, Object> getParentId;
    private final BiConsumer<T, List<T>> setChildren;
    private Comparator<T> comparator;
    private boolean isDefResult;
    Map<Object, List<T>> childrenMappingCustom = null;
    Map<Object, List<TreeData<T>>> childrenMappingDef = null;
    private List<T> resultCustom;
    private List<TreeData<T>> resultDef;

    public TreeDataUtil(List<T> data, Function<T, Object> getId, Function<T, Object> getParentId) {
        this(data, getId, getParentId, null, null);
    }

    public TreeDataUtil(List<T> data, Function<T, Object> getId, Function<T, Object> getParentId, BiConsumer<T, List<T>> setChildren) {
        this(data, getId, getParentId, setChildren, null);
    }

    public TreeDataUtil(List<T> data, Function<T, Object> getId, Function<T, Object> getParentId, BiConsumer<T, List<T>> setChildren, Comparator<T> comparator) {
        this.dataOriginal = data;
        this.getId = getId;
        this.getParentId = getParentId;
        this.setChildren = setChildren;
        this.comparator = comparator;
        this.analyze();
    }

    public List<?> getRoots() {
        return this.isDefResult ? this.resultDef : this.resultCustom;
    }

    public Map<Object, ?> getChildrenMapping() {
        return this.isDefResult ? this.childrenMappingDef : this.childrenMappingCustom;
    }

    private TreeDataUtil<T> analyze() {
        if (CollectionUtils.isEmpty(this.dataOriginal)) {
            return this;
        }
        boolean bl = this.isDefResult = this.setChildren == null;
        if (this.isDefResult) {
            this.analyzeForDef();
        } else {
            this.analyzeForCustom();
        }
        return this;
    }

    private void analyzeForDef() {
        Object tempPId;
        int originalSize = (int)Math.ceil((double)this.dataOriginal.size() / 0.75);
        HashSet<Object> allIds = new HashSet<Object>(originalSize);
        this.childrenMappingDef = new HashMap<Object, List<TreeData<T>>>(originalSize);
        ArrayList<TreeData<T>> resultTemp = new ArrayList<TreeData<T>>();
        for (T t2 : this.dataOriginal) {
            TreeData<T> tempData;
            Object tempId = this.getId.apply(t2);
            tempPId = this.getParentId.apply(t2);
            if (ObjectUtils.isEmpty((Object)tempId)) {
                tempData = new TreeData<T>(tempId, tempPId, t2, new ArrayList(0));
            } else {
                tempData = new TreeData<T>(tempId, tempPId, t2, this.childrenMappingDef.computeIfAbsent(tempId, k -> new ArrayList(16)));
                allIds.add(tempId);
            }
            resultTemp.add(tempData);
            if (!ObjectUtils.isNotEmpty((Object)tempPId)) continue;
            this.childrenMappingDef.computeIfAbsent(tempPId, k -> new ArrayList(16)).add(tempData);
        }
        if (CollectionUtils.isEmpty(allIds)) {
            this.resultDef = new ArrayList<TreeData<T>>(0);
            return;
        }
        this.resultDef = new ArrayList<TreeData<T>>(originalSize);
        for (TreeData treeData : resultTemp) {
            tempPId = this.getParentId.apply(treeData.getData());
            if (!ObjectUtils.isEmpty((Object)tempPId) && allIds.contains(tempPId)) continue;
            this.resultDef.add(treeData);
        }
        if (this.comparator != null) {
            this.childrenMappingDef.values().forEach(t -> t.sort((o1, o2) -> this.comparator.compare(o1.getData(), o2.getData())));
            this.resultDef.sort((o1, o2) -> this.comparator.compare(o1.getData(), o2.getData()));
        }
    }

    private void analyzeForCustom() {
        Object tempPId;
        int originalSize = (int)Math.ceil((double)this.dataOriginal.size() / 0.75);
        HashSet<Object> allIds = new HashSet<Object>(originalSize);
        this.childrenMappingCustom = new HashMap<Object, List<T>>(originalSize);
        for (T t2 : this.dataOriginal) {
            Object tempId = this.getId.apply(t2);
            tempPId = this.getParentId.apply(t2);
            if (ObjectUtils.isEmpty((Object)tempId)) {
                this.setChildren.accept(t2, new ArrayList(0));
            } else {
                this.setChildren.accept(t2, this.childrenMappingCustom.computeIfAbsent(tempId, k -> new ArrayList(0)));
                allIds.add(tempId);
            }
            if (!ObjectUtils.isNotEmpty((Object)tempPId)) continue;
            this.childrenMappingCustom.computeIfAbsent(tempPId, k -> new ArrayList(16)).add(t2);
        }
        if (CollectionUtils.isEmpty(allIds)) {
            this.resultCustom = new ArrayList<T>(0);
            return;
        }
        this.resultCustom = new ArrayList<T>(originalSize);
        for (T d : this.dataOriginal) {
            tempPId = this.getParentId.apply(d);
            if (!ObjectUtils.isEmpty((Object)tempPId) && allIds.contains(tempPId)) continue;
            this.resultCustom.add(d);
        }
        if (this.comparator != null) {
            this.childrenMappingCustom.values().forEach(t -> t.sort(this.comparator));
            this.resultCustom.sort(this.comparator);
        }
    }

    protected static class TreeData<T> {
        private Object id;
        private Object pId;
        private T data;
        private List<TreeData<T>> children;

        public TreeData(Object id, Object pId, T data, List<TreeData<T>> children) {
            this.id = id;
            this.pId = pId;
            this.data = data;
            this.children = children;
        }

        public TreeData() {
        }

        public Object getId() {
            return this.id;
        }

        public void setId(Object id) {
            this.id = id;
        }

        public Object getpId() {
            return this.pId;
        }

        public void setpId(Object pId) {
            this.pId = pId;
        }

        public T getData() {
            return this.data;
        }

        public void setData(T data) {
            this.data = data;
        }

        public List<TreeData<T>> getChildren() {
            return this.children;
        }

        public void setChildren(List<TreeData<T>> children) {
            this.children = children;
        }
    }
}

