/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.core.util.excel.support;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.CellExtra;
import com.alibaba.excel.read.listener.ReadListener;
import com.el.coordinator.core.common.exception.BusinessException;
import com.elitesland.yst.production.sale.core.util.DateTimeUtil;
import com.elitesland.yst.production.sale.core.util.excel.support.ImportDataModel;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

public class DataReadListener
implements ReadListener<Map<Integer, Object>> {
    private Integer attributeRowIndex;
    private List<String> attributeList;
    private Class<?> dataType;
    private Integer dataSize = 10000;
    private Consumer<ImportDataModel> dataConsumer;
    private Integer headIndex;
    private static final ObjectMapper objectMapper = Jackson2ObjectMapperBuilder.json().failOnUnknownProperties(false).deserializerByType(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeUtil.FORMATTER_DATETIME)).deserializerByType(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeUtil.FORMATTER_DATE)).build();
    private Map<Integer, String> attributeMap;
    private Integer dataIndex;
    private List<Object> dataList;
    private boolean finish;

    public DataReadListener() {
        this.init();
    }

    public DataReadListener(Integer attributeRowIndex) {
        this.attributeRowIndex = attributeRowIndex;
        this.init();
    }

    public DataReadListener(List<String> attributeList) {
        this.attributeList = attributeList;
        this.init();
    }

    public void onException(Exception exception, AnalysisContext context) throws Exception {
        throw exception;
    }

    public void invokeHead(Map<Integer, CellData> headMap, AnalysisContext context) {
        if (this.attributeMap == null && this.attributeRowIndex != null && this.attributeRowIndex.intValue() == this.headIndex.intValue() && MapUtil.isNotEmpty(headMap)) {
            this.attributeMap = new HashMap<Integer, String>(headMap.size());
            headMap.forEach((k, v) -> this.attributeMap.put((Integer)k, v.getStringValue()));
        }
        Integer n = this.headIndex;
        this.headIndex = this.headIndex + 1;
    }

    public void invoke(Map<Integer, Object> data, AnalysisContext context) {
        HashMap dataConvert = new HashMap(data.size());
        data.forEach((key, value) -> {
            Integer attr;
            Integer n = attr = this.attributeMap == null ? key : this.attributeMap.get(key);
            if (attr == null) {
                return;
            }
            dataConvert.put(attr, value);
        });
        if (this.dataType == null || this.attributeMap == null) {
            this.dataList.add(dataConvert);
        } else {
            try {
                this.dataList.add(objectMapper.convertValue(dataConvert, this.dataType));
            }
            catch (IllegalArgumentException e) {
                throw new BusinessException("\u8f6c\u6362\u6570\u636e\u81f3bean\u5931\u8d25");
            }
        }
        if (this.dataSize != null && this.dataSize.intValue() == this.dataIndex.intValue()) {
            if (this.dataConsumer != null) {
                this.dataConsumer.accept(new ImportDataModel(false, this.dataList));
            }
            this.dataList.clear();
            this.dataIndex = 0;
        }
        Integer n = this.dataIndex;
        this.dataIndex = this.dataIndex + 1;
    }

    public void extra(CellExtra extra, AnalysisContext context) {
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        if (this.dataConsumer != null) {
            this.dataConsumer.accept(new ImportDataModel(true, this.dataList));
        }
        this.finish = true;
    }

    public boolean hasNext(AnalysisContext context) {
        return true;
    }

    private void init() {
        this.generateAttributeMap();
        this.dataList = new ArrayList<Object>(this.dataSize == null ? 256 : this.dataSize);
        this.dataIndex = 1;
    }

    private void generateAttributeMap() {
        if (CollUtil.isNotEmpty(this.attributeList)) {
            this.attributeMap = new HashMap<Integer, String>(this.attributeList.size());
            int attrIndex = 0;
            for (String attr : this.attributeList) {
                this.attributeMap.put(attrIndex++, attr);
            }
        } else if (this.attributeRowIndex != null && this.attributeRowIndex < 1) {
            throw new BusinessException("\u8bf7\u8bbe\u7f6e\u6709\u6548\u7684\u5c5e\u6027\u53c2\u6570");
        }
        this.headIndex = 1;
    }

    public void setDataType(Class<?> dataType) {
        this.dataType = dataType;
    }

    public void setDataSize(Integer dataSize) {
        if (dataSize == null) {
            return;
        }
        this.dataSize = dataSize;
    }

    public void setDataConsumer(Consumer<ImportDataModel> dataConsumer) {
        this.dataConsumer = dataConsumer;
    }

    public List<Object> getDataList() {
        return this.dataList;
    }

    public boolean isFinish() {
        return this.finish;
    }
}

