/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.repo;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.IterUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.vo.param.salesman.SalesmanInfoQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.salesman.SalesmanInfoSimpleQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.salesman.SalesmanSubordinateQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.salesman.SalesmanSuperiorQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.salesman.SalesmanUnderLingQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.salesman.SalesmanDetailInfoRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.salesman.SalesmanInfoRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.salesman.SalesmanInfoSimpleRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.salesman.SalesmanSuperiorRespVO;
import com.elitesland.yst.production.sale.dto.save.SalesmanUpdateDTO;
import com.elitesland.yst.production.sale.entity.QSalesmanInfoDO;
import com.elitesland.yst.production.sale.entity.QSalesmanRegionDO;
import com.elitesland.yst.production.sale.entity.SalesmanInfoDO;
import com.elitesland.yst.production.sale.repo.SalesmanInfoRepo;
import com.google.common.collect.Lists;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class SalesmanInfoRepoProc
extends BaseRepoProc<SalesmanInfoDO> {
    @Autowired
    private SalesmanInfoRepo salesmanInfoRepo;
    private static final QSalesmanInfoDO Q_SALESMAN_INFO_DO = QSalesmanInfoDO.salesmanInfoDO;

    protected SalesmanInfoRepoProc() {
        super((EntityPathBase)Q_SALESMAN_INFO_DO);
    }

    public JPAQuery<SalesmanInfoRespVO> findSalesmanInfo(SalesmanInfoQueryVO salesmanInfoQueryVO) {
        BooleanExpression booleanExpression;
        QSalesmanRegionDO qSalesmanRegionDO;
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SalesmanInfoRespVO.class, (Expression[])new Expression[]{SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.id, SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanNo, SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanType, SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.ouCode, SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.ouName, SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.name, SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.enableStatus})).from((EntityPath)Q_SALESMAN_INFO_DO);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        SalesmanInfoRepoProc.where(salesmanInfoQueryVO, predicates);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        salesmanInfoQueryVO.fillOrders(jpaQuery, (EntityPathBase)Q_SALESMAN_INFO_DO);
        if (StringUtils.isNotEmpty((CharSequence)salesmanInfoQueryVO.getJurisdiction())) {
            qSalesmanRegionDO = QSalesmanRegionDO.salesmanRegionDO;
            booleanExpression = ((JPQLQuery)((JPQLQuery)JPAExpressions.select((Expression)Expressions.ONE).from(new EntityPath[]{qSalesmanRegionDO}).where(new Predicate[]{qSalesmanRegionDO.masId.eq(SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.id)})).where(new Predicate[]{qSalesmanRegionDO.regionCode.eq((Object)salesmanInfoQueryVO.getJurisdiction())})).exists();
            jpaQuery.where((Predicate)booleanExpression);
        }
        if (CollectionUtil.isNotEmpty((Collection)salesmanInfoQueryVO.getJurisdictions())) {
            qSalesmanRegionDO = QSalesmanRegionDO.salesmanRegionDO;
            booleanExpression = ((JPQLQuery)((JPQLQuery)JPAExpressions.select((Expression)Expressions.ONE).from(new EntityPath[]{qSalesmanRegionDO}).where(new Predicate[]{qSalesmanRegionDO.masId.eq(SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.id)})).where(new Predicate[]{qSalesmanRegionDO.regionCode.in((Collection)salesmanInfoQueryVO.getJurisdictions())})).exists();
            jpaQuery.where((Predicate)booleanExpression);
        }
        return jpaQuery;
    }

    public JPAQuery<SalesmanDetailInfoRespVO> findSalesmanInfoDetail(SalesmanInfoQueryVO salesmanInfoQueryVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SalesmanDetailInfoRespVO.class, (Expression[])new Expression[]{SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.id, SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanNo, SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.ouName, SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanType, SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.enableStatus})).from((EntityPath)Q_SALESMAN_INFO_DO);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        SalesmanInfoRepoProc.where(salesmanInfoQueryVO, predicates);
        if (StringUtils.isNotEmpty((CharSequence)salesmanInfoQueryVO.getJurisdiction())) {
            QSalesmanRegionDO qSalesmanRegionDO = QSalesmanRegionDO.salesmanRegionDO;
            BooleanExpression booleanExpression = ((JPQLQuery)((JPQLQuery)JPAExpressions.select((Expression)Expressions.ONE).from(new EntityPath[]{qSalesmanRegionDO}).where(new Predicate[]{qSalesmanRegionDO.masId.eq(SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.id)})).where(new Predicate[]{qSalesmanRegionDO.regionCode.eq((Object)salesmanInfoQueryVO.getJurisdiction())})).exists();
            jpaQuery.where((Predicate)booleanExpression);
        }
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        salesmanInfoQueryVO.fillOrders(jpaQuery, (EntityPathBase)Q_SALESMAN_INFO_DO);
        salesmanInfoQueryVO.setPaging(jpaQuery);
        return jpaQuery;
    }

    public List<SalesmanInfoSimpleRespVO> simpleQuery(SalesmanInfoSimpleQueryVO param) {
        BooleanExpression expression = Expressions.ONE.eq((Expression)Expressions.ONE);
        if (param.getEnableStatus() != null) {
            expression = ExpressionUtils.and((Predicate)expression, (Predicate)SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.enableStatus.eq((Object)param.getEnableStatus()));
        }
        if (CollUtil.isNotEmpty((Collection)param.getCodes())) {
            expression = ExpressionUtils.and((Predicate)expression, (Predicate)SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanNo.in((Collection)param.getCodes()));
        }
        if (CollUtil.isNotEmpty((Collection)param.getIds())) {
            expression = ExpressionUtils.and((Predicate)expression, (Predicate)SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.id.in((Collection)param.getIds()));
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SalesmanInfoSimpleRespVO.class, (Expression[])new Expression[]{SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanNo, SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.id, SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.enableStatus, SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanType})).from((EntityPath)Q_SALESMAN_INFO_DO)).where((Predicate)expression)).fetch();
    }

    public List<SalesmanInfoDO> getSalesmanByCodes(Set<String> salesmanCodes) {
        BooleanExpression e = SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanNo.in(salesmanCodes).and((Predicate)SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.deleteFlag.eq((Object)0));
        Iterable iterable = this.salesmanInfoRepo.findAll((Predicate)e);
        if (IterUtil.isEmpty((Iterable)iterable)) {
            return new ArrayList<SalesmanInfoDO>();
        }
        return Lists.newArrayList((Iterable)iterable);
    }

    public List<SalesmanInfoDO> findSalesmanAllInfo(SalesmanInfoQueryVO salesmanInfoQueryVO) {
        List salesmanInfoDOS = ((JPAQuery)this.jpaQueryFactory.select((Expression)Q_SALESMAN_INFO_DO).from((EntityPath)Q_SALESMAN_INFO_DO)).fetch();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        SalesmanInfoRepoProc.where(salesmanInfoQueryVO, predicates);
        return salesmanInfoDOS;
    }

    private static void where(SalesmanInfoQueryVO salesmanInfoQueryVO, List<Predicate> predicates) {
        if (StringUtils.isNotBlank((CharSequence)salesmanInfoQueryVO.getSalesman())) {
            predicates.add((Predicate)SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanNo.contains(salesmanInfoQueryVO.getSalesman()).or((Predicate)SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.name.contains(salesmanInfoQueryVO.getSalesman())));
        }
        if (StringUtils.isNotBlank((CharSequence)salesmanInfoQueryVO.getSalesmanCode())) {
            predicates.add((Predicate)SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanNo.contains(salesmanInfoQueryVO.getSalesmanCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)salesmanInfoQueryVO.getOuCode())) {
            predicates.add((Predicate)SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.ouCode.eq((Object)salesmanInfoQueryVO.getOuCode()));
        }
        if (salesmanInfoQueryVO.getEnableStatus() != null) {
            predicates.add((Predicate)SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.enableStatus.eq((Object)salesmanInfoQueryVO.getEnableStatus()));
        }
        if (StringUtils.isNotBlank((CharSequence)salesmanInfoQueryVO.getSalesmanType())) {
            predicates.add((Predicate)SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanType.eq((Object)salesmanInfoQueryVO.getSalesmanType()));
        }
        if (CollUtil.isNotEmpty((Collection)salesmanInfoQueryVO.getCodes())) {
            predicates.add((Predicate)SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanNo.in((Collection)salesmanInfoQueryVO.getCodes()));
        }
    }

    public void changeEnableStatus(Long id, Integer enableStatus) {
        this.jpaQueryFactory.update((EntityPath)Q_SALESMAN_INFO_DO).set(SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.enableStatus, (Object)enableStatus).where(new Predicate[]{SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.id.eq((Object)id)}).execute();
    }

    public JPAQuery<SalesmanSuperiorRespVO> findBySalesmanType(SalesmanSuperiorQueryVO param) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SalesmanSuperiorRespVO.class, (Expression[])new Expression[]{SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.id, SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanNo, SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanType.as("type")})).from((EntityPath)Q_SALESMAN_INFO_DO);
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)param.getUdc())) {
            predicates.add(SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanType.eq((Object)param.getUdc()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getSalesmanNo())) {
            String like = "%" + param.getSalesmanNo() + "%";
            predicates.add(SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanNo.like(like));
        }
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        param.setPaging(jpaQuery);
        param.fillOrders(jpaQuery, (EntityPathBase)Q_SALESMAN_INFO_DO);
        return jpaQuery;
    }

    public JPAQuery<SalesmanInfoRespVO> findByRelateCode(List<String> codes, SalesmanInfoQueryVO salesmanInfoQueryVO) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SalesmanInfoRespVO.class, (Expression[])new Expression[]{SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.id, SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanType, SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.ouName, SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.ouCode, SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanNo, SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.enableStatus})).from((EntityPath)Q_SALESMAN_INFO_DO)).where((Predicate)SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanNo.in(codes));
        salesmanInfoQueryVO.fillOrders(jpaQuery, (EntityPathBase)Q_SALESMAN_INFO_DO);
        salesmanInfoQueryVO.setPaging(jpaQuery);
        return jpaQuery;
    }

    public JPAQuery<SalesmanInfoRespVO> findByRelateCode(List<String> codes, SalesmanSubordinateQueryVO salesmanSubordinateQueryVO) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SalesmanInfoRespVO.class, (Expression[])new Expression[]{SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.id, SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanType, SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.ouName, SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanNo, SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.enableStatus})).from((EntityPath)Q_SALESMAN_INFO_DO)).where((Predicate)SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanNo.in(codes));
        salesmanSubordinateQueryVO.fillOrders(jpaQuery, (EntityPathBase)Q_SALESMAN_INFO_DO);
        salesmanSubordinateQueryVO.setPaging(jpaQuery);
        return jpaQuery;
    }

    public Long updateSalesmanInfo(SalesmanUpdateDTO salesmanUpdateDTO) {
        return this.jpaQueryFactory.update((EntityPath)Q_SALESMAN_INFO_DO).set((Path)SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.fileCode, (Object)salesmanUpdateDTO.getFileCode()).where(new Predicate[]{SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.id.eq((Object)salesmanUpdateDTO.getSalesmanId())}).execute();
    }

    public List<SalesmanInfoDO> getByIdByCodes(List<String> empCodes) {
        BooleanExpression expression = SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanNo.in(empCodes);
        Iterable iterable = this.salesmanInfoRepo.findAll((Predicate)expression);
        if (!IterUtil.isEmpty((Iterable)iterable)) {
            return Lists.newArrayList((Iterable)iterable);
        }
        return new ArrayList<SalesmanInfoDO>();
    }

    public List<SalesmanInfoDO> getByIds(List<Long> ids) {
        BooleanExpression expression = SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.id.in(ids);
        Iterable iterable = this.salesmanInfoRepo.findAll((Predicate)expression);
        if (!IterUtil.isEmpty((Iterable)iterable)) {
            return Lists.newArrayList((Iterable)iterable);
        }
        return new ArrayList<SalesmanInfoDO>();
    }

    public PagingVO<SalesmanInfoDO> getPageByQueryVO(SalesmanUnderLingQueryVO queryVO) {
        BooleanExpression expression = SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanNo.in((Collection)queryVO.getUnderlingCodes()).and((Predicate)SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.deleteFlag.eq((Object)0));
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Q_SALESMAN_INFO_DO).from((EntityPath)Q_SALESMAN_INFO_DO)).where((Predicate)expression);
        if (StringUtils.isNotEmpty((CharSequence)queryVO.getSalemanNoNameLike())) {
            query.where((Predicate)SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanNo.like(queryVO.getSalemanNoNameLike()).or((Predicate)SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.name.like(queryVO.getSalemanNoNameLike())));
        }
        queryVO.fillOrders(query, (EntityPathBase)Q_SALESMAN_INFO_DO);
        queryVO.setPaging(query);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public PagingVO<SalesmanSuperiorRespVO> getSalesmanSelectPage(SalesmanSuperiorQueryVO queryVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SalesmanSuperiorRespVO.class, (Expression[])new Expression[]{SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.id, SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanNo, SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanType.as("type"), SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.name})).from((EntityPath)Q_SALESMAN_INFO_DO);
        BooleanExpression e = SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.deleteFlag.eq((Object)0).and((Predicate)SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.enableStatus.eq((Object)1));
        if (StringUtils.isNotBlank((CharSequence)queryVO.getUdc())) {
            e = e.and((Predicate)SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanType.eq((Object)queryVO.getUdc()));
        }
        if (StringUtils.isNotBlank((CharSequence)queryVO.getSalesmanNo())) {
            e = e.and((Predicate)SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.salesmanNo.contains(queryVO.getSalesmanNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)queryVO.getName())) {
            e = e.and((Predicate)SalesmanInfoRepoProc.Q_SALESMAN_INFO_DO.name.contains(queryVO.getName()));
        }
        jpaQuery.where((Predicate)e);
        queryVO.fillOrders(jpaQuery, (EntityPathBase)Q_SALESMAN_INFO_DO);
        queryVO.setPaging(jpaQuery);
        return PagingVO.builder().total(jpaQuery.fetchCount()).records(jpaQuery.fetch()).build();
    }
}

