/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.repo.shop;

import com.elitesland.yst.production.sale.entity.QBipItemExtDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class BipItemExtRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QBipItemExtDO DO = QBipItemExtDO.bipItemExtDO;

    public BipItemExtRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }

    public void updateToApprove(List<Long> bipItemIds) {
        this.jpaQueryFactory.update((EntityPath)DO).set(BipItemExtRepoProc.DO.timeApproveCreate, (Object)LocalDateTime.now()).setNull(BipItemExtRepoProc.DO.timeOnShelfPlan).setNull(BipItemExtRepoProc.DO.timeOffShelfPlan).where(new Predicate[]{BipItemExtRepoProc.DO.bipItemId.in(bipItemIds)}).execute();
    }

    public void updateToApprove(List<Long> bipItemIds, LocalDateTime timeOnShelfPlan, LocalDateTime timeOffShelfPlan) {
        this.jpaQueryFactory.update((EntityPath)DO).set(BipItemExtRepoProc.DO.timeApproveCreate, (Object)LocalDateTime.now()).set(BipItemExtRepoProc.DO.timeOnShelfPlan, (Object)timeOnShelfPlan).set(BipItemExtRepoProc.DO.timeOffShelfPlan, (Object)timeOffShelfPlan).where(new Predicate[]{BipItemExtRepoProc.DO.bipItemId.in(bipItemIds)}).execute();
    }

    public void updateToApprove(List<Long> bipItemIds, LocalDateTime timeOffShelfPlan) {
        this.jpaQueryFactory.update((EntityPath)DO).set(BipItemExtRepoProc.DO.timeApproveCreate, (Object)LocalDateTime.now()).set(BipItemExtRepoProc.DO.timeOffShelfPlan, (Object)timeOffShelfPlan).where(new Predicate[]{BipItemExtRepoProc.DO.bipItemId.in(bipItemIds)}).execute();
    }

    public void updateToOnShelf(Long id) {
        this.jpaQueryFactory.update((EntityPath)DO).set(BipItemExtRepoProc.DO.timeOnShelfPlan, (Object)null).where(new Predicate[]{BipItemExtRepoProc.DO.id.eq((Object)id)}).execute();
    }

    public void updateToOffShelf(Long id) {
        this.jpaQueryFactory.update((EntityPath)DO).set(BipItemExtRepoProc.DO.timeOffShelfPlan, (Object)null).where(new Predicate[]{BipItemExtRepoProc.DO.id.eq((Object)id)}).execute();
    }

    public void deleteByBipItemId(Long bipItemId) {
        this.jpaQueryFactory.delete((EntityPath)DO).where(new Predicate[]{BipItemExtRepoProc.DO.bipItemId.eq((Object)bipItemId)}).execute();
    }

    public void deleteByBipItemId(List<Long> bipItemIds) {
        this.jpaQueryFactory.delete((EntityPath)DO).where(new Predicate[]{BipItemExtRepoProc.DO.bipItemId.in(bipItemIds)}).execute();
    }

    public LocalDateTime getTimeOnShelfPlan(Long id) {
        return (LocalDateTime)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(BipItemExtRepoProc.DO.timeOnShelfPlan).from((EntityPath)DO)).where((Predicate)BipItemExtRepoProc.DO.id.eq((Object)id))).limit(1L)).fetchOne();
    }

    public LocalDateTime getTimeOffShelfPlan(Long id) {
        return (LocalDateTime)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(BipItemExtRepoProc.DO.timeOffShelfPlan).from((EntityPath)DO)).where((Predicate)BipItemExtRepoProc.DO.id.eq((Object)id))).limit(1L)).fetchOne();
    }
}

