/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.service.CustLoginLogService;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustAccountVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustLoginLogRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustLoginLogVO;
import com.elitesland.yst.production.sale.entity.CrmCustDO;
import com.elitesland.yst.production.sale.entity.CustLoginLogDO;
import com.elitesland.yst.production.sale.entity.QCrmCustDO;
import com.elitesland.yst.production.sale.repo.CrmCustRepo;
import com.elitesland.yst.production.sale.repo.CustAccountRepoProc;
import com.elitesland.yst.production.sale.repo.CustLoginLogRepo;
import com.elitesland.yst.production.sale.repo.CustLoginLogRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysUserService;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class CustLoginLogServiceImpl
implements CustLoginLogService {
    private static final Logger log = LoggerFactory.getLogger(CustLoginLogServiceImpl.class);
    private final CustLoginLogRepo custLoginLogRepo;
    private final CustLoginLogRepoProc custLoginLogRepoProc;
    private final CustAccountRepoProc custAccountRepoProc;
    private final RmiSysUserService rmiSysUserService;
    private final CrmCustService crmCustService;
    private final CrmCustRepo crmCustRepo;
    private static final String UN_KNOWN = "unKnown";

    public void save(CustLoginLogVO custLoginLogVO) {
        if (!Objects.isNull(custLoginLogVO)) {
            CustLoginLogDO custLoginLogDO = new CustLoginLogDO();
            custLoginLogDO.setUserId(custLoginLogVO.getUserId());
            custLoginLogDO.setLoginTime(LocalDateTime.now());
            custLoginLogDO.setUserName(custLoginLogVO.getUserName());
            if (StringUtils.isEmpty((CharSequence)custLoginLogVO.getLoginIp())) {
                custLoginLogDO.setLoginIp(this.getIpAddress());
            }
            this.custLoginLogRepo.save(custLoginLogDO);
        }
    }

    public CustLoginLogRespVO getCustLoginInfo(String userName) {
        List<CustLoginLogVO> list = this.custLoginLogRepoProc.getByUserName(userName);
        if (CollUtil.isEmpty(list)) {
            return null;
        }
        CustLoginLogRespVO res = new CustLoginLogRespVO();
        CustLoginLogVO thisLog = list.get(0);
        res.setThisLoginIp(thisLog.getLoginIp());
        res.setThisLoginTime(thisLog.getLoginTime());
        if (list.size() > 1) {
            CustLoginLogVO lastLog = list.get(1);
            res.setLastLoginIp(lastLog.getLoginIp());
            res.setLastLoginTime(lastLog.getLoginTime());
        }
        CustAccountVO custAccountVO = this.custAccountRepoProc.getAccountByUserName(userName);
        res.setRegistTime(custAccountVO.getCreateAccountTime());
        res.setModifyTime(custAccountVO.getUpdatePwdTime());
        res.setBalance(custAccountVO.getBalance());
        CrmCustDO crmCust = this.getBYCustCode(custAccountVO.getCustCode());
        res.setCustType(crmCust.getCustType());
        res.setUserName(userName);
        res.setContactName(crmCust.getContactName());
        res.setMobile(custAccountVO.getMobile());
        return res;
    }

    public CrmCustDO getBYCustCode(String custCode) {
        QCrmCustDO qCrmCustDO = QCrmCustDO.crmCustDO;
        BooleanExpression e = qCrmCustDO.deleteFlag.eq((Object)0).and((Predicate)qCrmCustDO.custCode.eq((Object)custCode));
        Optional optional = this.crmCustRepo.findOne((Predicate)e);
        if (optional.isPresent()) {
            return (CrmCustDO)optional.get();
        }
        return new CrmCustDO();
    }

    private String getIpAddress() {
        if (ObjectUtils.isEmpty((Object)RequestContextHolder.getRequestAttributes())) {
            return null;
        }
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String xip = request.getHeader("X-Real-IP");
        String xFor = request.getHeader("X-Forwarded-For");
        if (!StringUtils.isEmpty((CharSequence)xFor) && !UN_KNOWN.equalsIgnoreCase(xFor)) {
            int index = xFor.indexOf(",");
            if (index != -1) {
                return xFor.substring(0, index);
            }
            return xFor;
        }
        xFor = xip;
        if (!StringUtils.isEmpty((CharSequence)xFor) && !UN_KNOWN.equalsIgnoreCase(xFor)) {
            return xFor;
        }
        if (StringUtils.isEmpty((CharSequence)xFor) || UN_KNOWN.equalsIgnoreCase(xFor)) {
            xFor = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isEmpty((CharSequence)xFor) || UN_KNOWN.equalsIgnoreCase(xFor)) {
            xFor = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isEmpty((CharSequence)xFor) || UN_KNOWN.equalsIgnoreCase(xFor)) {
            xFor = request.getHeader("HTTP_CLIENT_IP");
        }
        if (StringUtils.isEmpty((CharSequence)xFor) || UN_KNOWN.equalsIgnoreCase(xFor)) {
            xFor = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (StringUtils.isEmpty((CharSequence)xFor) || UN_KNOWN.equalsIgnoreCase(xFor)) {
            xFor = request.getRemoteAddr();
        }
        return xFor;
    }

    public CustLoginLogServiceImpl(CustLoginLogRepo custLoginLogRepo, CustLoginLogRepoProc custLoginLogRepoProc, CustAccountRepoProc custAccountRepoProc, RmiSysUserService rmiSysUserService, CrmCustService crmCustService, CrmCustRepo crmCustRepo) {
        this.custLoginLogRepo = custLoginLogRepo;
        this.custLoginLogRepoProc = custLoginLogRepoProc;
        this.custAccountRepoProc = custAccountRepoProc;
        this.rmiSysUserService = rmiSysUserService;
        this.crmCustService = crmCustService;
        this.crmCustRepo = crmCustRepo;
    }
}

