/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.IterUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.LogisticsTemplateDService;
import com.elitesland.yst.production.sale.api.vo.param.logistics.LogisticsTemplateDFindParam;
import com.elitesland.yst.production.sale.api.vo.param.logistics.LogisticsTemplateDetailParam;
import com.elitesland.yst.production.sale.api.vo.param.logistics.LogisticsTemplateDetailSaveParam;
import com.elitesland.yst.production.sale.api.vo.resp.logistics.LogisticsTemplateDVO;
import com.elitesland.yst.production.sale.entity.LogisticsTemplateDDO;
import com.elitesland.yst.production.sale.entity.QLogisticsTemplateDDO;
import com.elitesland.yst.production.sale.repo.LogisticsTemplateDRepo;
import com.elitesland.yst.production.sale.repo.LogisticsTemplateDRepoProc;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class LogisticsTemplateDServiceImpl
implements LogisticsTemplateDService {
    private static final Logger log = LoggerFactory.getLogger(LogisticsTemplateDServiceImpl.class);
    private final LogisticsTemplateDRepoProc logisticsTemplateDRepoProc;
    private final LogisticsTemplateDRepo logisticsTemplateDDRepo;

    @SysCodeProc
    public PagingVO<LogisticsTemplateDVO> findPagingDetailResult(LogisticsTemplateDetailParam param) {
        PagingVO<LogisticsTemplateDVO> list = this.logisticsTemplateDRepoProc.findPagingDetailResult(param);
        return list;
    }

    public ApiResult<Object> saveDetail(List<LogisticsTemplateDetailSaveParam> params) {
        if (!params.isEmpty()) {
            params.stream().forEach(param -> {
                LogisticsTemplateDDO logisticsTemplateDDO = new LogisticsTemplateDDO();
                if (null == param.getId() || param.getId() < 0L) {
                    int max = this.getMaxLineNo(param.getTemplateId());
                    BeanUtils.copyProperties((Object)param, (Object)logisticsTemplateDDO);
                    logisticsTemplateDDO.setLinNo(max + 1);
                } else {
                    Optional optional = this.logisticsTemplateDDRepo.findById(param.getId());
                    if (optional.isPresent()) {
                        logisticsTemplateDDO = (LogisticsTemplateDDO)optional.get();
                        logisticsTemplateDDO.setTemplateId(param.getTemplateId());
                        logisticsTemplateDDO.setAddFreight(param.getAddFreight());
                        logisticsTemplateDDO.setPieceNumber(param.getPieceNumber());
                        logisticsTemplateDDO.setContinuypieceNumber(param.getContinuypieceNumber());
                        logisticsTemplateDDO.setMode(param.getMode());
                    }
                }
                this.logisticsTemplateDDRepo.save(logisticsTemplateDDO);
            });
        }
        return ApiResult.ok();
    }

    public ApiResult<Object> delDetail(List<Long> ids) {
        if (null != ids && !ids.isEmpty()) {
            ids.stream().forEach(id -> this.logisticsTemplateDDRepo.deleteById(id));
        }
        return ApiResult.ok();
    }

    @SysCodeProc
    public List<LogisticsTemplateDVO> getByArea(LogisticsTemplateDFindParam param) {
        if (StringUtils.isBlank((CharSequence)param.getCityCode())) {
            throw new BusinessException("\u5730\u5740\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        QLogisticsTemplateDDO qLogisticsTemplateDDO = QLogisticsTemplateDDO.logisticsTemplateDDO;
        BooleanExpression expression = qLogisticsTemplateDDO.templateId.eq((Object)param.getTemplateId());
        if (StringUtils.isNotBlank((CharSequence)param.getArea())) {
            expression = expression.and((Predicate)qLogisticsTemplateDDO.area.like("%" + param.getArea() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getCityCode())) {
            expression = expression.and((Predicate)qLogisticsTemplateDDO.cityCode.eq((Object)param.getCityCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getProvinceCode())) {
            expression = expression.and((Predicate)qLogisticsTemplateDDO.provinceCode.eq((Object)param.getProvinceCode()));
        }
        Iterable iterables = this.logisticsTemplateDDRepo.findAll((Predicate)expression);
        ArrayList<LogisticsTemplateDVO> resList = new ArrayList<LogisticsTemplateDVO>();
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            ArrayList list = Lists.newArrayList((Iterable)iterables);
            list.stream().forEach(l -> {
                LogisticsTemplateDVO logisticsTemplateDVO = new LogisticsTemplateDVO();
                BeanUtils.copyProperties((Object)l, (Object)logisticsTemplateDVO);
                resList.add(logisticsTemplateDVO);
            });
        }
        return resList;
    }

    public Integer getMaxLineNo(Long templateId) {
        QLogisticsTemplateDDO qLogisticsTemplateDDO = QLogisticsTemplateDDO.logisticsTemplateDDO;
        BooleanExpression expression = qLogisticsTemplateDDO.templateId.eq((Object)templateId);
        Iterable iterables = this.logisticsTemplateDDRepo.findAll((Predicate)expression);
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            ArrayList list = Lists.newArrayList((Iterable)iterables);
            int max = list.stream().mapToInt(l -> l.getLinNo()).max().getAsInt();
            return max;
        }
        return 1;
    }

    public LogisticsTemplateDServiceImpl(LogisticsTemplateDRepoProc logisticsTemplateDRepoProc, LogisticsTemplateDRepo logisticsTemplateDDRepo) {
        this.logisticsTemplateDRepoProc = logisticsTemplateDRepoProc;
        this.logisticsTemplateDDRepo = logisticsTemplateDDRepo;
    }
}

