/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.dto.CustDTO;
import com.elitesland.yst.production.sale.api.service.PriSalePriceService;
import com.elitesland.yst.production.sale.api.service.ZoneSettingService;
import com.elitesland.yst.production.sale.api.service.shop.BipCustUserBindService;
import com.elitesland.yst.production.sale.api.vo.param.pri.PriSalePriceTypeQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.zone.ZoneSettingPageParam;
import com.elitesland.yst.production.sale.api.vo.resp.pri.PriSalePriceTypeRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.zone.ZoneRecParam;
import com.elitesland.yst.production.sale.api.vo.resp.zone.ZoneSaveSettingVO;
import com.elitesland.yst.production.sale.api.vo.resp.zone.ZoneSettingDVO;
import com.elitesland.yst.production.sale.api.vo.resp.zone.ZoneSettingVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.ZoneSettingConvert;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.QZoneSettingDDO;
import com.elitesland.yst.production.sale.entity.ZoneSettingDDO;
import com.elitesland.yst.production.sale.entity.ZoneSettingDO;
import com.elitesland.yst.production.sale.repo.ZoneSettingDRepo;
import com.elitesland.yst.production.sale.repo.ZoneSettingDRepoProc;
import com.elitesland.yst.production.sale.repo.ZoneSettingRepo;
import com.elitesland.yst.production.sale.repo.ZoneSettingRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepo;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.support.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgBuRpcService;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ZoneSettingServiceImpl
implements ZoneSettingService {
    private static final Logger log = LoggerFactory.getLogger(ZoneSettingServiceImpl.class);
    private final OrgBuRpcService orgBuRpcService;
    private final ZoneSettingRepoProc zoneSettingRepoProc;
    private final ZoneSettingRepo zoneSettingRepo;
    private final OrgEmpRpcService orgEmpRpcService;
    private final ZoneSettingDRepo zoneSettingDRepo;
    private final ZoneSettingDRepoProc zoneSettingDRepoProc;
    private final RmiSysNextNumberService rmiSysNextNumberService;
    private final BipItemRepoProc bipItemRepoProc;
    private final BipCustUserBindRepoProc bipCustUserBindRepoProc;
    private final BipCustUserBindService custUserBindService;
    private final PriSalePriceService salePriceService;
    private final BipItemSkuRepo bipItemSkuRepo;

    @SysCodeProc
    public PagingVO<ZoneSettingVO> findZonePagingResult(ZoneSettingPageParam param) {
        PagingVO<ZoneSettingVO> list = this.zoneSettingRepoProc.findPagingResult(param);
        return list;
    }

    @SysCodeProc
    public ZoneSettingVO findZoneById(Long id) {
        Optional optional = this.zoneSettingRepo.findById(id);
        if (optional.isPresent()) {
            ZoneSettingDO zoneSettingDO = (ZoneSettingDO)optional.get();
            ZoneSettingVO vo = new ZoneSettingVO();
            BeanUtils.copyProperties((Object)zoneSettingDO, (Object)vo);
            ArrayList resList = new ArrayList();
            List<ZoneSettingDDO> list = this.getByZoneId(id);
            if (null != list) {
                list.stream().forEach(ddo -> {
                    if (null != ddo.getState() && ddo.getState().equals(UdcEnum.BIP_ITEM_STATE_SHELF.getValueCode())) {
                        ZoneSettingDVO zoneSettingDVO = new ZoneSettingDVO();
                        BeanUtils.copyProperties((Object)ddo, (Object)zoneSettingDVO);
                        zoneSettingDVO.setItemId(ddo.getItemId());
                        resList.add(zoneSettingDVO);
                    }
                });
                if (null != resList && !resList.isEmpty()) {
                    vo.setList(resList.stream().sorted(Comparator.comparing(ZoneSettingDVO::getSort)).collect(Collectors.toList()));
                }
            }
            return vo;
        }
        return null;
    }

    public List<ZoneSettingDDO> getByZoneId(Long zoneId) {
        QZoneSettingDDO qZoneSettingDDO = QZoneSettingDDO.zoneSettingDDO;
        BooleanExpression expression = qZoneSettingDDO.zoneId.eq((Object)zoneId).and((Predicate)qZoneSettingDDO.deleteFlag.eq((Object)0));
        Iterable iterables = this.zoneSettingDRepo.findAll((Predicate)expression);
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            return Lists.newArrayList((Iterable)iterables);
        }
        return null;
    }

    public ApiResult<Object> addOrUpdateZone(ZoneSaveSettingVO param) {
        log.info("\u4e13\u533a\u65b0\u589e\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)param));
        ZoneSettingDO zoneSettingDO = new ZoneSettingDO();
        if (null == param.getId() || param.getId() < 0L) {
            BeanUtils.copyProperties((Object)param, (Object)zoneSettingDO);
            OrgUserEmpInfoRpcDTO empInfo = this.getCurrentEmpInfo();
            zoneSettingDO.setSecBuId(empInfo.getBuId());
            zoneSettingDO.setSecOuId(empInfo.getOuId());
            zoneSettingDO.setSecUserId(empInfo.getUserId());
            zoneSettingDO.setOuId(param.getOuId());
            zoneSettingDO.setOuName(param.getOuName());
            String logisticsCode = this.rmiSysNextNumberService.generateCode("yst-sale", "ZONE_SETTING", new ArrayList<String>());
            zoneSettingDO.setZoneCode(logisticsCode);
            zoneSettingDO.setStatus(UdcEnum.SAL_ZONE_STATUS_DRAFT.getValueCode());
            zoneSettingDO = (ZoneSettingDO)this.zoneSettingRepo.save(zoneSettingDO);
        } else {
            Optional optional = this.zoneSettingRepo.findById(param.getId());
            if (optional.isPresent()) {
                zoneSettingDO = (ZoneSettingDO)optional.get();
                zoneSettingDO.setZoneCode(param.getZoneCode());
                zoneSettingDO.setZoneName(param.getZoneName());
                zoneSettingDO.setSort(param.getSort());
                zoneSettingDO.setOuId(param.getOuId());
                zoneSettingDO.setOuName(param.getOuName());
                zoneSettingDO = (ZoneSettingDO)this.zoneSettingRepo.save(zoneSettingDO);
                if (null != param.getList() && !param.getList().isEmpty()) {
                    QZoneSettingDDO qZoneSettingDDO = QZoneSettingDDO.zoneSettingDDO;
                    BooleanExpression expression = qZoneSettingDDO.zoneId.eq((Object)zoneSettingDO.getId());
                    Iterable iterables = this.zoneSettingDRepo.findAll((Predicate)expression);
                    if (!IterUtil.isEmpty((Iterable)iterables)) {
                        ArrayList list = Lists.newArrayList((Iterable)iterables);
                        list.stream().forEach(l -> {
                            l.setDeleteFlag(1);
                            this.zoneSettingDRepo.save(l);
                        });
                    }
                }
            }
        }
        if (null != param.getList() && !param.getList().isEmpty()) {
            ZoneSettingDO finalZoneSettingDO = zoneSettingDO;
            param.getList().stream().forEach(p -> {
                ZoneSettingDDO zoneSettingDDO = new ZoneSettingDDO();
                BeanUtils.copyProperties((Object)p, (Object)zoneSettingDDO);
                zoneSettingDDO.setOuId(param.getOuId());
                zoneSettingDDO.setOuName(param.getOuName());
                zoneSettingDDO.setZoneId(finalZoneSettingDO.getId());
                zoneSettingDDO.setItemAttr(p.getItemAttr());
                zoneSettingDDO.setItemCode(p.getItemCode());
                zoneSettingDDO.setItemBrand(p.getItemBrand());
                zoneSettingDDO.setCategoryName(p.getCategoryName());
                zoneSettingDDO.setItemId(p.getItemId());
                Assert.notNull((Object)zoneSettingDDO.getItemId(), (String)("\u5546\u54c1\u3010" + p.getItemName() + "\u3011\u7684ID\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
                Assert.notBlank((CharSequence)zoneSettingDDO.getItemCode(), (String)("\u5546\u54c1\u3010" + p.getItemName() + "\u3011\u7684\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
                if (StringUtils.isBlank((CharSequence)p.getState())) {
                    zoneSettingDDO.setState(UdcEnum.BIP_ITEM_STATE_SHELF.getValueCode());
                }
                this.zoneSettingDRepo.save(zoneSettingDDO);
            });
        }
        return ApiResult.ok();
    }

    public ApiResult<Object> delZone(List<Long> ids) {
        QZoneSettingDDO qZoneSettingDDO = QZoneSettingDDO.zoneSettingDDO;
        ids.stream().forEach(id -> {
            Optional optional = this.zoneSettingRepo.findById(id);
            if (optional.isPresent()) {
                ZoneSettingDO zoneSettingDO = (ZoneSettingDO)optional.get();
                zoneSettingDO.setDeleteFlag(1);
                this.zoneSettingRepo.save(zoneSettingDO);
                BooleanExpression expression = qZoneSettingDDO.zoneId.eq(id);
                Iterable iterables = this.zoneSettingDRepo.findAll((Predicate)expression);
                if (!IterUtil.isEmpty((Iterable)iterables)) {
                    ArrayList list = Lists.newArrayList((Iterable)iterables);
                    list.stream().forEach(l -> {
                        l.setDeleteFlag(1);
                        this.zoneSettingDRepo.save(l);
                    });
                }
            }
        });
        return ApiResult.ok();
    }

    public ApiResult<Object> activeZone(List<Long> ids) {
        ids.stream().forEach(id -> {
            Optional optional = this.zoneSettingRepo.findById(id);
            ZoneSettingDO zoneSettingDO = (ZoneSettingDO)optional.get();
            zoneSettingDO.setStatus(UdcEnum.SAL_ZONE_STATUS_ACTIVE.getValueCode());
            this.zoneSettingRepo.save(zoneSettingDO);
        });
        return ApiResult.ok();
    }

    public ApiResult<Object> closedZone(List<Long> ids) {
        ids.stream().forEach(id -> {
            Optional optional = this.zoneSettingRepo.findById(id);
            ZoneSettingDO zoneSettingDO = (ZoneSettingDO)optional.get();
            zoneSettingDO.setStatus(UdcEnum.SAL_ZONE_STATUS_CLOSED.getValueCode());
            this.zoneSettingRepo.save(zoneSettingDO);
        });
        return ApiResult.ok();
    }

    public List<ZoneSettingVO> homeRecommend(ZoneRecParam param) {
        List<ZoneSettingDO> all = this.zoneSettingRepo.findAllByOuIdAndStatus(param.getOuId(), UdcEnum.SAL_ZONE_STATUS_ACTIVE.getValueCode());
        if (CollUtil.isEmpty(all)) {
            return new ArrayList<ZoneSettingVO>();
        }
        ZoneSettingConvert zoneSettingConvert = ZoneSettingConvert.INSTANCE;
        ArrayList<ZoneSettingVO> zoneSettingVOS = new ArrayList<ZoneSettingVO>();
        for (ZoneSettingVO zoneSettingVO : zoneSettingConvert.dosToVos(all)) {
            if (zoneSettingVO.getSort() == null) {
                zoneSettingVO.setSort(Integer.valueOf(999));
            }
            zoneSettingVOS.add(zoneSettingVO);
        }
        zoneSettingVOS.sort(Comparator.comparing(ZoneSettingVO::getSort));
        param.setCurrent(Integer.valueOf(1));
        param.setSize(Integer.valueOf(6));
        this.setZoneDetail(zoneSettingVOS, param);
        return zoneSettingVOS;
    }

    public ZoneSettingVO getRecommendForMore(ZoneRecParam param) {
        log.info("\u9996\u9875\u4e13\u533a\u5165\u53c2\uff1a" + JSON.toJSONString((Object)param));
        ZoneSettingDO zoneSettingDO = (ZoneSettingDO)this.zoneSettingRepo.findById(param.getZoneId()).orElseThrow(() -> {
            throw new BusinessException("\u672a\u627e\u5230\u8be5\u4e13\u533a\uff1a" + param.getZoneId());
        });
        List<ZoneSettingDO> dos = Collections.singletonList(zoneSettingDO);
        ZoneSettingConvert zoneSettingConvert = ZoneSettingConvert.INSTANCE;
        List<ZoneSettingVO> zoneSettingVOS = zoneSettingConvert.dosToVos(dos).stream().sorted(Comparator.comparing(ZoneSettingVO::getSort)).collect(Collectors.toList());
        log.info("\u9996\u9875\u4e13\u533a\u4e3b\u8868\uff1a" + JSON.toJSONString(zoneSettingVOS));
        this.setZoneDetail(zoneSettingVOS, param);
        return zoneSettingVOS.get(0);
    }

    private void setZoneDetail(List<ZoneSettingVO> zoneSettingVOS, ZoneRecParam param) {
    }

    private void convertCustPrice(List<ZoneSettingDVO> respVOList) {
        CurrentUserDTO user = UserService.currentUser();
        if (user == null) {
            return;
        }
        CustDTO cust = (CustDTO)this.custUserBindService.getCustOfUserBind(user.getUserId()).getData();
        if (cust == null || StringUtils.isBlank((CharSequence)cust.getCustLevel())) {
            return;
        }
        for (ZoneSettingDVO resp : respVOList) {
            PriSalePriceTypeQueryParam param = new PriSalePriceTypeQueryParam();
            param.setPriceType(UdcEnum.PRI_SALE_PRICE_TYPE_GROUP.getValueCode());
            param.setCustLevel(cust.getCustLevel());
            param.setCurrCode(resp.getCurrCode());
            param.setOuId(cust.getOuId());
            resp.getSupportItems().stream().map(item -> {
                param.setItemId(item.getId());
                param.setUom(item.getUom());
                PriSalePriceTypeRespVO vo = this.salePriceService.queryPrice(param);
                log.info("\u83dc\u5355\u8be6\u60c5\u6700\u5c0f\u5ba2\u6237\u7b49\u7ea7\u4ef7\u683c\uff1a" + JSON.toJSONString((Object)vo));
                return vo;
            }).filter(Objects::nonNull).map(PriSalePriceTypeRespVO::getPrice).min(BigDecimal::compareTo).ifPresentOrElse(arg_0 -> ((ZoneSettingDVO)resp).setPriceCust(arg_0), () -> resp.setPriceCust(null));
        }
    }

    private void convertBasePrice(List<ZoneSettingDVO> respVOList, Long ouId) {
        Assert.notNull((Object)ouId, (String)"\u4e13\u533a\u5217\u8868\u7684\u5546\u54c1\u67e5\u8be2\u57fa\u7840\u4ef7\u683c\u65f6\u516c\u53f8ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (ZoneSettingDVO resp : respVOList) {
            PriSalePriceTypeQueryParam param = new PriSalePriceTypeQueryParam();
            param.setPriceType(UdcEnum.PRI_SALE_PRICE_TYPE_BASE.getValueCode());
            param.setCurrCode(resp.getCurrCode());
            param.setOuId(ouId);
            resp.getSupportItems().stream().map(item -> {
                param.setItemId(item.getId());
                param.setUom(item.getUom());
                PriSalePriceTypeRespVO vo = this.salePriceService.queryPrice(param);
                log.info("\u4e13\u533a\u6700\u5c0f\u57fa\u7840\u4ef7\u683c\uff1a" + JSON.toJSONString((Object)vo));
                return vo;
            }).filter(Objects::nonNull).map(PriSalePriceTypeRespVO::getPrice).min(BigDecimal::compareTo).ifPresentOrElse(arg_0 -> ((ZoneSettingDVO)resp).setPrice(arg_0), () -> resp.setPrice(null));
        }
    }

    private OrgUserEmpInfoRpcDTO getCurrentEmpInfo() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u5df2\u5931\u6548,\u8bf7\u91cd\u767b\u5f55\u91cd\u8bd5");
        }
        OrgUserEmpInfoRpcDTO userEmpInfo = this.orgEmpRpcService.findUserEmpInfo(currentUser.getUserId());
        if (userEmpInfo == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f");
        }
        return userEmpInfo;
    }

    public ZoneSettingServiceImpl(OrgBuRpcService orgBuRpcService, ZoneSettingRepoProc zoneSettingRepoProc, ZoneSettingRepo zoneSettingRepo, OrgEmpRpcService orgEmpRpcService, ZoneSettingDRepo zoneSettingDRepo, ZoneSettingDRepoProc zoneSettingDRepoProc, RmiSysNextNumberService rmiSysNextNumberService, BipItemRepoProc bipItemRepoProc, BipCustUserBindRepoProc bipCustUserBindRepoProc, BipCustUserBindService custUserBindService, PriSalePriceService salePriceService, BipItemSkuRepo bipItemSkuRepo) {
        this.orgBuRpcService = orgBuRpcService;
        this.zoneSettingRepoProc = zoneSettingRepoProc;
        this.zoneSettingRepo = zoneSettingRepo;
        this.orgEmpRpcService = orgEmpRpcService;
        this.zoneSettingDRepo = zoneSettingDRepo;
        this.zoneSettingDRepoProc = zoneSettingDRepoProc;
        this.rmiSysNextNumberService = rmiSysNextNumberService;
        this.bipItemRepoProc = bipItemRepoProc;
        this.bipCustUserBindRepoProc = bipCustUserBindRepoProc;
        this.custUserBindService = custUserBindService;
        this.salePriceService = salePriceService;
        this.bipItemSkuRepo = bipItemSkuRepo;
    }
}

