/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.common;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.sale.api.service.common.DeAccountRoleService;
import com.elitesland.yst.production.sale.api.vo.param.com.DeAccountRoleParam;
import com.elitesland.yst.production.sale.api.vo.resp.com.DeAccountRoleVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustAccountVO;
import com.elitesland.yst.production.sale.convert.CustAccountConvert;
import com.elitesland.yst.production.sale.entity.CustAccountDO;
import com.elitesland.yst.production.sale.repo.CustAccountRepoProc;
import com.elitesland.yst.production.sale.repo.common.DeAccountRoleRepoProc;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DeAcountRoleServiceImpl
implements DeAccountRoleService {
    private static final Logger log = LoggerFactory.getLogger(DeAcountRoleServiceImpl.class);
    private final DeAccountRoleRepoProc deAccountRoleRepoProc;
    private final CustAccountRepoProc custAccountRepoProc;

    public List<DeAccountRoleVO> getRole(DeAccountRoleParam param) {
        CustAccountVO custAccountInfo = this.getCustAccountInfo();
        param.setDealerType(custAccountInfo.getDealerType());
        param.setBusinessType(custAccountInfo.getBusinessType());
        List<DeAccountRoleVO> role = this.deAccountRoleRepoProc.getRole(param);
        return role;
    }

    private CustAccountVO getCustAccountInfo() {
        CustAccountConvert custAccountConvert = CustAccountConvert.INSTANCE;
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (Objects.isNull(userDetails) || Objects.isNull(userDetails.getUser())) {
            throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        SysUserDTO sysUser = userDetails.getUser();
        if (ObjectUtils.isEmpty((Object)sysUser)) {
            throw new BusinessException("\u7528\u6237\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
        }
        CustAccountDO byUserName = this.custAccountRepoProc.getByUserName(sysUser.getUsername());
        return custAccountConvert.doToVO(byUserName);
    }

    public DeAcountRoleServiceImpl(DeAccountRoleRepoProc deAccountRoleRepoProc, CustAccountRepoProc custAccountRepoProc) {
        this.deAccountRoleRepoProc = deAccountRoleRepoProc;
        this.custAccountRepoProc = custAccountRepoProc;
    }
}

