/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.shop.BipCompanyManageService;
import com.elitesland.yst.production.sale.api.service.shop.BipHelpCenterService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipHelpCreateParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipHelpQueryParam;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipHelpCenterRespVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.BipHelpConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.BipHelpCenterDO;
import com.elitesland.yst.production.sale.entity.QBipHelpCenterDO;
import com.elitesland.yst.production.sale.repo.shop.BipHelpCenterRepo;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class BipHelpCenterServiceImpl
extends BaseServiceImpl
implements BipHelpCenterService {
    private static final Logger log = LoggerFactory.getLogger(BipHelpCenterServiceImpl.class);
    private final BipHelpCenterRepo bipHelpCenterRepo;
    private static final QBipHelpCenterDO qBipHelpCenterDo = QBipHelpCenterDO.bipHelpCenterDO;
    private final RmiSysNextNumberService rmiSysNextNumberService;
    private final OrgEmpRpcService orgEmpRpcService;
    private final BipCompanyManageService bipCompanyManageService;

    public List<BipHelpCenterRespVO> appfindAll() {
        BipHelpCenterServiceImpl.checkUser();
        JPAQuery<BipHelpCenterRespVO> title = this.appletsFindTitle();
        return title.fetch();
    }

    public BipHelpCenterRespVO getHelpById(Long id) {
        BipHelpCenterServiceImpl.checkUser();
        JPAQuery<BipHelpCenterRespVO> byId = this.findTitleById(id);
        List fetch = byId.fetch();
        if (fetch.isEmpty()) {
            throw new BusinessException("\u6ca1\u6709\u6b64\u6761\u6570\u636e");
        }
        return (BipHelpCenterRespVO)fetch.get(0);
    }

    public PagingVO<BipHelpCenterRespVO> findAll(BipHelpQueryParam param) {
        JPAQuery<BipHelpCenterRespVO> jpaQuery = this.findHelps(param);
        List fetch = jpaQuery.fetch();
        long total = jpaQuery.fetchCount();
        PageRequest pageRequest = this.wrapperPageRequest(param.getPageRequest(), null);
        this.appendPageAndSort(jpaQuery, pageRequest, qBipHelpCenterDo);
        return PagingVO.builder().total(total).records(fetch).build();
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateStatus(Long id, String status) {
        this.jpaQueryFactory.update((EntityPath)qBipHelpCenterDo).set((Path)BipHelpCenterServiceImpl.qBipHelpCenterDo.status, (Object)status).where(new Predicate[]{BipHelpCenterServiceImpl.qBipHelpCenterDo.id.eq((Object)id)}).execute();
        return id;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateDeleteFlag(Long id, Integer deleteFlag) {
        this.jpaQueryFactory.update((EntityPath)qBipHelpCenterDo).set(BipHelpCenterServiceImpl.qBipHelpCenterDo.deleteFlag, (Object)deleteFlag).where(new Predicate[]{BipHelpCenterServiceImpl.qBipHelpCenterDo.id.eq((Object)id)}).execute();
        return id;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long saveHelp(BipHelpCreateParam param) {
        Assert.isFalse((boolean)StringUtils.isEmpty((Object)param.getTitle()), (String)"\u6587\u6863\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isFalse((boolean)StringUtils.isEmpty((Object)param.getContestStruct()), (String)"\u6587\u6863\u5185\u5bb9\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u5df2\u5931\u6548,\u8bf7\u91cd\u767b\u5f55\u91cd\u8bd5");
        }
        BipHelpConvert convert = BipHelpConvert.INSTANCE;
        BipHelpCenterDO bipHelpCenterDO = convert.creatParamToDo(param);
        if (StringUtils.isEmpty((Object)param.getFileCode())) {
            String fileCode = this.rmiSysNextNumberService.generateCode("yst-sale", "tx", null);
            bipHelpCenterDO.setFileCode(fileCode);
        }
        return ((BipHelpCenterDO)this.bipHelpCenterRepo.save(bipHelpCenterDO)).getId();
    }

    JPAQuery<BipHelpCenterRespVO> appletsFindTitle() {
        return (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BipHelpCenterRespVO.class, (Expression[])new Expression[]{BipHelpCenterServiceImpl.qBipHelpCenterDo.id, BipHelpCenterServiceImpl.qBipHelpCenterDo.fileCode, BipHelpCenterServiceImpl.qBipHelpCenterDo.title})).from((EntityPath)qBipHelpCenterDo)).where((Predicate)BipHelpCenterServiceImpl.qBipHelpCenterDo.status.eq((Object)UdcEnum.BIP_HELP_STATUS_TRUE.getValueCode()));
    }

    JPAQuery<BipHelpCenterRespVO> findTitleById(Long id) {
        return (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BipHelpCenterRespVO.class, (Expression[])new Expression[]{BipHelpCenterServiceImpl.qBipHelpCenterDo.id, BipHelpCenterServiceImpl.qBipHelpCenterDo.fileCode, BipHelpCenterServiceImpl.qBipHelpCenterDo.context, BipHelpCenterServiceImpl.qBipHelpCenterDo.contestStruct, BipHelpCenterServiceImpl.qBipHelpCenterDo.status, BipHelpCenterServiceImpl.qBipHelpCenterDo.title})).from((EntityPath)qBipHelpCenterDo)).where((Predicate)BipHelpCenterServiceImpl.qBipHelpCenterDo.id.eq((Object)id));
    }

    JPAQuery<BipHelpCenterRespVO> findHelps(BipHelpQueryParam param) {
        BooleanExpression predicate = qBipHelpCenterDo.isNotNull();
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BipHelpCenterRespVO.class, (Expression[])new Expression[]{BipHelpCenterServiceImpl.qBipHelpCenterDo.id, BipHelpCenterServiceImpl.qBipHelpCenterDo.fileCode, BipHelpCenterServiceImpl.qBipHelpCenterDo.context, BipHelpCenterServiceImpl.qBipHelpCenterDo.contestStruct, BipHelpCenterServiceImpl.qBipHelpCenterDo.title, BipHelpCenterServiceImpl.qBipHelpCenterDo.status, BipHelpCenterServiceImpl.qBipHelpCenterDo.createTime})).from((EntityPath)qBipHelpCenterDo);
        if (!StringUtils.isEmpty((Object)param.getStatus())) {
            jpaQuery.where(new Predicate[]{predicate, BipHelpCenterServiceImpl.qBipHelpCenterDo.status.eq((Object)param.getStatus())});
        }
        return jpaQuery;
    }

    private static CurrentUserDTO checkUser() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u5230\u83b7\u53d6\u5f53\u524d\u7528\u6237\u8bf7\u5148\u767b\u5f55");
        }
        return currentUser;
    }

    public BipHelpCenterServiceImpl(BipHelpCenterRepo bipHelpCenterRepo, RmiSysNextNumberService rmiSysNextNumberService, OrgEmpRpcService orgEmpRpcService, BipCompanyManageService bipCompanyManageService) {
        this.bipHelpCenterRepo = bipHelpCenterRepo;
        this.rmiSysNextNumberService = rmiSysNextNumberService;
        this.orgEmpRpcService = orgEmpRpcService;
        this.bipCompanyManageService = bipCompanyManageService;
    }
}

